/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.CryptKeyAuthInterface;
import agorum.roi.ejb.common.CryptKeyController;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SessionController;
import java.io.Serializable;

public class TestCryptKeys
implements Serializable,
CryptKeyAuthInterface {
    private SessionController sessionController = null;
    private boolean privilegedForCrypting = false;

    public TestCryptKeys(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void testCreateCryptKeyPair() throws Exception {
        CryptKeyController keyController = new CryptKeyController();
        this.privilegedForCrypting = true;
        keyController.createCryptKeyPair("metadb", this, this.sessionController);
        this.privilegedForCrypting = false;
    }

    public void testGetPublicKey() throws Exception {
        CryptKeyController keyController = new CryptKeyController();
        this.privilegedForCrypting = true;
        byte[] key = keyController.getPublicKey("master", this.sessionController);
        this.privilegedForCrypting = false;
        System.out.println("Public key: " + new String(key));
    }

    public String testEncrypt(String str, String ident) throws Exception {
        CryptKeyController keyController = new CryptKeyController();
        this.privilegedForCrypting = true;
        String encrypted = keyController.encrypt(str, ident, this.sessionController);
        this.privilegedForCrypting = false;
        return encrypted;
    }

    public String testDecrypt(String str, String ident) throws Exception {
        CryptKeyController keyController = new CryptKeyController();
        this.privilegedForCrypting = true;
        String decrypted = keyController.unencrypt(str, ident, this, this.sessionController);
        this.privilegedForCrypting = false;
        return decrypted;
    }

    public void testRegisterClass(String ident, String className) throws Exception {
        CryptKeyController keyController = new CryptKeyController();
        this.privilegedForCrypting = true;
        keyController.registerClass(ident, className, "master", this, this.sessionController);
        this.privilegedForCrypting = false;
    }

    public void testUnregisterClass(String ident, String className) throws Exception {
        CryptKeyController keyController = new CryptKeyController();
        this.privilegedForCrypting = true;
        keyController.unregisterClass(ident, className, "master", this, this.sessionController);
        this.privilegedForCrypting = false;
    }

    @Override
    public boolean isPrivilegedForCrypting() {
        return this.privilegedForCrypting;
    }

    public static void main(String[] args) {
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setPassWord(rp.getRoiSystemPassword());
            credential.setModulInfo("TestCryptKeys");
            SessionController sessionController = SessionController.connect(credential);
            TestCryptKeys testCryptKeys = new TestCryptKeys(sessionController);
            String str = "Das ist ein einfacher String--.";
            TestCryptKeys testCryptKeys2 = new TestCryptKeys(sessionController);
            MetaDb metaDb = null;
            String mdbValue = null;
            try {
                metaDb = sessionController.getMetaDbInstance();
                mdbValue = metaDb.getSimplePropertyValue("MAIN_TEST/Crypted")[0];
            }
            catch (MetaDbException me) {
                me.printStackTrace(System.err);
            }
            System.out.println("MetaDb value: " + mdbValue);
            TestCryptKeys testCryptKeys3 = new TestCryptKeys(sessionController);
            String decryptedMdbValue = testCryptKeys3.testDecrypt(mdbValue, "metadb");
            System.out.println("Decrypted MetaDb value: " + decryptedMdbValue + "\n\n");
            String str2 = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567";
            TestCryptKeys testCryptKeys4 = new TestCryptKeys(sessionController);
            String encryptedStr2 = testCryptKeys4.testEncrypt(str2, "metadb");
            System.out.println("Encrypted value2: " + encryptedStr2);
            String decryptedStr2 = testCryptKeys4.testDecrypt(encryptedStr2, "metadb");
            System.out.println("Decrypted value2: " + decryptedStr2);
            System.out.println("Fertig...");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception: " + e.getMessage());
        }
        System.exit(0);
    }
}

