/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.AttributeAddArrayBean;
import agorum.roi.ejb.common.AttributeInsertArrayAtBean;
import agorum.roi.ejb.common.AttributeRemoveArrayAtBean;
import agorum.roi.ejb.common.AttributeRemoveArrayBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.SessionController;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class SuperObjectClientBeanDefinition
implements Serializable {
    private Hashtable attributes = new Hashtable();
    private Long id = null;
    private Long classId = null;
    private Hashtable systemOptions = new Hashtable();
    private Hashtable addArrayElementHash = new Hashtable();
    protected Hashtable attributesBeforUpdate = new Hashtable();
    public static final String KEY_ADDARRAYELEMET = "@addArrayElement@";
    public static final String KEY_INSERTARRAYELEMETAT = "@insertArrayElementAt@";
    public static final String KEY_REMOVEARRAYELEMETAT = "@removeArrayElementAt@";
    public static final String KEY_REMOVEARRAYELEMET = "@removeArrayElement@";
    protected SessionController sessionController = null;

    public SuperObjectClientBeanDefinition(SessionController sessionController, Long classId) throws Exception {
        this.sessionController = sessionController;
        this.classId = classId;
        this.setAttribute(SuperObjectClientBean.CLASSID_ATTRIBUTE, AttributeValue.newAttributeValueObject(classId));
    }

    public SuperObjectClientBeanDefinition(SessionController sessionController, Long classId, boolean noClassId) throws Exception {
        this.sessionController = sessionController;
        this.classId = classId;
    }

    public SuperObjectClientBeanDefinition(SessionController sessionController, String className) throws Exception {
        this.sessionController = sessionController;
        ClassObjectClientBean co = sessionController.getClassObject(className);
        this.classId = co.getId();
        this.setAttribute(SuperObjectClientBean.CLASSID_ATTRIBUTE, AttributeValue.newAttributeValueObject(this.classId));
    }

    private AttributeValue convertValue(int typeShould, int typeIs, AttributeValue value) throws Exception {
        AttributeValue vRet = value;
        if (typeIs == 4 && typeShould == 5) {
            return AttributeValue.newAttributeValueObject(new Double(value.getDouble()).intValue());
        }
        if (typeIs == 4 && typeShould == 8) {
            return AttributeValue.newAttributeValueObject(new Double(value.getDouble()).longValue());
        }
        return vRet;
    }

    public void setAttribute(String attribute, AttributeValue value) throws Exception {
        Hashtable subHash;
        AttributeObjectClientBean attrObj;
        Long classIdTmp = this.sessionController.findClassIdByAttribute(attribute, this.classId);
        ClassObjectClientBean co = this.sessionController.getClassObject(classIdTmp);
        Hashtable effAttributes = co.getEffectiveAttributes();
        if (value != null && effAttributes != null && (attrObj = (AttributeObjectClientBean)effAttributes.get(attribute.toUpperCase())) != null && attrObj.getDataTypeInt() != value.getDataTypeInt() && !(value instanceof AttributeValueArray)) {
            value = this.convertValue(attrObj.getDataTypeInt(), value.getDataTypeInt(), value);
        }
        if (!this.attributes.containsKey(classIdTmp)) {
            this.attributes.put(classIdTmp, new Hashtable());
        }
        if ((subHash = (Hashtable)this.attributes.get(classIdTmp)).containsKey(attribute)) {
            subHash.remove(attribute);
        }
        if (value != null) {
            subHash.put(attribute, value);
        }
    }

    public void removeAttribute(String attribute) throws Exception {
        Hashtable subHash;
        Long classIdTmp = this.sessionController.findClassIdByAttribute(attribute, this.classId);
        if (!this.attributes.containsKey(classIdTmp)) {
            this.attributes.put(classIdTmp, new Hashtable());
        }
        if ((subHash = (Hashtable)this.attributes.get(classIdTmp)).containsKey(attribute)) {
            subHash.remove(attribute);
        }
    }

    public void setAttributeBeforUpdate(String attribute, AttributeValue value) throws Exception {
        Hashtable subHash;
        Long classIdTmp = this.sessionController.findClassIdByAttribute(attribute, this.classId);
        if (!this.attributesBeforUpdate.containsKey(classIdTmp)) {
            this.attributesBeforUpdate.put(classIdTmp, new Hashtable());
        }
        if ((subHash = (Hashtable)this.attributesBeforUpdate.get(classIdTmp)).containsKey(attribute)) {
            subHash.remove(attribute);
        }
        if (value != null) {
            subHash.put(attribute, value);
        }
    }

    public void addArrayElement(String attribute, AttributeValue value) throws Exception {
        Long classIdTmp = this.sessionController.findClassIdByAttribute(attribute, this.classId);
        if (!this.attributes.containsKey(classIdTmp)) {
            this.attributes.put(classIdTmp, new Hashtable());
        }
        Hashtable subHash = (Hashtable)this.attributes.get(classIdTmp);
        String key = KEY_ADDARRAYELEMET;
        if (!subHash.containsKey(KEY_ADDARRAYELEMET)) {
            subHash.put(key, new Vector());
        }
        Vector v = (Vector)subHash.get(KEY_ADDARRAYELEMET);
        if (value != null) {
            AttributeAddArrayBean attributeAddArrayBean = new AttributeAddArrayBean();
            attributeAddArrayBean.setAttributeName(attribute);
            attributeAddArrayBean.setAttributeValue(value);
            v.addElement(attributeAddArrayBean);
        }
    }

    public void insertArrayElementAt(String attribute, AttributeValue value, long pos) throws Exception {
        Long classIdTmp = this.sessionController.findClassIdByAttribute(attribute, this.classId);
        if (!this.attributes.containsKey(classIdTmp)) {
            this.attributes.put(classIdTmp, new Hashtable());
        }
        Hashtable subHash = (Hashtable)this.attributes.get(classIdTmp);
        String key = KEY_INSERTARRAYELEMETAT;
        if (!subHash.containsKey(KEY_INSERTARRAYELEMETAT)) {
            subHash.put(key, new Vector());
        }
        Vector v = (Vector)subHash.get(KEY_INSERTARRAYELEMETAT);
        if (value != null) {
            AttributeInsertArrayAtBean attributeInsertArrayAtBean = new AttributeInsertArrayAtBean();
            attributeInsertArrayAtBean.setAttributeName(attribute);
            attributeInsertArrayAtBean.setAttributeValue(value);
            attributeInsertArrayAtBean.setAttributePos(pos);
            v.addElement(attributeInsertArrayAtBean);
        }
    }

    public void removeArrayElementAt(String attribute, long pos) throws Exception {
        Long classIdTmp = this.sessionController.findClassIdByAttribute(attribute, this.classId);
        if (!this.attributes.containsKey(classIdTmp)) {
            this.attributes.put(classIdTmp, new Hashtable());
        }
        Hashtable subHash = (Hashtable)this.attributes.get(classIdTmp);
        String key = KEY_REMOVEARRAYELEMETAT;
        if (!subHash.containsKey(KEY_REMOVEARRAYELEMETAT)) {
            subHash.put(key, new Vector());
        }
        Vector v = (Vector)subHash.get(KEY_REMOVEARRAYELEMETAT);
        AttributeRemoveArrayAtBean attributeRemoveArrayAtBean = new AttributeRemoveArrayAtBean();
        attributeRemoveArrayAtBean.setAttributeName(attribute);
        attributeRemoveArrayAtBean.setAttributePos(pos);
        v.addElement(attributeRemoveArrayAtBean);
    }

    public void removeArrayElement(String attribute, AttributeValue value) throws Exception {
        Long classIdTmp = this.sessionController.findClassIdByAttribute(attribute, this.classId);
        if (!this.attributes.containsKey(classIdTmp)) {
            this.attributes.put(classIdTmp, new Hashtable());
        }
        Hashtable subHash = (Hashtable)this.attributes.get(classIdTmp);
        String key = KEY_REMOVEARRAYELEMET;
        if (!subHash.containsKey(KEY_REMOVEARRAYELEMET)) {
            subHash.put(key, new Vector());
        }
        Vector v = (Vector)subHash.get(KEY_REMOVEARRAYELEMET);
        AttributeRemoveArrayBean attributeRemoveArrayBean = new AttributeRemoveArrayBean();
        attributeRemoveArrayBean.setAttributeName(attribute);
        attributeRemoveArrayBean.setAttributeValue(value);
        v.addElement(attributeRemoveArrayBean);
    }

    public AttributeValue getAttribute(String attribute) throws Exception {
        Long classIdTmp = this.sessionController.findClassIdByAttribute(attribute, this.classId);
        if (classIdTmp == null || !this.attributes.containsKey(classIdTmp)) {
            return null;
        }
        Hashtable subHash = (Hashtable)this.attributes.get(classIdTmp);
        return (AttributeValue)subHash.get(attribute);
    }

    public boolean hasAttributes() throws Exception {
        boolean b = false;
        try {
            Enumeration enumH = this.attributes.elements();
            while (enumH.hasMoreElements()) {
                Hashtable h = (Hashtable)enumH.nextElement();
                if (h.size() <= 0) continue;
                b = true;
                break;
            }
        }
        catch (Exception e) {
            b = true;
        }
        return b;
    }

    public AttributeValue getAttributeBeforUpdate(String attribute) throws Exception {
        Long classIdTmp = this.sessionController.findClassIdByAttribute(attribute, this.classId);
        if (classIdTmp == null) {
            return null;
        }
        if (!this.attributesBeforUpdate.containsKey(classIdTmp)) {
            return null;
        }
        Hashtable subHash = (Hashtable)this.attributesBeforUpdate.get(classIdTmp);
        return (AttributeValue)subHash.get(attribute);
    }

    public void setId(Long id) throws Exception {
        this.id = id;
    }

    public Long getId() throws Exception {
        return this.id;
    }

    public void setClassId(Long classId) throws Exception {
        this.classId = classId;
    }

    public Long getClassId() throws Exception {
        return this.classId;
    }

    public Hashtable getAttributes() throws Exception {
        return this.attributes;
    }

    public void setAttributes(Hashtable attr) throws Exception {
        this.attributes = attr;
    }

    public void setSessionController(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void setSystemOption(String optionName, Object value) {
        if (this.systemOptions.containsKey(optionName)) {
            this.systemOptions.remove(optionName);
        }
        if (value != null) {
            this.systemOptions.put(optionName, value);
        }
    }

    public Object getSystemOption(String optionName) {
        return this.systemOptions.get(optionName);
    }

    public Hashtable getAllSystemOption() {
        return this.systemOptions;
    }

    public void setAllSystemOption(Hashtable allSystemOptions) {
        this.systemOptions = allSystemOptions;
    }

    public void addAllSystemOption(Hashtable allSystemOptions, boolean overwriteExisting) {
        Enumeration enu = allSystemOptions.keys();
        while (enu.hasMoreElements()) {
            Object key = enu.nextElement();
            Object value = allSystemOptions.get(key);
            boolean set = true;
            if (this.systemOptions.containsKey(key)) {
                if (overwriteExisting) {
                    this.systemOptions.remove(key);
                } else {
                    set = false;
                }
            }
            if (!set) continue;
            this.systemOptions.put(key, value);
        }
    }

    public String getClassName() throws Exception {
        ClassObjectClientBean co = this.sessionController.getClassObject(this.classId);
        String classname = co.getName();
        return classname;
    }

    public AutoCloseable prepareUpdate(Long id) throws Exception {
        return new Suppressed(null, null, null);
    }

    protected class Suppressed
    implements AutoCloseable {
        private final AutoCloseable parent;
        private final Map<String, AttributeValue> suppressedAttributes = new HashMap<String, AttributeValue>();
        private final Map<String, Object> suppressedOptions = new HashMap<String, Object>();

        public Suppressed(AutoCloseable parent, String[] attributes, String[] options) throws Exception {
            this.parent = parent;
            if (attributes != null) {
                for (String attribute : attributes) {
                    this.suppressedAttributes.put(attribute, SuperObjectClientBeanDefinition.this.getAttribute(attribute));
                    SuperObjectClientBeanDefinition.this.removeAttribute(attribute);
                }
            }
            if (options != null) {
                for (String option : options) {
                    this.suppressedOptions.put(option, SuperObjectClientBeanDefinition.this.systemOptions.remove(option));
                }
            }
        }

        @Override
        public void close() throws Exception {
            for (Map.Entry<String, Object> entry : this.suppressedOptions.entrySet()) {
                SuperObjectClientBeanDefinition.this.setSystemOption(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.suppressedAttributes.entrySet()) {
                SuperObjectClientBeanDefinition.this.setAttribute(entry.getKey(), (AttributeValue)entry.getValue());
            }
            if (this.parent != null) {
                this.parent.close();
            }
        }
    }
}

