/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.commons.statistic.SystemObjectReference;
import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.DataBaseObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientCachedBean;
import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.AttributeValueGlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeValueGlobalObjectClientBeanArray;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.common.UpdateCounterCacheHandler;
import agorum.roi.ejb.interfaces.home.ObjectUpdateHandlerHome;
import agorum.roi.ejb.interfaces.remote.ObjectUpdateHandlerRemote;
import agorum.roi.ejb.interfaces.remote.SuperObjectEntityRemote;
import agorum.roi.ejb.interfaces.remote.SuperObjectRemote;
import agorum.roi.exception.RoiException;
import agorum.roi.search.SearchClass;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.RemoveException;

public class SuperObjectClientBean
implements Serializable,
SystemObjectReference {
    public static String CLASS_NAME = null;
    protected long updateCounter = 0L;
    protected boolean getNoUpdateCounter = false;
    protected String className = null;
    public static boolean logEnabled = false;
    private Class classObjectEJB = null;
    private Class classObjectEJBHome = null;
    protected SuperObjectRemote remoteReference = null;
    protected SuperObjectEntityRemote entityRemoteReference = null;
    public boolean globalObjectOnly = false;
    public boolean xmlForIndex = false;
    public boolean withAttributeXMLContent = false;
    public boolean xmlForTextindex = false;
    private String jndiNameEJB = null;
    private boolean takeAncestorsIntoIndex = true;
    protected Hashtable attributes = new Hashtable();
    protected Long id = null;
    protected Vector vXMLClassNames = null;
    protected String xmlOffset = "";
    protected SessionController sessionController = null;
    public static String ID_ATTRIBUTE = "ID";
    public static String CLASSID_ATTRIBUTE = "CLASSID";
    protected boolean initialized = false;
    protected transient ObjectUpdateHandlerRemote objectUpdateHandlerRemote = null;
    private static final String[] classNamesGlobalObject = new String[]{GlobalObjectClientBean.CLASS_NAME};
    private static final String[] classNamesInternalObject = new String[]{InternalObjectClientBean.CLASS_NAME};
    private static final String[] classNamesDataBaseObject = new String[]{DataBaseObjectClientBean.CLASS_NAME};

    public SuperObjectClientCachedBean getCachedBean() {
        return SuperObjectClientCachedBean.getCachedBean(this.id);
    }

    public String getJndiNameEJB() {
        return this.jndiNameEJB;
    }

    public void setJndiNameEJB(String jndiNameEJB) {
        this.jndiNameEJB = jndiNameEJB;
    }

    public Class getClassObjectEJBHome() {
        return this.classObjectEJBHome;
    }

    public void setClassObjectEJBHome(Class classObjectEJBHome) {
        this.classObjectEJBHome = classObjectEJBHome;
    }

    public Class getClassObjectEJB() {
        return this.classObjectEJB;
    }

    public void setClassObjectEJB(Class classObjectEJB) {
        this.classObjectEJB = classObjectEJB;
    }

    public void setSessionController(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    protected long getUpdateCounter() throws Exception {
        return UpdateCounterCacheHandler.getInstance().getUpdateCounter(this);
    }

    public long getMyUpdateCounter() {
        return this.updateCounter;
    }

    public void setMyUpdateCounter(long uc) {
        this.updateCounter = uc;
    }

    protected long getUpdateCounterInit() throws Exception {
        long uc = UpdateCounterCacheHandler.getInstance().getUpdateCounterInit(this);
        if (logEnabled) {
            SuperObjectClientBean.doLog("Getting initial updatecounter: id=" + this.id + ", counter=" + uc);
        }
        return uc;
    }

    public long getUpdateCounterInternal() throws Exception {
        if (!this.getNoUpdateCounter) {
            try {
                if (this.objectUpdateHandlerRemote == null) {
                    ObjectUpdateHandlerHome home = (ObjectUpdateHandlerHome)EJBHomeHolder.getHome("ejb/ObjectUpdateHandler");
                    this.objectUpdateHandlerRemote = home.create();
                }
            }
            catch (Exception e) {
                System.err.println("Error getting ObjectUpdateHandler Remote");
            }
            return this.objectUpdateHandlerRemote.getUpdateCounter(this.id);
        }
        return this.updateCounter;
    }

    public long getUpdateCounterInitInternal() throws Exception {
        if (!this.getNoUpdateCounter) {
            try {
                if (this.objectUpdateHandlerRemote == null) {
                    ObjectUpdateHandlerHome home = (ObjectUpdateHandlerHome)EJBHomeHolder.getHome("ejb/ObjectUpdateHandler");
                    this.objectUpdateHandlerRemote = home.create();
                }
            }
            catch (Exception e) {
                System.err.println("Error getting ObjectUpdateHandler Remote");
            }
            return this.objectUpdateHandlerRemote.getUpdateCounterInit(this.id);
        }
        return this.updateCounter;
    }

    @ObjDocAttribute(value="get the ID of this Object")
    public Long getId() {
        this.checkInitialized();
        return this.id;
    }

    @ObjDocAttribute(value="get the ID of this Object")
    public String getID() {
        return String.valueOf(this.getId());
    }

    public boolean equals(Object other) {
        return other instanceof SuperObjectClientBean && this.getID().equals(((SuperObjectClientBean)other).getID());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Long getClassId() throws Exception {
        return new Long(this.getAttribute(CLASSID_ATTRIBUTE).getLong());
    }

    public String getClassName() throws Exception {
        return this.className;
    }

    public void setClassName(String newClassName) throws Exception {
        if (this.className == null) {
            this.className = newClassName;
        }
    }

    public boolean isWithAttributeXMLContent() {
        return this.withAttributeXMLContent;
    }

    public void setWithAttributeXMLContent(boolean withAttributeXMLContent) {
        this.withAttributeXMLContent = withAttributeXMLContent;
    }

    public void resetUpdateCounter() throws Exception {
        UpdateCounterCacheHandler.removeUpdateCounter(this.getId());
    }

    public void setAttribute(String attribute, AttributeValue value) throws Exception {
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            this.checkInitialized();
            SuperObjectRemote sor = this.getRemoteReference();
            sor.setAttribute(this.sessionController, this, this.id, attribute, value, this.entityRemoteReference);
            if (this.attributes.containsKey(attribute)) {
                this.attributes.remove(attribute);
            }
            this.attributes.put(attribute, value);
            rth.end();
            rth = null;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("Exception");
            throw e;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                    rth = null;
                }
            }
            catch (Exception exception) {}
        }
        if (logEnabled) {
            SuperObjectClientBean.doLog("Remove from updatecountercache setAttribute id=" + this.id);
        }
        UpdateCounterCacheHandler.getInstance();
        UpdateCounterCacheHandler.removeUpdateCounter(this.getId());
    }

    public void addArrayElement(String attribute, AttributeValue value) throws Exception {
        this.checkInitialized();
        SuperObjectClientBeanDefinition def = this.getNewDefinition(this.sessionController);
        def.addArrayElement(attribute, value);
        this.update(def);
    }

    public void removeArrayElement(String attribute, AttributeValue value) throws Exception {
        this.checkInitialized();
        SuperObjectClientBeanDefinition def = this.getNewDefinition(this.sessionController);
        def.removeArrayElement(attribute, value);
        this.update(def);
    }

    public void removeArrayElementAt(String attribute, long pos) throws Exception {
        this.checkInitialized();
        SuperObjectClientBeanDefinition def = this.getNewDefinition(this.sessionController);
        def.removeArrayElementAt(attribute, pos);
        this.update(def);
    }

    public void insertArrayElementAt(String attribute, AttributeValue value, long pos) throws Exception {
        this.checkInitialized();
        SuperObjectClientBeanDefinition def = this.getNewDefinition(this.sessionController);
        def.insertArrayElementAt(attribute, value, pos);
        this.update(def);
    }

    public void setAttributeInternal(String attribute, AttributeValue value) throws Exception {
        this.checkInitialized();
        if (this.attributes.containsKey(attribute)) {
            this.attributes.remove(attribute);
        }
        this.attributes.put(attribute, value);
    }

    protected void invalidateAllAttributes() throws Exception {
        SuperObjectClientCachedBean cachedBean = this.getCachedBean();
        if (cachedBean != null) {
            cachedBean.invalidateAllAttributes();
        }
    }

    public AttributeValue getAttribute(String attribute) throws Exception {
        this.checkInitialized();
        AttributeValue av = null;
        if (!(this instanceof ClassObjectClientBean) && !(this instanceof AttributeObjectClientBean)) {
            long update = this.getUpdateCounter();
            if (logEnabled) {
                SuperObjectClientBean.doLog("Getting updatecounter (1): id=" + this.id + ", counterOld=" + this.updateCounter + ", counterNew=" + update);
            }
            if (update != this.updateCounter) {
                this.invalidateAllAttributes();
                this.attributes = this.getEntityRemoteReference().getAttributes(this.sessionController);
                this.updateCounter = update;
                SuperObjectClientCachedBean cachedBean = this.getCachedBean();
                if (cachedBean != null) {
                    cachedBean.setAttributes((Hashtable)this.attributes.clone());
                    cachedBean.setUpdateCounter(update);
                }
            }
        }
        if ((av = (AttributeValue)this.attributes.get(attribute)) == null) {
            try {
                Map<String, AttributeValue> remAttributes = this.getRemoteReference().getAttributeArray(this.sessionController, this.id, attribute, this.getEntityRemoteReference());
                for (Map.Entry<String, AttributeValue> entry : remAttributes.entrySet()) {
                    if (entry.getKey().equals(attribute)) {
                        av = entry.getValue();
                    }
                    this.attributes.put(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception t) {
                System.err.println("ALARM: getAttribute: " + attribute + ", av: " + av + ", " + this.attributes);
                throw t;
            }
            SuperObjectClientCachedBean cachedBean = this.getCachedBean();
            if (cachedBean != null) {
                cachedBean.setAttributes((Hashtable)this.attributes.clone());
            }
        }
        return av;
    }

    public Hashtable getAttributes() throws Exception {
        this.checkInitialized();
        return this.attributes;
    }

    public void setAttributes(Hashtable ht) throws Exception {
        this.checkInitialized();
        this.attributes = ht;
    }

    public SuperObjectEntityRemote getEntityRemoteReference() throws Exception {
        return this.entityRemoteReference;
    }

    public void init(SuperObjectRemote remote, SuperObjectEntityRemote entityRemote, SessionController sessionController, Long id) throws Exception {
        this.remoteReference = remote;
        this.entityRemoteReference = entityRemote;
        this.sessionController = sessionController.getSessionController();
        this.id = id;
        this.initialized = true;
        this.updateCounter = this.getUpdateCounterInit();
    }

    public void initFromEntity(SessionController sessionController, Long id) {
        this.sessionController = sessionController;
        this.id = id;
        this.initialized = true;
    }

    public void initFromSessionBean(SuperObjectRemote remote, SuperObjectEntityRemote entityRemote) {
        this.remoteReference = remote;
        this.entityRemoteReference = entityRemote;
    }

    protected SuperObjectRemote getRemoteReference() throws Exception {
        return this.remoteReference;
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            new Throwable("ClientBean has not been initialized").printStackTrace();
            throw new RuntimeException("ClientBean has not been initialized: " + this.id);
        }
    }

    public void delete() throws Exception {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(SuperObjectClientBeanDefinition def) throws Exception {
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            if (def == null) {
                def = this.getNewDefinition(this.sessionController);
            }
            this.remoteReference.delete(this.sessionController, this, def, this.getEntityRemoteReference());
            rth.end();
            rth = null;
        }
        catch (RemoveException e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                    rth = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return null;
    }

    public SuperObjectClientBeanDefinition getDefinition(SessionController sessionController) throws Exception {
        SuperObjectClientBeanDefinition superObjectClientBeanDefinition = this.getNewDefinition(sessionController);
        return this.remoteReference.getDefinition(sessionController, this, superObjectClientBeanDefinition, this.getEntityRemoteReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuperObjectClientBean copy(SuperObjectClientBeanDefinition superObjectClientBeanDefinition) throws Exception {
        SuperObjectClientBean sRet = null;
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            superObjectClientBeanDefinition.setSystemOption("CopySuperObjectClientBean", "");
            sRet = this.remoteReference.copy(this.sessionController, this, superObjectClientBeanDefinition, this.getEntityRemoteReference());
            rth.end();
            rth = null;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                    rth = null;
                }
            }
            catch (Exception exception) {}
        }
        return sRet;
    }

    public SessionController getSessionController() {
        return this.sessionController;
    }

    public String getXMLEndTag(SessionController sessionController) throws Exception {
        StringBuffer xml = new StringBuffer();
        int len = this.vXMLClassNames.size();
        for (int i = 0; i < len; ++i) {
            xml.append("</" + ((ClassObjectClientBean)this.vXMLClassNames.elementAt(i)).getUniqueName() + ">\n");
            this.xmlOffset = this.xmlOffset + "  ";
        }
        return xml.toString();
    }

    public String getXMLStartTag(SessionController sessionController) throws Exception {
        StringBuffer xml = new StringBuffer();
        ClassObjectClientBean cocb = sessionController.getClassObject(this.getClassName());
        this.vXMLClassNames = new Vector();
        this.xmlOffset = "";
        this.vXMLClassNames.addElement(cocb);
        if (this.takeAncestorsIntoIndex) {
            while (true) {
                ClassObjectClientBean suCocb = cocb.getSuperClass(sessionController);
                this.vXMLClassNames.addElement(suCocb);
                if (suCocb.getId().longValue() == suCocb.getSuperClass(sessionController).getId().longValue()) break;
                cocb = suCocb;
            }
        }
        int len = this.vXMLClassNames.size();
        String str = " ID=\"" + this.getId() + "\"";
        int i = len - 1;
        int j = 0;
        while (i >= 0) {
            xml.append("<" + ((ClassObjectClientBean)this.vXMLClassNames.elementAt(i)).getUniqueName() + str + ">\n");
            str = "";
            --i;
            ++j;
        }
        return xml.toString();
    }

    public String getXml() throws Exception {
        return this.getXml(true);
    }

    public String getIndexJson() throws Exception {
        HashMap<String, AttributeInfo> attributes = new HashMap<String, AttributeInfo>();
        this.fillIndexAttributes(attributes, null);
        String json = "{";
        String sep2 = "";
        for (Map.Entry entry : attributes.entrySet()) {
            json = json + sep2 + "\"" + (String)entry.getKey() + "\":";
            AttributeInfo value = (AttributeInfo)entry.getValue();
            if (value.array) {
                List l = (List)value.value;
                json = json + "[";
                String sep = "";
                for (Object o : l) {
                    if (o instanceof String) {
                        String s = (String)o;
                        s = s.replace("\"", "\\\"");
                        o = s;
                    }
                    json = json + sep + "{";
                    json = json + "\"datatype\": \"" + (Object)((Object)value.dataType) + "\",";
                    json = json + "\"value\":\"" + o + "\"";
                    json = json + "}";
                    sep = ",";
                }
                json = json + "]";
            } else {
                Object o = value.value;
                if (o instanceof String) {
                    String s = (String)o;
                    s = s.replace("\"", "\\\"");
                    o = s;
                }
                json = json + "{";
                json = json + "\"datatype\":\"" + (Object)((Object)value.dataType) + "\",";
                json = json + "\"value\":\"" + o + "\"";
                json = json + "}";
            }
            sep2 = ",";
        }
        json = json + "}";
        return json;
    }

    public String getParseableXml(boolean globalObjectOnly) throws Exception {
        this.globalObjectOnly = globalObjectOnly;
        return this.getParseableXml();
    }

    public String getParseableForIndexXml() throws Exception {
        this.xmlForIndex = true;
        this.withAttributeXMLContent = true;
        this.xmlForTextindex = true;
        String xml = null;
        try {
            xml = this.getParseableXml(true);
        }
        finally {
            this.xmlForIndex = false;
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXmlNormalOrIndex(boolean forTextIndex) throws Exception {
        if (forTextIndex) {
            this.xmlForIndex = true;
            this.withAttributeXMLContent = true;
            this.xmlForTextindex = true;
            try {
                String xml;
                String string = xml = this.getXml();
                return string;
            }
            finally {
                this.xmlForIndex = false;
                this.xmlForTextindex = false;
            }
        }
        return this.getXml();
    }

    public String getParseableXml() throws Exception {
        StringBuffer sb = new StringBuffer();
        RoiProperties rp = new RoiProperties();
        sb.append(rp.getXMLHeaderForParsedXML());
        sb.append("\n");
        sb.append(this.getXml());
        return sb.toString();
    }

    public void fillIndexAttributes(Map<String, AttributeInfo> attributes, GlobalObjectClientBean mainObject) throws Exception {
        ArrayList<String> classNames = new ArrayList<String>();
        ClassObjectClientBean cocb = this.sessionController.getClassObject(this.getClassName());
        AttributeInfo.put(attributes, "classname", AttributeInfo.getFromObject(cocb.getName()));
        AttributeInfo.put(attributes, "id", AttributeInfo.getFromObject(this.getId()));
        while (true) {
            ClassObjectClientBean suCocb;
            String cName;
            Hashtable<String, Object> myAttributes = this.sessionController.getAllAttributesFromClassId(cocb.getId());
            Enumeration<String> attrEnum = myAttributes.keys();
            while (attrEnum.hasMoreElements()) {
                AttributeValue av;
                String key = attrEnum.nextElement().toString();
                if (key.equalsIgnoreCase(GlobalObjectClientBean.OWNER_ATTRIBUTE)) {
                    GlobalObjectClientBean obj;
                    av = this.getAttribute(key);
                    Object v = av.getAttributeValue();
                    if (av instanceof AttributeValueGlobalObjectClientBean && (obj = ((AttributeValueGlobalObjectClientBean)av).getGlobalObjectClientBean(this.sessionController)) != null) {
                        String uuid = obj.getUUID();
                        ArrayList<String> valObjs = new ArrayList<String>();
                        valObjs.add(uuid);
                        AttributeInfo.put(attributes, key.toLowerCase() + "_uuid", AttributeInfo.getFromObject(valObjs));
                    }
                    ArrayList<Object> valObjs = new ArrayList<Object>();
                    valObjs.add(v);
                    AttributeInfo.put(attributes, key.toLowerCase(), AttributeInfo.getFromObject(valObjs));
                    continue;
                }
                if (key.equalsIgnoreCase(GlobalObjectClientBean.ACL_ATTRIBUTE)) {
                    ArrayList<Long> aclIds = new ArrayList<Long>();
                    ArrayList<String> aclIdsUuid = new ArrayList<String>();
                    boolean adminsAffected = true;
                    for (long aclId : ((GlobalObjectClientBean)this).getAllAclIDs()) {
                        if (aclIds.contains(aclId)) continue;
                        AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)this.sessionController.getGlobalObjectById(aclId);
                        aclIds.add(aclId);
                        aclIdsUuid.add(acl.getUUID());
                        adminsAffected = adminsAffected && acl.getAdminsAffected();
                    }
                    AttributeInfo.put(attributes, "acl", AttributeInfo.getFromObject(aclIds));
                    AttributeInfo.put(attributes, "acl_uuid", AttributeInfo.getFromObject(aclIdsUuid));
                    AttributeInfo.put(attributes, "acl_adminsaffected", adminsAffected);
                    continue;
                }
                av = this.getAttribute(key);
                this.fillIndexAttributes(attributes, key, av);
            }
            if (this.takeAncestorsIntoIndex && !classNames.contains(cName = cocb.getName())) {
                classNames.add(cName);
            }
            if ((suCocb = cocb.getSuperClass(this.sessionController)).equals(cocb)) break;
            cocb = suCocb;
        }
        AttributeInfo.put(attributes, "classnames", AttributeInfo.getFromObject(classNames));
    }

    protected void fillIndexAttributes(Map<String, AttributeInfo> attributes, String key, AttributeValue av) throws Exception {
        if (av instanceof AttributeValueArray) {
            AttributeValueGlobalObjectClientBeanArray goArr;
            GlobalObjectClientBean[] objs;
            AttributeValueArray avArr = (AttributeValueArray)av;
            Object[] vals = avArr.getAttributeValueArray(this.sessionController);
            if (vals != null) {
                ArrayList<Object> valObjs = new ArrayList<Object>();
                for (Object v : vals) {
                    valObjs.add(v);
                }
                AttributeInfo.put(attributes, key.toLowerCase(), AttributeInfo.getFromObject(valObjs, avArr));
            }
            if (av instanceof AttributeValueGlobalObjectClientBeanArray && (objs = (goArr = (AttributeValueGlobalObjectClientBeanArray)av).getGlobalObjectClientBeanArray(this.sessionController)) != null) {
                ArrayList<String> valObjs = new ArrayList<String>();
                for (GlobalObjectClientBean obj : objs) {
                    valObjs.add(obj.getUUID());
                }
                AttributeInfo.put(attributes, key.toLowerCase() + "_uuid", AttributeInfo.getFromObject(valObjs));
            }
        } else {
            av.getAttributeValue();
            if (av instanceof AttributeValueGlobalObjectClientBean) {
                GlobalObjectClientBean obj;
                block10: {
                    obj = null;
                    try {
                        obj = ((AttributeValueGlobalObjectClientBean)av).getGlobalObjectClientBean(this.sessionController);
                    }
                    catch (RoiException e) {
                        if (e.getErrorCode() == 101) break block10;
                        throw e;
                    }
                }
                if (obj != null) {
                    AttributeInfo.put(attributes, key.toLowerCase() + "_uuid", AttributeInfo.getFromObject(obj.getUUID()));
                }
            }
            AttributeInfo.put(attributes, key.toLowerCase(), av);
        }
    }

    public String getXml(boolean withEndTag) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getXMLStartTag(this.sessionController));
        int len = this.vXMLClassNames.size();
        for (int i = len - 1; i >= 0; --i) {
            ClassObjectClientBean cocb = (ClassObjectClientBean)this.vXMLClassNames.elementAt(i);
            Hashtable<String, Object> myAttributes = this.sessionController.getAllAttributesFromClassId(cocb.getId());
            Enumeration<String> attrEnum = myAttributes.keys();
            while (attrEnum.hasMoreElements()) {
                String key = attrEnum.nextElement().toString();
                if (!key.equalsIgnoreCase(GlobalObjectClientBean.ACL_ATTRIBUTE)) {
                    sb.append(this.getAttribute(key).getXMLTag(this.sessionController, key, this.globalObjectOnly));
                } else if (this.xmlForTextindex) {
                    String sAllAclIds = "";
                    String blank = "";
                    boolean adminsAffected = true;
                    for (long aclId : ((GlobalObjectClientBean)this).getAllAclIDs()) {
                        AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)this.sessionController.getGlobalObjectById(aclId);
                        sAllAclIds = sAllAclIds + blank + aclId;
                        blank = " ";
                        adminsAffected = adminsAffected && acl.getAdminsAffected();
                    }
                    sb.append("<");
                    sb.append(GlobalObjectClientBean.ACL_ATTRIBUTE);
                    sb.append(" DataType=\"GLOBALOBJECT\" ID=\"");
                    sb.append(sAllAclIds);
                    sb.append("\">");
                    sb.append(sAllAclIds);
                    sb.append("</");
                    sb.append(GlobalObjectClientBean.ACL_ATTRIBUTE);
                    sb.append(">\n<ACL_ADMINSAFFECTED DataType=\"BOOLEAN\">");
                    sb.append(adminsAffected);
                    sb.append("</ACL_ADMINSAFFECTED>");
                }
                sb.append("\n");
            }
        }
        if (withEndTag) {
            sb.append(this.getXMLEndTag(this.sessionController));
        }
        return sb.toString();
    }

    public StringBuffer getMyAttributesAsXML() throws Exception {
        StringBuffer sb = new StringBuffer();
        Hashtable<String, Object> myAttributes = this.sessionController.getAllAttributesFromClassId(this.getClassId());
        Enumeration<String> attrEnum = myAttributes.keys();
        while (attrEnum.hasMoreElements()) {
            String key = attrEnum.nextElement().toString();
            AttributeObjectClientBean aocb = (AttributeObjectClientBean)myAttributes.get(key);
            AttributeValue av = this.getAttribute(key);
            sb.append(av.getXMLTag(this.sessionController, key, this.globalObjectOnly));
            sb.append("\n");
        }
        return sb;
    }

    public void update(SuperObjectClientBeanDefinition socbd) throws Exception {
        this.checkInitialized();
        try (Transaction t = new Transaction();){
            this.getRemoteReference().update(this.sessionController, this, socbd, this.getEntityRemoteReference());
            if (logEnabled) {
                SuperObjectClientBean.doLog("Remove from updatecountercache update id=" + this.id);
            }
            UpdateCounterCacheHandler.removeUpdateCounter(this.id);
            t.commit();
        }
    }

    public SuperObjectClientBean clone(SuperObjectClientBean clonedObject, SessionController sessionController) {
        clonedObject.updateCounter = this.updateCounter;
        clonedObject.getNoUpdateCounter = this.getNoUpdateCounter;
        clonedObject.className = this.className;
        clonedObject.remoteReference = this.remoteReference;
        clonedObject.entityRemoteReference = this.entityRemoteReference;
        clonedObject.globalObjectOnly = this.globalObjectOnly;
        clonedObject.withAttributeXMLContent = this.withAttributeXMLContent;
        clonedObject.attributes = this.attributes;
        clonedObject.id = this.id;
        clonedObject.vXMLClassNames = this.vXMLClassNames;
        clonedObject.xmlOffset = this.xmlOffset;
        clonedObject.sessionController = sessionController;
        clonedObject.initialized = this.initialized;
        clonedObject.objectUpdateHandlerRemote = this.objectUpdateHandlerRemote;
        return clonedObject;
    }

    public boolean isGlobalObjectOnly() {
        return this.globalObjectOnly;
    }

    public void setGlobalObjectOnly(boolean globalObjectOnly) {
        this.globalObjectOnly = globalObjectOnly;
    }

    public String getXmlOffset() {
        return this.xmlOffset;
    }

    public void setXmlOffset(String xmlOffset) {
        this.xmlOffset = xmlOffset;
    }

    public Vector getvXMLClassNames() {
        return this.vXMLClassNames;
    }

    public void setvXMLClassNames(Vector vXMLClassNames) {
        this.vXMLClassNames = vXMLClassNames;
    }

    public boolean getGetNoUpdateCounter() {
        return this.getNoUpdateCounter;
    }

    public void setGetNoUpdateCounter(boolean b) {
        this.getNoUpdateCounter = b;
    }

    public void setInitialized(boolean b) {
        this.initialized = b;
    }

    public void setObjectUpdateHandlerRemote(ObjectUpdateHandlerRemote r) {
        this.objectUpdateHandlerRemote = r;
    }

    public ObjectUpdateHandlerRemote getObjectUpdateHandlerRemote() {
        return this.objectUpdateHandlerRemote;
    }

    public static void doLog(String msg) {
        if (logEnabled) {
            System.out.println("ClientBean, " + Thread.currentThread().getName() + ": " + msg);
        }
    }

    public boolean isExisting() {
        SearchClass sc = new SearchClass(this.sessionController);
        sc.setBindOn();
        SuperObjectClientBean[] items = null;
        if (this instanceof GlobalObjectClientBean) {
            try {
                sc.setClassname(classNamesGlobalObject);
                sc.setAttributeEQUAL(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.ID_ATTRIBUTE, (Object)this.id, false);
                sc.openSearch(GlobalObjectClientBean.CLASS_NAME);
                items = sc.getItems();
            }
            catch (Exception exception) {}
        } else if (this instanceof InternalObjectClientBean) {
            try {
                sc.setClassname(classNamesInternalObject);
                sc.setAttributeEQUAL(InternalObjectClientBean.CLASS_NAME, InternalObjectClientBean.ID_ATTRIBUTE, (Object)this.id, false);
                sc.openSearch(InternalObjectClientBean.CLASS_NAME);
                items = sc.getItemsInternalObject();
            }
            catch (Exception exception) {}
        } else if (this instanceof DataBaseObjectClientBean) {
            try {
                sc.setClassname(classNamesDataBaseObject);
                sc.setAttributeEQUAL(DataBaseObjectClientBean.CLASS_NAME, DataBaseObjectClientBean.ID_ATTRIBUTE, (Object)this.id, false);
                sc.openSearch(DataBaseObjectClientBean.CLASS_NAME);
                items = sc.getItemsDataBaseObject();
            }
            catch (Exception exception) {}
        } else {
            System.err.println("SuperObjectClientBean.isExisting(): Unknown client bean class " + this.getClass().getCanonicalName());
        }
        if (items == null) {
            return false;
        }
        for (GlobalObjectClientBean globalObjectClientBean : items) {
            try {
                if (!globalObjectClientBean.getId().equals(this.id)) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public int makeAuditEntry() {
        return AuditUtil.ACTION_EXT_NORMAL;
    }

    public void setUUID(String uuid) throws Exception {
    }

    public String getUUID() throws Exception {
        return null;
    }

    public boolean sendUpdateEvents() {
        return true;
    }

    public List<String> getInstanceOf() throws Exception {
        ClassObjectClientBean current;
        ArrayList<String> classNames = new ArrayList<String>();
        ClassObjectClientBean next = this.sessionController.getClassObject(this.getClassId());
        do {
            current = next;
            classNames.add(current.getName());
        } while (!(next = current.getSuperClass(this.sessionController)).equals(current));
        return classNames;
    }

    public boolean supportsFolderItemsChangeDelete() {
        return false;
    }
}

