/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.common.ClassHolder;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.GenericRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@ObjDoc(groups={ObjDoc.Group.RELATION}, description="The Client Bean for the GenericRelationObject Class")
public class GenericRelationObjectClientBean
extends RelationObjectClientBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/roi/control/genericrelation/";
    public static String CLASS_NAME = "GENERICRELATIONOBJECT";
    public static String RELATIONTYPE_ATTRIBUTE = "RELATIONTYPE";
    private Behavior behavior;
    private static Map<String, Class<Behavior>> behaviorCache = new HashMap<String, Class<Behavior>>();

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new GenericRelationObjectClientBeanDefinition(sessionController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeBehavior() throws Exception {
        if (this.behavior == null) {
            String relationType = this.getRelationType();
            Class<Behavior> behaviorClass = null;
            Map<String, Class<Behavior>> map = behaviorCache;
            synchronized (map) {
                behaviorClass = behaviorCache.get(relationType);
            }
            if (behaviorClass == null) {
                SessionController sessionController = SessionControllerHolder.sessionController;
                sessionController.reconnectIfNeeded();
                MetaDb metaDb = sessionController.getMetaDbInstance();
                String className = null;
                try {
                    String[] array = metaDb.getSimplePropertyValue(METADB_BASE + relationType + "/ClientBeanBehavior");
                    if (array != null && array.length > 0) {
                        className = array[0];
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                behaviorClass = className != null ? ClassHolder.getClassInstance(className) : Behavior.class;
                Map<String, Class<Behavior>> map2 = behaviorCache;
                synchronized (map2) {
                    behaviorCache.put(relationType, behaviorClass);
                }
            }
            this.behavior = behaviorClass.newInstance();
            this.behavior.relation = this;
        }
    }

    public void setRelationType(String relationType) throws Exception {
        this.setAttribute(RELATIONTYPE_ATTRIBUTE, AttributeValue.newAttributeValueObject(relationType));
    }

    @ObjDocAttribute(value="the relation type")
    public String getRelationType() throws Exception {
        return this.getAttribute(RELATIONTYPE_ATTRIBUTE).getString();
    }

    @Override
    public void leaveAcl(AccessControlListObjectClientBean acl, SuperObjectClientBeanDefinition def) throws Exception {
        this.initializeBehavior();
        this.behavior.leaveAcl(acl, def);
    }

    private void leaveAclDefault(AccessControlListObjectClientBean acl, SuperObjectClientBeanDefinition def) throws Exception {
        super.leaveAcl(acl, def);
    }

    @Override
    public void leaveAclToSubObjects(AccessControlListObjectClientBean acl, GlobalObjectClientBeanDefinition def) throws Exception {
        this.initializeBehavior();
        this.behavior.leaveAclToSubObjects(acl, def);
    }

    private void leaveAclToSubObjectsDefault(AccessControlListObjectClientBean acl, GlobalObjectClientBeanDefinition def) throws Exception {
        super.leaveAclToSubObjects(acl, def);
    }

    @Override
    public void leaveScopeAclsToSubObjects(GlobalObjectClientBeanDefinition def) throws Exception {
        this.initializeBehavior();
        this.behavior.leaveScopeAclsToSubObjects(def);
    }

    private void leaveScopeAclsToSubObjectsDefault(GlobalObjectClientBeanDefinition def) throws Exception {
        super.leaveScopeAclsToSubObjects(def);
    }

    @Override
    public void deleteRightObject(SuperObjectClientBeanDefinition def) throws Exception {
        this.initializeBehavior();
        this.behavior.deleteRightObject(def);
    }

    private void deleteRightObjectDefault(SuperObjectClientBeanDefinition def) throws Exception {
        super.deleteRightObject(def);
    }

    @Override
    public void deleteToRecycle(GlobalObjectClientBeanDefinition def) throws Exception {
        this.initializeBehavior();
        this.behavior.deleteToRecycle(def);
    }

    private void deleteToRecycleDefault(GlobalObjectClientBeanDefinition def) throws Exception {
        super.deleteToRecycle(def);
    }

    @Override
    public void deleteToRecycle(GlobalObjectClientBeanDefinition def, int relationOffset) throws Exception {
        this.initializeBehavior();
        this.behavior.deleteToRecycle(def, relationOffset);
    }

    private void deleteToRecycleDefault(GlobalObjectClientBeanDefinition def, int relationOffset) throws Exception {
        super.deleteToRecycle(def, relationOffset);
    }

    @Override
    public void undelete(GlobalObjectClientBeanDefinition def) throws Exception {
        this.initializeBehavior();
        this.behavior.undelete(def);
    }

    private void undeleteDefault(GlobalObjectClientBeanDefinition def) throws Exception {
        super.undelete(def);
    }

    @Override
    public void copyRightObject(SuperObjectClientBeanDefinition def, SuperObjectClientBean newLeftObject) throws Exception {
        this.initializeBehavior();
        this.behavior.copyRightObject(def, newLeftObject);
    }

    private void copyRightObjectDefault(SuperObjectClientBeanDefinition def, SuperObjectClientBean newLeftObject) throws Exception {
        super.copyRightObject(def, newLeftObject);
    }

    @Override
    public boolean isConnectedObject() throws Exception {
        this.initializeBehavior();
        return this.behavior.isConnectedObject();
    }

    private static class SessionControllerHolder {
        public static SessionController sessionController;

        private SessionControllerHolder() {
        }

        static {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setModulInfo("GenericRelationObjectClientBean");
            credential.setAuthInterface(new ServiceAuthInterface());
            try {
                sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                System.err.println("FATAL: GenericRelation session controller could not be initialized");
                e.printStackTrace();
            }
        }
    }

    public static class Behavior {
        protected GenericRelationObjectClientBean relation;

        public void leaveAcl(AccessControlListObjectClientBean acl, SuperObjectClientBeanDefinition def) throws Exception {
            this.relation.leaveAclDefault(acl, def);
        }

        public void leaveAclToSubObjects(AccessControlListObjectClientBean acl, GlobalObjectClientBeanDefinition def) throws Exception {
            this.relation.leaveAclToSubObjectsDefault(acl, def);
        }

        public void leaveScopeAclsToSubObjects(GlobalObjectClientBeanDefinition def) throws Exception {
            this.relation.leaveScopeAclsToSubObjectsDefault(def);
        }

        public void deleteRightObject(SuperObjectClientBeanDefinition def) throws Exception {
            this.relation.deleteRightObjectDefault(def);
        }

        public void deleteToRecycle(GlobalObjectClientBeanDefinition def) throws Exception {
            this.relation.deleteToRecycleDefault(def);
        }

        public void deleteToRecycle(GlobalObjectClientBeanDefinition def, int relationOffset) throws Exception {
            this.relation.deleteToRecycleDefault(def, relationOffset);
        }

        public void undelete(GlobalObjectClientBeanDefinition def) throws Exception {
            this.relation.undeleteDefault(def);
        }

        public void copyRightObject(SuperObjectClientBeanDefinition def, SuperObjectClientBean newLeftObject) throws Exception {
            this.relation.copyRightObjectDefault(def, newLeftObject);
        }

        public boolean isConnectedObject() throws Exception {
            return false;
        }
    }
}

