/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.commons.utils.JavaUtil;
import agorum.roi.common.Startup;
import agorum.roi.common.beans.FolderDeleteRelationObjectInfoBean;
import agorum.roi.common.utils.InstallUtil;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderDeleteRelationObjectClientBean;
import agorum.roi.ejb.client.beans.FolderDeleteRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FolderObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FolderPathRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.BaseObject;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.FolderObject;
import agorum.roi.ejb.common.FolderObjectClientBeanWrapper;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SortSpecification;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.interfaces.remote.FolderObjectRemote;
import agorum.roi.sessionfacade.beans.GlobalObjectSessionFacade;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Vector;

@ObjDoc(groups={ObjDoc.Group.FOLDER}, description="Client Bean for the FolderObject Class")
public class FolderObjectClientBean
extends GlobalObjectClientBean
implements FolderObject {
    public static final long serialVersionUID = 1L;
    public static String CLASS_NAME = "FOLDEROBJECT";
    public static String AREANAME_ATTRIBUTE = "AREANAME";
    public static long ROOT_FOLDER_ID = 9999L;
    public static boolean SMARTFOLDER_ENABLED = true;
    private boolean rawClientBean = false;
    private SortSpecification sortSpecification = null;
    private static final GlobalObjectClientBean[] emptyItems;

    public void setAreaName(String value) throws Exception {
        this.setAttribute(AREANAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @Override
    @ObjDocAttribute(value="get area name")
    public String getAreaName() throws Exception {
        return this.getAttribute(AREANAME_ATTRIBUTE).getString();
    }

    @Deprecated
    public void addItem(GlobalObjectClientBean ro) throws Exception {
        this.addItem(ro, null);
    }

    public RelationObjectClientBean add(GlobalObjectClientBean ro) throws Exception {
        return this.add(ro, null);
    }

    @Deprecated
    public void addItem(GlobalObjectClientBean ro, SuperObjectClientBeanDefinition def) throws Exception {
        this.add(ro, def);
    }

    public RelationObjectClientBean add(GlobalObjectClientBean ro, SuperObjectClientBeanDefinition def) throws Exception {
        if (this.isVirtualEntryPoint()) {
            try (Transaction t = new Transaction();){
                FolderObjectClientBeanWrapper focbw = new FolderObjectClientBeanWrapper(null, this);
                RelationObjectClientBean rocb = focbw.add(ro, def);
                t.commit();
                RelationObjectClientBean relationObjectClientBean = rocb;
                return relationObjectClientBean;
            }
        }
        try (Transaction t = new Transaction();){
            FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
            RelationObjectClientBean rocb = remFolder.addItem(this.sessionController, this, ro, def);
            t.commit();
            RelationObjectClientBean relationObjectClientBean = rocb;
            return relationObjectClientBean;
        }
    }

    public FolderObjectClientBean createPath(String path, AccessControlListObjectClientBean acl) throws Exception {
        return new RoiFileSystem(this.sessionController).createFullpath(path, this, acl);
    }

    public FolderObjectClientBean createPath(String path) throws Exception {
        return this.createPath(path, null);
    }

    public void checkCycle(GlobalObjectClientBean gocb) throws Exception {
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        remFolder.checkCycle(this.sessionController, this, gocb);
    }

    public boolean isFolderInFolder(SessionController sessionController, long startFolderId, long subFolderId) throws RemoteException, Exception {
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        return remFolder.isFolderInFolder(sessionController, startFolderId, subFolderId);
    }

    @ObjDocAttribute(value="get the items of the folder")
    public GlobalObjectClientBean[] getItems() throws Exception {
        GlobalObjectClientBean[] returnList = null;
        if (this.isVirtualEntryPoint()) {
            FolderObjectClientBeanWrapper focbw = new FolderObjectClientBeanWrapper(null, this);
            returnList = focbw.getItems();
        } else {
            returnList = this.getItems(false, "FolderObjectClientBean.getItems()");
        }
        return returnList;
    }

    public boolean canRemoveItem(SessionController sessionController, SuperObjectClientBean socb) throws Exception {
        if (!this.checkEffectiveAccess(32768L)) {
            return false;
        }
        if (socb instanceof GlobalObjectClientBean) {
            GlobalObjectClientBean gocb = (GlobalObjectClientBean)socb;
            long myFlags = this.getSystemFlags();
            long itemFlags = gocb.getSystemFlags();
            boolean isAdmin = sessionController.isAdminEnabled();
            if (((myFlags & GlobalObjectClientBean.SYSTEMFLAG_NOTREMOVEITEM) > 0L || !isAdmin && (myFlags & GlobalObjectClientBean.SYSTEMFLAG_ADMINREMOVEITEMONLY) > 0L) && ((itemFlags & GlobalObjectClientBean.SYSTEMFLAG_NOTREMOVEITEM) > 0L || !isAdmin && (itemFlags & GlobalObjectClientBean.SYSTEMFLAG_ADMINREMOVEITEMONLY) > 0L)) {
                return false;
            }
        }
        return true;
    }

    public void remove(GlobalObjectClientBean ... gocb) throws Exception {
        if (gocb == null) {
            return;
        }
        this.removeItems(gocb);
    }

    public void removeItem(GlobalObjectClientBean gocb) throws Exception {
        if (this.isVirtualEntryPoint()) {
            FolderObjectClientBeanWrapper focbw = new FolderObjectClientBeanWrapper(null, this);
            focbw.removeItem(gocb);
        } else {
            FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
            remFolder.removeItem(this.sessionController, this, gocb);
        }
    }

    public void removeItems(GlobalObjectClientBean[] gocb) throws Exception {
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        remFolder.removeItems(this.sessionController, this, gocb);
    }

    public void removeAllItems() throws Exception {
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        remFolder.removeAllItems(this.sessionController, this);
    }

    public GlobalObjectClientBean[] items() throws Exception {
        GlobalObjectClientBean[] items = this.getItems();
        if (items != null) {
            return items;
        }
        return emptyItems;
    }

    public GlobalObjectClientBean[] items(String name) throws Exception {
        GlobalObjectClientBean[] items = this.getItems(name);
        if (items != null) {
            return items;
        }
        return emptyItems;
    }

    public GlobalObjectClientBean[] getItems(boolean withDocumentOptions) throws Exception {
        return this.getItems(withDocumentOptions, "FolderObjectClientBean.getItems(withDocumentOptions)");
    }

    public GlobalObjectClientBean[] getItems(boolean withDocumentOptions, String searchName) throws Exception {
        GlobalObjectClientBean[] gocbArr = null;
        gocbArr = this.getItems(withDocumentOptions, null, null, null, null, null, null, null, null, null, searchName);
        return gocbArr;
    }

    @Override
    @ObjDocAttribute(value="the real item count (independend of the access permission)")
    public int getRealItemsCount() throws Exception {
        int counter = 0;
        if (this.isVirtualEntryPoint()) {
            FolderObjectClientBeanWrapper focbw = new FolderObjectClientBeanWrapper(null, this);
            counter = focbw.getRealItemsCount();
        } else {
            RelationObjectClientBean[] rel = this.getRightwardRelations(FolderRelationObjectClientBean.CLASS_NAME);
            counter = rel == null ? 0 : rel.length;
        }
        return counter;
    }

    @Override
    @ObjDocAttribute(value="the item count")
    public int getItemsCount() throws Exception {
        int counter = 0;
        if (this.isVirtualEntryPoint()) {
            FolderObjectClientBeanWrapper focbw = new FolderObjectClientBeanWrapper(null, this);
            counter = focbw.getItemsCount();
        } else {
            FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
            counter = remFolder.getItemsCount(this.sessionController, this, null, null, null, null, null, null);
        }
        return counter;
    }

    public GlobalObjectClientBean[] getItemsOnlyFolder() throws Exception {
        return this.getItems(false, new String[]{RelationObjectClientBean.CLASS_NAME}, new String[]{RelationObjectClientBean.FILTERFLAG_ATTRIBUTE}, new Object[]{Boolean.TRUE}, new int[]{0}, new boolean[]{true}, new int[]{1}, null, null, null);
    }

    @ObjDocAttribute(value="the number of folders")
    public int getItemsCountOnlyFolder() throws Exception {
        int counter = 0;
        if (this.isVirtualEntryPoint()) {
            FolderObjectClientBeanWrapper focbw = new FolderObjectClientBeanWrapper(null, this);
            counter = focbw.getItemsCountOnlyFolder();
        } else {
            FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
            counter = remFolder.getItemsCount(this.sessionController, this, new String[]{RelationObjectClientBean.CLASS_NAME}, new String[]{RelationObjectClientBean.FILTERFLAG_ATTRIBUTE}, new Object[]{Boolean.TRUE}, new int[]{0}, new boolean[]{true}, new int[]{1});
        }
        return counter;
    }

    public GlobalObjectClientBean[] getItemsNoFolder() throws Exception {
        return this.getItems(false, new String[]{RelationObjectClientBean.CLASS_NAME}, new String[]{RelationObjectClientBean.FILTERFLAG_ATTRIBUTE}, new Object[]{Boolean.FALSE}, new int[]{0}, new boolean[]{true}, new int[]{1}, null, null, null);
    }

    public int getItemsCount(String[] className, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause) throws Exception {
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        return remFolder.getItemsCount(this.sessionController, this, className, attributeName, value, qualification, ignorecase, clause);
    }

    public GlobalObjectClientBean[] getItems(boolean withDocumentOption, String[] className, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause, String[] sortClassnames, String[] sortAttribute, int[] sortOrder) throws Exception {
        return this.getItems(withDocumentOption, className, attributeName, value, qualification, ignorecase, clause, sortClassnames, sortAttribute, sortOrder, null);
    }

    private static String[] concat(String[] a, String[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        int aLen = a.length;
        int bLen = b.length;
        String[] result = new String[aLen + bLen];
        System.arraycopy(a, 0, result, 0, aLen);
        System.arraycopy(b, 0, result, aLen, bLen);
        return result;
    }

    public GlobalObjectClientBean[] getItems(boolean withDocumentOption, String[] className, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause, String[] sortClassnames, String[] sortAttribute, int[] sortOrder, String serachName) throws Exception {
        String addName;
        String[] classNames;
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        if (this.sortSpecification == null) {
            classNames = className;
        } else {
            classNames = FolderObjectClientBean.concat(className, this.sortSpecification.getSortClassnames());
            sortAttribute = this.sortSpecification.getSortAttributes();
            sortOrder = this.sortSpecification.getSortOrders();
        }
        if (serachName != null && (addName = this.join(classNames, ", ")) != null) {
            serachName = serachName + "_" + this.join(classNames, ", ");
        }
        return remFolder.getItems(this.sessionController, this, withDocumentOption, classNames, attributeName, value, qualification, ignorecase, clause, sortClassnames, sortAttribute, sortOrder, serachName);
    }

    private String join(String[] in, String sep) {
        if (in == null) {
            return null;
        }
        String out = "";
        String sepTmp = "";
        for (String s : in) {
            out = out + sepTmp + s;
            sepTmp = sep;
        }
        return out;
    }

    @ObjDocAttribute(value="the number of non folders")
    public int getItemsCountNoFolder() throws Exception {
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        return remFolder.getItemsCount(this.sessionController, this, new String[]{RelationObjectClientBean.CLASS_NAME}, new String[]{RelationObjectClientBean.FILTERFLAG_ATTRIBUTE}, new Object[]{Boolean.FALSE}, new int[]{0}, new boolean[]{true}, new int[]{1});
    }

    public boolean hasItemsNoFolder() throws Exception {
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        return remFolder.hasItems(this.sessionController, this, new String[]{RelationObjectClientBean.CLASS_NAME}, new String[]{RelationObjectClientBean.FILTERFLAG_ATTRIBUTE}, new Object[]{Boolean.FALSE}, new int[]{0}, new boolean[]{true}, new int[]{1});
    }

    public GlobalObjectClientBean getItem(String name) throws Exception {
        return this.getItem(name, false);
    }

    public GlobalObjectClientBean getItem(String name, boolean useLike) throws Exception {
        GlobalObjectClientBean[] goArr;
        if (this.isVirtualEntryPoint()) {
            FolderObjectClientBeanWrapper focbw = new FolderObjectClientBeanWrapper(null, this);
            return focbw.getItem(name, useLike);
        }
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        int searchMode = 0;
        if (useLike && (name.indexOf("%") != -1 || name.indexOf("_") != -1)) {
            searchMode = 8;
        }
        if ((goArr = remFolder.getItems(this.sessionController, this, false, new String[]{GlobalObjectClientBean.CLASS_NAME}, new String[]{GlobalObjectClientBean.NAME_ATTRIBUTE}, new Object[]{name}, new int[]{searchMode}, new boolean[]{true}, new int[]{1}, null, null, null, "FolderObjectClientBean.getItem(Name)_" + searchMode)) == null) {
            return null;
        }
        if (goArr.length > 1) {
            ExceptionUtils.handleException("Found more than one object", "agorum.roi.remote.exception.FoundMoreThenOneObject", 107);
        }
        return goArr[0];
    }

    public GlobalObjectClientBean[] getItems(String name) throws Exception {
        GlobalObjectClientBean[] goArr;
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        int searchMode = 0;
        if (name.indexOf("%") != -1 || name.indexOf("_") != -1) {
            searchMode = 8;
        }
        if ((goArr = remFolder.getItems(this.sessionController, this, false, new String[]{GlobalObjectClientBean.CLASS_NAME}, new String[]{GlobalObjectClientBean.NAME_ATTRIBUTE}, new Object[]{name}, new int[]{searchMode}, new boolean[]{true}, new int[]{1}, null, null, null, "FolderObjectClientBean.getItems(Name)")) == null) {
            return null;
        }
        return goArr;
    }

    public GlobalObjectClientBean[] getItemsObjectsOnly(String[] objectClassNames) throws Exception {
        GlobalObjectClientBean[] returnList = null;
        if (this.isVirtualEntryPoint()) {
            FolderObjectClientBeanWrapper focbw = new FolderObjectClientBeanWrapper(null, this);
            returnList = focbw.getItemsObjectsOnly(objectClassNames);
        } else {
            returnList = (GlobalObjectClientBean[])this.getItemsObjectsOnlyInternal(false, objectClassNames);
        }
        return returnList;
    }

    public int getItemsCountObjectsOnly(String[] objectClassNames) throws Exception {
        return (Integer)this.getItemsObjectsOnlyInternal(true, objectClassNames);
    }

    public Object getItemsObjectsOnlyInternal(boolean onlyCount, String[] objectClassNames) throws Exception {
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        Object oRet = null;
        String[] sArray = objectClassNames;
        String[] classNames = null;
        String[] attributeNames = null;
        Object[] attributeValues = null;
        int[] qualifire = null;
        boolean[] uppercase = null;
        int[] clause = null;
        if (sArray != null && sArray.length > 0) {
            int len = sArray.length;
            if (len > 0) {
                classNames = new String[len];
                attributeNames = new String[len];
                attributeValues = new Object[len];
                qualifire = new int[len];
                uppercase = new boolean[len];
                clause = new int[len + 1];
                clause[0] = 3;
                clause[len] = 1;
                for (int k = 0; k < len; ++k) {
                    classNames[k] = GlobalObjectClientBean.CLASS_NAME;
                    attributeNames[k] = GlobalObjectClientBean.CLASSID_ATTRIBUTE;
                    attributeValues[k] = this.sessionController.getClassObject(sArray[k]).getId();
                    qualifire[k] = 0;
                    uppercase[k] = false;
                    if (k >= len || k <= 0) continue;
                    clause[k] = 2;
                }
            } else {
                classNames = new String[]{sArray[0]};
            }
            oRet = onlyCount ? new Integer(this.getItemsCount(classNames, attributeNames, attributeValues, qualifire, uppercase, clause)) : remFolder.getItems(this.sessionController, this, false, classNames, attributeNames, attributeValues, qualifire, uppercase, clause, null, null, null, null);
        } else {
            oRet = onlyCount ? new Integer(this.getItemsCount()) : this.getItems();
        }
        return oRet;
    }

    public boolean hasItem(String name) throws Exception {
        FolderObjectRemote remFolder = (FolderObjectRemote)this.getRemoteReference();
        return remFolder.hasItem(this.sessionController, this, new String[]{GlobalObjectClientBean.CLASS_NAME}, new String[]{GlobalObjectClientBean.NAME_ATTRIBUTE}, new Object[]{name}, new int[]{0}, new boolean[]{true}, new int[]{1});
    }

    public GlobalObjectClientBean getItemUpperCaseName(String name) throws Exception {
        GlobalObjectClientBean[] goArr = this.getItems(false, new String[]{GlobalObjectClientBean.CLASS_NAME}, new String[]{GlobalObjectClientBean.NAME_ATTRIBUTE}, new Object[]{name.toUpperCase()}, new int[]{0}, new boolean[]{true}, new int[]{1}, null, null, null);
        if (goArr == null) {
            return null;
        }
        if (goArr.length > 1) {
            ExceptionUtils.handleException("Found more than one object", "agorum.roi.remote.exception.FoundMoreThenOneObject", 107);
        }
        return goArr[0];
    }

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new FolderObjectClientBeanDefinition(sessionController);
    }

    public SortSpecification getSortSpecification() {
        return this.sortSpecification;
    }

    public void setSortSpecification(SortSpecification sortSpecification) {
        this.sortSpecification = sortSpecification;
    }

    public SuperObjectClientBeanDefinition getFolderObjectCreateDefinition(SessionController sessionController, GlobalObjectSessionFacade facade) throws Exception {
        return null;
    }

    public SuperObjectClientBeanDefinition getFileObjectCreateDefinition(SessionController sessionController) throws Exception {
        return null;
    }

    public SuperObjectClientBeanDefinition getCreateDefinition(SessionController sessionController, ClassObjectClientBean co, GlobalObjectClientBeanDefinition def) throws Exception {
        return null;
    }

    public SuperObjectClientBeanDefinition getCreateDefinition(SessionController sessionController, ClassObjectClientBean co, GlobalObjectClientBean gocb, GlobalObjectClientBeanDefinition def) throws Exception {
        return null;
    }

    public SuperObjectClientBeanDefinition getFolderRelationObjectCreateDefinition(SessionController sessionController) throws Exception {
        return new FolderPathRelationObjectClientBeanDefinition(sessionController);
    }

    public void addDeletedItem(GlobalObjectClientBean ro) throws Exception {
        this.addDeletedItem(ro, true);
    }

    public void addDeletedItem(GlobalObjectClientBean ro, boolean direct) throws Exception {
        FolderDeleteRelationObjectClientBeanDefinition def = new FolderDeleteRelationObjectClientBeanDefinition(this.sessionController);
        def.setAttribute("DIRECT", AttributeValue.newAttributeValueObject(direct));
        this.addRelationship(ro, (RelationObjectClientBeanDefinition)def);
    }

    public void removeDeletedItem(GlobalObjectClientBean gocb) throws Exception {
        this.removeRelationship(this.getRelations(FolderDeleteRelationObjectClientBean.CLASS_NAME, RelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, gocb));
    }

    public GlobalObjectClientBean[] getDeletedItems() throws Exception {
        return this.getDeletedItems(null);
    }

    public GlobalObjectClientBean[] getDeletedItems(Long deleteId) throws Exception {
        return this.getDeletedItems(deleteId, null);
    }

    public GlobalObjectClientBean[] getDeletedItems(Long deleteId, String searchName) throws Exception {
        GlobalObjectClientBean[] beans = null;
        if (deleteId == null) {
            beans = this.getRightwardRelationObjects(FolderDeleteRelationObjectClientBean.CLASS_NAME);
        } else {
            RelationObjectClientBean[] rel = this.getRelations(FolderDeleteRelationObjectClientBean.CLASS_NAME, FolderDeleteRelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, FolderDeleteRelationObjectClientBean.CLASS_NAME, "DELETEID", deleteId);
            Vector<GlobalObjectClientBean> v = new Vector<GlobalObjectClientBean>();
            if (rel != null) {
                int i;
                int len = rel.length;
                for (i = 0; i < len; ++i) {
                    try {
                        GlobalObjectClientBean gocb = rel[i].getRightObject();
                        if (searchName == null) {
                            v.addElement(gocb);
                            continue;
                        }
                        String objectName = gocb.getName().toLowerCase();
                        if (!objectName.contains(searchName.toLowerCase())) continue;
                        v.addElement(gocb);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                len = v.size();
                if (len > 0) {
                    beans = new GlobalObjectClientBean[len];
                    for (i = 0; i < len; ++i) {
                        beans[i] = (GlobalObjectClientBean)v.elementAt(i);
                    }
                }
            }
        }
        return beans;
    }

    public FolderDeleteRelationObjectInfoBean[] getFolderDeleteRelationObjectInfoBean() throws Exception {
        return this.getFolderDeleteRelationObjectInfoBean(null);
    }

    public FolderDeleteRelationObjectInfoBean[] getFolderDeleteRelationObjectInfoBean(DirectoryUserObjectClientBean user) throws Exception {
        FolderDeleteRelationObjectInfoBean[] infoBeans;
        block9: {
            infoBeans = null;
            Vector<FolderDeleteRelationObjectInfoBean> v = new Vector<FolderDeleteRelationObjectInfoBean>();
            try {
                int i;
                RelationObjectClientBean[] rel = this.getRightwardRelations(FolderDeleteRelationObjectClientBean.CLASS_NAME);
                if (rel == null) break block9;
                int len = rel.length;
                long userId = user == null ? 0L : user.getId();
                for (i = 0; i < len; ++i) {
                    try {
                        FolderDeleteRelationObjectClientBean fdRel = (FolderDeleteRelationObjectClientBean)rel[i];
                        GlobalObjectClientBean gocb = fdRel.getRightObject();
                        long lastModifierId = 0L;
                        try {
                            lastModifierId = gocb.getAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE).getLong();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (userId != 0L && userId != lastModifierId) continue;
                        FolderDeleteRelationObjectInfoBean ib = new FolderDeleteRelationObjectInfoBean();
                        ib.setDeleteId(fdRel.getDeleteId());
                        ib.setGlobalObject(gocb);
                        v.addElement(ib);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                len = v.size();
                if (len > 0) {
                    infoBeans = new FolderDeleteRelationObjectInfoBean[len];
                    for (i = 0; i < len; ++i) {
                        infoBeans[i] = (FolderDeleteRelationObjectInfoBean)v.elementAt(i);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return infoBeans;
    }

    @Override
    public void restoreObject(FolderObjectClientBean restoreToFolder) throws Exception {
        super.restoreObject(restoreToFolder);
        Object[] rel = this.getRightwardRelations(FolderDeleteRelationObjectClientBean.CLASS_NAME);
        if (rel != null) {
            JavaUtil ju = new JavaUtil();
            this.reorgDeletedItems((FolderDeleteRelationObjectClientBean[])ju.convertArray(rel, FolderDeleteRelationObjectClientBean.class.getName()));
        }
    }

    public void reorgDeletedItems(GlobalObjectClientBean clientBean) throws Exception {
        Object[] rel;
        if (clientBean != null && (rel = this.getRelations(FolderDeleteRelationObjectClientBean.CLASS_NAME, FolderDeleteRelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, clientBean)) != null) {
            JavaUtil ju = new JavaUtil();
            this.reorgDeletedItems((FolderDeleteRelationObjectClientBean[])ju.convertArray(rel, FolderDeleteRelationObjectClientBean.class.getName()));
        }
    }

    public void reorgDeletedItems(Long deleteId) throws Exception {
        Object[] rel;
        if (deleteId != null && (rel = this.getRelations(FolderDeleteRelationObjectClientBean.CLASS_NAME, FolderDeleteRelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, FolderDeleteRelationObjectClientBean.CLASS_NAME, "DELETEID", deleteId)) != null) {
            JavaUtil ju = new JavaUtil();
            this.reorgDeletedItems((FolderDeleteRelationObjectClientBean[])ju.convertArray(rel, FolderDeleteRelationObjectClientBean.class.getName()));
        }
    }

    public void reorgDeletedItems(FolderDeleteRelationObjectClientBean[] rel) throws Exception {
        if (rel != null) {
            for (FolderDeleteRelationObjectClientBean fdRel : rel) {
                try {
                    fdRel = (FolderDeleteRelationObjectClientBean)this.sessionController.getInternalObjectById(fdRel.getId());
                }
                catch (Exception e) {
                    fdRel = null;
                }
                if (fdRel != null) {
                    Long deletedId = new Long(fdRel.getDeleteId());
                    GlobalObjectClientBean ro = fdRel.getRightObject();
                    this.removeRelationship(fdRel);
                    this.addItem(ro);
                    if (ro.checkEffectiveAccess(16L)) {
                        ro.setExpirationDateSilent(new Date(0L));
                    }
                    if (!this.sessionController.isFolder(ro)) continue;
                    ((FolderObjectClientBean)ro).reorgDeletedItems(deletedId);
                    continue;
                }
                System.err.println("Relation not valid anymore");
            }
        }
    }

    public boolean insideFolder(Long folderId) throws Exception {
        return this.isFolderInFolder(this.sessionController, folderId, this.getId());
    }

    @Override
    public void remove(BaseObject item) throws Exception {
        this.removeItem((GlobalObjectClientBean)item);
    }

    @Override
    public void add(BaseObject item) throws Exception {
        this.add((GlobalObjectClientBean)item);
    }

    public boolean isVirtualEntryPoint() throws Exception {
        long flags;
        if (this.rawClientBean) {
            return false;
        }
        boolean isEntryPoint = false;
        if (SMARTFOLDER_ENABLED && ((flags = this.getSystemFlags()) & GlobalObjectClientBean.SYSTEMFLAG_SPECIALBEHAVIOUR) == GlobalObjectClientBean.SYSTEMFLAG_SPECIALBEHAVIOUR) {
            isEntryPoint = true;
        }
        return isEntryPoint;
    }

    public SuperObjectClientBean asRaw() {
        FolderObjectClientBean cloned = (FolderObjectClientBean)this.clone(new FolderObjectClientBean(), this.sessionController);
        cloned.rawClientBean = true;
        cloned.setClassObjectEJB(this.getClassObjectEJB());
        cloned.setClassObjectEJBHome(this.getClassObjectEJBHome());
        return cloned;
    }

    static {
        Startup.whenReady(() -> {
            SMARTFOLDER_ENABLED = InstallUtil.isModuleActive("SmartFolder");
        });
        emptyItems = new GlobalObjectClientBean[0];
    }
}

