/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.commons.string.StringConverterUtils;
import agorum.roi.ejb.client.beans.AccessCounterObjectClientBean;
import agorum.roi.ejb.client.beans.AccessCounterUserObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AccessCounterUtils;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ConcurrencyUtils;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTransferBean;
import agorum.roi.ejb.common.ContentUtils;
import agorum.roi.ejb.common.DbRandomAccessFile;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.preview.PreviewHelperGateway;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

@ObjDoc(groups={ObjDoc.Group.FILE}, description="file object class")
public class FileObjectClientBean
extends GlobalObjectClientBean
implements Serializable,
ContentInterface {
    public static String CLASS_NAME = "FILEOBJECT";
    public static String CONTENT_ATTRIBUTE = "CONTENT";
    public static String CONTENTSIZE_ATTRIBUTE = "CONTENTSIZE";
    public static String FORMATOBJECT_ATTRIBUTE = "FORMATOBJECT";
    public static String BLOCKSIZE_ATTRIBUTE = "BLOCKSIZE";
    public static String LASTCONTENTMODIFYDATE_ATTRIBUTE = "LASTCONTENTMODIFYDATE";
    private long contentsize = -1L;
    protected ContentUtils contentUtils = null;
    private Hashtable systemOptions = null;
    public static int FLAG_READ_ONLY = 1;
    public static int FLAG_HIDDEN = 2;
    public static int FLAG_SYSTEM = 4;
    public static int FLAG_VOLUME = 8;
    public static int FLAG_ARCHIVE = 32;

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new FileObjectClientBeanDefinition(sessionController);
    }

    @Override
    public void closeForRead() throws Exception {
        this.initContentUtils();
        this.contentUtils.closeForRead();
    }

    public void clearCache() throws Exception {
        this.initContentUtils();
        this.contentUtils.clearCache();
    }

    @Override
    public void closeTransfer() throws Exception {
        this.initContentUtils();
        this.contentUtils.closeTransfer();
    }

    @Override
    public ContentTransferBean getBuffer(long blockNumber, long contentSize) throws Exception {
        return this.getBuffer(blockNumber, contentSize, false);
    }

    @Override
    public ContentTransferBean getBuffer(long blockNumber, long contentSize, boolean bufferd) throws Exception {
        this.initContentUtils();
        return this.contentUtils.getBuffer(blockNumber, contentSize, bufferd);
    }

    @Override
    public boolean validateContent(long contentSize) throws Exception {
        this.initContentUtils();
        return this.contentUtils.validateContent(contentSize);
    }

    @Override
    public void openForRead() throws Exception {
        this.initContentUtils();
        this.contentUtils.openForRead();
    }

    @Override
    public void openTransfer() throws Exception {
        this.initContentUtils();
        this.contentUtils.openTransfer();
    }

    @Override
    public void openTransfer(boolean makeHistory) throws Exception {
        this.initContentUtils();
        this.contentUtils.openTransfer(null, makeHistory);
    }

    @Override
    public void transferContent(ContentTransferBean ctb, long blockNumber) throws Exception {
        this.initContentUtils();
        this.contentUtils.transferContent(ctb, blockNumber);
    }

    @Override
    public void transferContent(ContentTransferBean ctb, long blockNumber, boolean makeHistory) throws Exception {
        this.initContentUtils();
        this.contentUtils.transferContent(ctb, blockNumber, null, makeHistory);
    }

    @Override
    public void transferContentUpdate(ContentTransferBean ctb, long blockNumber, boolean makeHistory) throws Exception {
        this.initContentUtils();
        this.contentUtils.transferContentUpdate(ctb, blockNumber, makeHistory);
    }

    public void initContentUtils() throws Exception {
        if (this.contentUtils == null) {
            this.contentUtils = new ContentUtils(this.sessionController, this);
        }
    }

    @Override
    public Long getContent() throws Exception {
        return new Long(this.getAttribute(CONTENT_ATTRIBUTE).getLong());
    }

    @Override
    public void setContentSize(long value) throws Exception {
        GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)this.getNewDefinition(this.sessionController);
        if (this.systemOptions != null) {
            def.setAllSystemOption(this.systemOptions);
        }
        def.setAttribute(CONTENTSIZE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
        this.update(def);
    }

    @Override
    public void setFormatObject(FormatObjectClientBean value) throws Exception {
        this.setAttribute(FORMATOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @Override
    @ObjDocAttribute(value="get the FormatObject")
    public FormatObjectClientBean getFormatObject() throws Exception {
        return (FormatObjectClientBean)this.getAttribute(FORMATOBJECT_ATTRIBUTE).getInternalObjectClientBean(this.sessionController);
    }

    @Override
    @ObjDocAttribute(value="get the ContentSize of the Object")
    public long getContentSize() throws Exception {
        return this.getContentSize(false);
    }

    @Override
    public long getContentSize(boolean doNotGenerateContent) throws Exception {
        return this.getAttribute(CONTENTSIZE_ATTRIBUTE).getLong();
    }

    @Override
    @ObjDocAttribute(value="the LastContentModifyDate of the Object")
    public Date getLastContentModifyDate() throws Exception {
        return this.getAttribute(LASTCONTENTMODIFYDATE_ATTRIBUTE).getDate();
    }

    @Override
    public void setLastContentModifyDate(Date date) throws Exception {
        this.setAttribute(LASTCONTENTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(date));
    }

    @Override
    @ObjDocAttribute(value="the Content of the Object")
    public InputStream getContentStream() throws Exception {
        return new ContentUtils(this.sessionController, this).getContentStream();
    }

    @ObjDocAttribute(value="the Content of the Object (but do not set as read)")
    public InputStream getContentStreamNoRead() throws Exception {
        return new ContentUtils(this.sessionController, this).getContentStreamNoRead();
    }

    @Override
    public void setContent(InputStream is) throws Exception {
        this.setContent(is, null);
    }

    @Override
    public void setContent(InputStream is, GlobalObjectClientBeanDefinition def) throws Exception {
        this.initContentUtils();
        this.contentUtils.setContent(is, def);
    }

    @Override
    @ObjDocAttribute(value="the format of this content-Object")
    public FormatObjectClientBean getFormat() throws Exception {
        return (FormatObjectClientBean)this.getAttribute(FORMATOBJECT_ATTRIBUTE).getInternalObjectClientBean(this.sessionController);
    }

    public void setFormat(FormatObjectClientBean formatObject) throws Exception {
        this.setAttribute(FORMATOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(formatObject));
    }

    @Override
    @ObjDocAttribute(value="a random Access to the content")
    public DbRandomAccessFile getRandomAccessFile() throws Exception {
        this.initContentUtils();
        return this.contentUtils.getRandomAccessFile();
    }

    @Override
    public OutputStream getContentOutputStream() throws Exception {
        this.initContentUtils();
        return this.contentUtils.getContentOutputStream();
    }

    @Override
    public OutputStream getContentOutputStream(boolean makeHistory) throws Exception {
        this.initContentUtils();
        return this.contentUtils.getContentOutputStream(makeHistory);
    }

    @Override
    public void setBlockSize(long blockSize) throws Exception {
        this.setAttribute(BLOCKSIZE_ATTRIBUTE, AttributeValue.newAttributeValueObject(blockSize));
    }

    @Override
    @ObjDocAttribute(value="the BlockSize of this content-Object")
    public long getBlockSize() throws Exception {
        return this.getAttribute(BLOCKSIZE_ATTRIBUTE).getLong();
    }

    @Override
    @ObjDocAttribute(value="the AccessCounterObject from this Object")
    public AccessCounterObjectClientBean getAccessCounterObject() throws Exception {
        AccessCounterUtils acu = new AccessCounterUtils(this.sessionController);
        return acu.getAccessCounterObject(this);
    }

    @Override
    public AccessCounterUserObjectClientBean getAccessCounterUserObject(DirectoryUserObjectClientBean user) throws Exception {
        AccessCounterUtils acu = new AccessCounterUtils(this.sessionController);
        return acu.getAccessCounterUserObject(this, user);
    }

    @Override
    public AccessCounterUserObjectClientBean[] getAllAccessCounterUserObjects() throws Exception {
        AccessCounterUtils acu = new AccessCounterUtils(this.sessionController);
        return acu.getAllAccessCounterUserObject(this);
    }

    @Override
    public boolean hasUserRead() throws Exception {
        AccessCounterUtils acu = new AccessCounterUtils(this.sessionController);
        return acu.hasUserContentRead(this, this.sessionController.getLoginUser());
    }

    @Override
    @ObjDocAttribute(value="returns that the actual user is the last reader of this object")
    public boolean getUserReadWatchLastModifier() throws Exception {
        return true;
    }

    @Override
    @ObjDocAttribute(value="Get this class")
    public ContentInterface getAccessCounterContentObject() throws Exception {
        return this;
    }

    @Override
    public void truncate(long newFileLength, boolean setContentSize, boolean makeHistory) throws Exception {
        this.initContentUtils();
        this.contentUtils.truncate(newFileLength, setContentSize, makeHistory);
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public ContentTransferBean read(int len1, long filePos) throws Exception {
        ExceptionUtils.handleException("'read' not implemented in FileObject", "agorum.roi.remote.exception.NotImplemented", 3);
        return null;
    }

    @Override
    public void write(ContentTransferBean ctb, int bufferPos, int len, long filePos) throws Exception {
        ExceptionUtils.handleException("'write' not implemented in FileObject", "agorum.roi.remote.exception.NotImplemented", 3);
    }

    @Override
    public boolean supportsServerSideStreaming(GlobalObjectClientBean destObject) throws Exception {
        return this.getClassId().longValue() == destObject.getClassId().longValue();
    }

    @Override
    public void streamContent(ContentInterface contentInterface) throws Exception {
        this.initContentUtils();
        this.contentUtils.copyContent(this, contentInterface, this.getFormat().getTableName(), contentInterface.getFormat().getTableName(), this.systemOptions);
        contentInterface.setContentSize(this.getContentSize());
    }

    @Override
    public void setSystemOptions(Hashtable sysOptions) {
        this.systemOptions = sysOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreHistoryObject(GlobalObjectClientBean historyBean, GlobalObjectClientBeanDefinition def) throws Exception {
        System.err.println("HistoryObjectID (FileObject): " + historyBean.getId());
        System.err.println("OriginalObjectg (FileObject): " + this.getId());
        historyBean.setHistoryObjectRestoreFlag();
        try {
            if (def == null) {
                def = (GlobalObjectClientBeanDefinition)this.getNewDefinition(this.sessionController);
            }
            def.setLastModifyDate(historyBean.getLastModifyDate());
            Date lcm = ((ContentInterface)((Object)historyBean)).getLastContentModifyDate();
            def.setAttribute(LASTCONTENTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(lcm));
            ConcurrencyUtils.prepareContentChange(this.sessionController, this);
            this.setContent(((ContentInterface)((Object)historyBean)).getContentStream(), def);
            super.restoreHistoryObject(historyBean, def);
        }
        finally {
            historyBean.unsetHistoryObjectRestoreFlag();
        }
    }

    @Override
    public boolean supportsPreview() throws Exception {
        PreviewHelperGateway ph = new PreviewHelperGateway();
        return ph.getPreviewInterface().hasPreview(this);
    }

    @Override
    public boolean supportsAccessCounter() {
        return true;
    }

    @Override
    @ObjDocAttribute(value="get table name")
    public String getTableName() throws Exception {
        this.initContentUtils();
        return this.contentUtils.getTableName();
    }

    @Override
    @ObjDocAttribute(value="get id of format")
    public Long getFormatId() throws Exception {
        return this.getAttribute(FORMATOBJECT_ATTRIBUTE).getLong();
    }

    public static FileObjectClientBean createFile(SessionController sessionController, String name, FolderObjectClientBean folder, InputStream content) throws Exception {
        FileObjectSessionFacade fosf = new FileObjectSessionFacade(sessionController);
        fosf.setNameWithId(true);
        fosf.setDestinationFolder(folder);
        fosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, name);
        fosf.setAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE, folder.getAcl());
        if (content != null) {
            fosf.setContentStream(content);
        }
        FileObjectClientBean focb = (FileObjectClientBean)fosf.create();
        return focb;
    }

    @Override
    @ObjDocAttribute(value="get md5 hash")
    public String getMd5() throws Exception {
        this.initContentUtils();
        return this.contentUtils.getMD5(this.getContentStream());
    }

    @Override
    public boolean supportsBackend() {
        return true;
    }

    @Override
    @ObjDocAttribute(value="get generated content hashes from the object, listed by ident")
    public Map<String, String> getContentHashes() throws Exception {
        return super.getContentHashesInternal();
    }

    @Override
    @ObjDocAttribute(value="set a content hash code with the given ident to the given object, format: ident;hashcode")
    public void setContentHash(String identAndHash) throws Exception {
        super.setContentHashInternal(identAndHash);
    }

    @Override
    @ObjDocAttribute(value="this object's content as a string, interpreted in the system's default encoding")
    public String getContentString() throws Exception {
        InputStream contentStream = this.getContentStream();
        String text = "";
        if (contentStream != null) {
            text = StringConverterUtils.toString((InputStream)contentStream);
        }
        return text;
    }

    @Override
    public void setContentString(String text) throws Exception {
        this.setContent(StringConverterUtils.toStream((String)text));
    }

    @Override
    public boolean createAccessCounterObject() {
        return true;
    }

    @Override
    public boolean shouldMakeHistory() {
        return true;
    }

    @Override
    public boolean countDownloadQuota() {
        return true;
    }

    @Override
    public boolean isBinary() throws Exception {
        return true;
    }
}

