/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.common.utils.JavaUtil;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GroupMemberRelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueLongArray;
import agorum.roi.ejb.common.AttributeValueStringArray;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ObjDoc(groups={ObjDoc.Group.USERMANAGEMENT}, description="Client Bean for the DirectoryObject Class")
public class DirectoryObjectClientBean
extends GlobalObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "DIRECTORYOBJECT";
    public static String ISROLE_ATTRIBUTE = "ISROLE";
    private static final DirectoryGroupObjectClientBean[] emptyGroups = new DirectoryGroupObjectClientBean[0];

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new DirectoryObjectClientBeanDefinition(sessionController);
    }

    public void setIsRole(boolean value) throws Exception {
        this.setAttribute(ISROLE_ATTRIBUTE, AttributeValue.newAttributeValueObject((Boolean)value));
    }

    @ObjDocAttribute(value="get is role")
    public boolean getIsRole() throws Exception {
        return this.getAttribute(ISROLE_ATTRIBUTE).getBoolean();
    }

    public DirectoryGroupObjectClientBean[] getAllGroups() throws Exception {
        HashSet<DirectoryGroupObjectClientBean> result = new HashSet<DirectoryGroupObjectClientBean>();
        this.gatherAllGroups(result);
        return result.toArray(new DirectoryGroupObjectClientBean[result.size()]);
    }

    protected void gatherAllGroups(Set<DirectoryGroupObjectClientBean> result) throws Exception {
        for (DirectoryGroupObjectClientBean group : this.getGroups()) {
            result.add(group);
            group.gatherAllGroups(result);
        }
    }

    public DirectoryGroupObjectClientBean[] getGroups() throws Exception {
        Object[] groups = this.getLeftwardRelationObjects(GroupMemberRelationObjectClientBean.CLASS_NAME);
        if (groups == null) {
            return emptyGroups;
        }
        return (DirectoryGroupObjectClientBean[])new JavaUtil().convertArray(groups, DirectoryGroupObjectClientBean.class.getName());
    }

    @Override
    public String getXml(boolean withEndTag) throws Exception {
        String sep;
        StringBuilder sb = new StringBuilder();
        sb.append(super.getXml(withEndTag));
        Map<String, List<Object>> memberships = this.gatherMembership();
        if (!memberships.get("id").isEmpty()) {
            sb.append("<INGROUP>");
            sep = "";
            for (Object pathId : memberships.get("id")) {
                sb.append(sep + pathId);
                sep = " ";
            }
            sb.append("</INGROUP>");
        }
        if (!memberships.get("uuid").isEmpty()) {
            sb.append("<INGROUP_UUID>");
            sep = "";
            for (Object pathId : memberships.get("uuid")) {
                sb.append(sep + pathId);
                sep = " ";
            }
            sb.append("</INGROUP_UUID>");
        }
        return sb.toString();
    }

    @Override
    public void fillIndexAttributes(Map<String, AttributeInfo> attributes, GlobalObjectClientBean mainObject) throws Exception {
        super.fillIndexAttributes(attributes, mainObject);
        Map<String, List<Object>> memberships = this.gatherMembership();
        List<Object> ids = memberships.get("id");
        List<Object> uuids = memberships.get("uuid");
        AttributeInfo.put(attributes, "ingroup", ids, new AttributeValueLongArray(ids.toArray(new Long[0])));
        AttributeInfo.put(attributes, "ingroup_uuid", uuids, new AttributeValueStringArray(uuids.toArray(new String[0])));
    }

    private Map<String, List<Object>> gatherMembership() throws Exception {
        HashMap<String, List<Object>> ids = new HashMap<String, List<Object>>();
        ids.put("id", new ArrayList());
        ids.put("uuid", new ArrayList());
        return this.resolveLeftwardGroupMembership(this, ids);
    }

    private Map<String, List<Object>> resolveLeftwardGroupMembership(GlobalObjectClientBean gocb, Map<String, List<Object>> ids) throws Exception {
        RelationObjectClientBean[] relations = gocb.getLeftwardRelations("GROUPMEMBERRELATIONOBJECT");
        if (relations != null) {
            for (RelationObjectClientBean relation : relations) {
                ids = this.resolveLeftwardGroupMembership(relation.getLeftObject(), ids);
            }
        }
        if (!(gocb.equals(this) || ids.get("id").contains(gocb.getId()) || ids.get("uuid").contains(gocb.getUUID()))) {
            ids.get("id").add(gocb.getId());
            ids.get("uuid").add(gocb.getUUID());
        }
        return ids;
    }
}

