/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.ContentQuotaObjectClientBean;
import agorum.roi.ejb.client.beans.ContentQuotaObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.interfaces.remote.DirectoryGroupObjectRemote;
import agorum.roi.interfaces.adminsync.AdminSyncServiceCaller;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;

@ObjDoc(groups={ObjDoc.Group.USERMANAGEMENT}, description="Client Bean for the DirectoryGroupObject Class")
public class DirectoryGroupObjectClientBean
extends DirectoryObjectClientBean
implements Serializable {
    public static final String METADB_SYSTEM_OPTION = "GroupMetaDbGroupPath";
    public static String CLASS_NAME = "DIRECTORYGROUPOBJECT";
    public static String OWNERUNIQUENAME_ATTRIBUTE = "OWNERUNIQUENAME";
    public static String CONTENTQUOTAOBJECT_ATTRIBUTE = "CONTENTQUOTAOBJECT";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new DirectoryGroupObjectClientBeanDefinition(sessionController);
    }

    public void addMember(DirectoryObjectClientBean dObject) throws Exception {
        this.addMembers(new DirectoryObjectClientBean[]{dObject});
    }

    public void addMember(DirectoryObjectClientBean dObject, boolean primaryGroup) throws Exception {
        DirectoryGroupObjectClientBeanDefinition def = (DirectoryGroupObjectClientBeanDefinition)this.getNewDefinition(this.sessionController);
        def.setSystemOption("groupAddMembers", new DirectoryObjectClientBean[]{dObject});
        def.setSystemOption("primaryGroup", primaryGroup);
        this.update(def);
    }

    public void addMembers(DirectoryObjectClientBean[] dObject) throws Exception {
        DirectoryGroupObjectClientBeanDefinition def = (DirectoryGroupObjectClientBeanDefinition)this.getNewDefinition(this.sessionController);
        def.setSystemOption("groupAddMembers", dObject);
        def.setSystemOption("primaryGroup", Boolean.FALSE);
        this.update(def);
    }

    public void removeMember(DirectoryObjectClientBean dObject) throws Exception {
        this.removeMembers(new DirectoryObjectClientBean[]{dObject});
    }

    public void removeMembers(DirectoryObjectClientBean[] dObject) throws Exception {
        DirectoryGroupObjectClientBeanDefinition def = (DirectoryGroupObjectClientBeanDefinition)this.getNewDefinition(this.sessionController);
        def.setSystemOption("groupRemoveMembers", dObject);
        this.update(def);
    }

    public DirectoryObjectClientBean[] getAllMembers() throws Exception {
        DirectoryGroupObjectRemote remGroup = (DirectoryGroupObjectRemote)this.getRemoteReference();
        return remGroup.getAllMembers(this.sessionController, this, new Hashtable());
    }

    public DirectoryObjectClientBean[] getAllMembers(Hashtable selectedGroups) throws Exception {
        DirectoryGroupObjectRemote remGroup = (DirectoryGroupObjectRemote)this.getRemoteReference();
        return remGroup.getAllMembers(this.sessionController, this, selectedGroups);
    }

    @ObjDocAttribute(value="all direct and indirect user members of this group")
    public DirectoryObjectClientBean[] getAllUserMembers() throws Exception {
        DirectoryGroupObjectRemote remGroup = (DirectoryGroupObjectRemote)this.getRemoteReference();
        return remGroup.getAllUserMembers(this.sessionController, this, new Hashtable());
    }

    public DirectoryObjectClientBean[] getAllUserMembers(Hashtable selectedGroups) throws Exception {
        DirectoryGroupObjectRemote remGroup = (DirectoryGroupObjectRemote)this.getRemoteReference();
        return remGroup.getAllUserMembers(this.sessionController, this, selectedGroups);
    }

    @ObjDocAttribute(value="all direct members (users and groups) of this group")
    public DirectoryObjectClientBean[] getDirectMembers() throws Exception {
        DirectoryGroupObjectRemote remGroup = (DirectoryGroupObjectRemote)this.getRemoteReference();
        return remGroup.getDirectMembers(this.sessionController, this);
    }

    public DirectoryGroupObjectClientBean[] getDirectGroupMembers() throws Exception {
        DirectoryGroupObjectRemote remGroup = (DirectoryGroupObjectRemote)this.getRemoteReference();
        return remGroup.getDirectGroupMembers(this.sessionController, this);
    }

    public DirectoryGroupObjectClientBean[] getParentGroups() throws Exception {
        DirectoryGroupObjectRemote remGroup = (DirectoryGroupObjectRemote)this.getRemoteReference();
        return remGroup.getParentGroups(this.sessionController, this);
    }

    public DirectoryUserObjectClientBean[] getDirectUserMembers() throws Exception {
        DirectoryGroupObjectRemote remGroup = (DirectoryGroupObjectRemote)this.getRemoteReference();
        return remGroup.getDirectUserMembers(this.sessionController, this);
    }

    @Override
    @ObjDocAttribute(value="get the AreaName")
    public String getAreaName() throws Exception {
        return "Group";
    }

    @Override
    public void executeBeforeItemAdded(SessionController sessionController, GlobalObjectClientBean lo, GlobalObjectClientBean ro, SuperObjectClientBeanDefinition relDef) throws Exception {
        if (!sessionController.isInSychronization()) {
            String pathPrefix = "/agorum/roi/administration/group";
            String loFolderPath = null;
            try {
                loFolderPath = lo.getAnyFolderPath().toLowerCase();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (loFolderPath != null && !loFolderPath.startsWith(pathPrefix)) {
                ExceptionUtils.handleException("Wrong folder for a group", "agorum.roi.remote.exception.WrongFolderForObject", 65);
            }
        }
        super.executeBeforeItemAdded(sessionController, lo, ro, relDef);
    }

    @Override
    public void executeAfterItemAdded(SessionController sessionController, GlobalObjectClientBean lo, GlobalObjectClientBean ro) throws Exception {
        if (this.getId().longValue() == ro.getId().longValue()) {
            System.err.println("executeAfterItemAdded : " + ro.getName());
            FolderObjectClientBean baseFolder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath("/agorum/roi/Administration/Group");
            if (baseFolder != null) {
                String[] allPath = lo.getAllFolderPath(baseFolder.getId());
                if (allPath != null) {
                    String myGroupPath = allPath[0].substring(1);
                    System.err.println("executeAfterItemAdded myGroupPath : " + myGroupPath);
                    DirectoryGroupObjectClientBeanDefinition def = (DirectoryGroupObjectClientBeanDefinition)ro.getNewDefinition(sessionController);
                    def.setSystemOption(METADB_SYSTEM_OPTION, myGroupPath);
                    def.setSystemOption("PerformUpdateCallbacks", "");
                    ro.update(def);
                }
                GenericCache gc = null;
                String adminSyncKey = "noAdminSyncFor_" + ro.getId();
                gc = GenericCache.getInstance((Object)("AdminSyncGenericCache_" + sessionController.getSessionId()), (int)10000, (int)10000, (int)80000);
                if (!gc.contains((Object)adminSyncKey)) {
                    AdminSyncServiceCaller assu = new AdminSyncServiceCaller();
                    assu.syncObject(sessionController, ro, null, null, null, false, null, "executeAfterItemAdded");
                }
            }
        }
    }

    public boolean isDirectMember(DirectoryObjectClientBean member) throws Exception {
        DirectoryGroupObjectRemote remGroup = (DirectoryGroupObjectRemote)this.getRemoteReference();
        return remGroup.isDirectMember(this.sessionController, this, member);
    }

    @Override
    public void leaveAclAfterMove(AccessControlListObjectClientBean acl, SuperObjectClientBeanDefinition def) throws Exception {
    }

    public void executeAfterMemberRemoved(SuperObjectClientBeanDefinition def) throws Exception {
        Hashtable allSystemOptions = null;
        if (def != null) {
            allSystemOptions = def.getAllSystemOption();
        }
        AdminSyncServiceCaller assu = new AdminSyncServiceCaller();
        assu.syncObject(this.sessionController, this, null, null, null, false, allSystemOptions, "executeAfterMemberRemoved");
    }

    public Set<Long> getAllUserMembersDirect(SessionController sessionController) throws Exception {
        DirectoryGroupObjectRemote remGroup = (DirectoryGroupObjectRemote)this.getRemoteReference();
        return remGroup.getAllUserMembersDirect(sessionController, this.getId());
    }

    @ObjDocAttribute(value="get cotent quota object")
    public ContentQuotaObjectClientBean getContenQuotaObject() throws Exception {
        AttributeValue av = this.getAttribute(CONTENTQUOTAOBJECT_ATTRIBUTE);
        if (av != null) {
            return (ContentQuotaObjectClientBean)av.getGlobalObjectClientBean(this.sessionController);
        }
        return null;
    }

    public void setContenQuotaObject(ContentQuotaObjectClientBean quota) throws Exception {
        this.setAttribute(CONTENTQUOTAOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(quota));
    }

    public void setContentQuotaAllocatedStorage(long allocatedStorage) throws Exception {
        ContentQuotaObjectClientBean quota = this.getContenQuotaObject();
        if (quota == null) {
            quota = this.createContentQuotaObjectClientBean(allocatedStorage);
        } else {
            quota.setAllocatedStorage(allocatedStorage);
        }
    }

    private ContentQuotaObjectClientBean createContentQuotaObjectClientBean(long allocatedStorage) throws Exception {
        ContentQuotaObjectClientBeanDefinition def = new ContentQuotaObjectClientBeanDefinition(this.getSessionController());
        def.setName("GroupQuotaObject");
        def.setUniqueName("GroupQuotaObject");
        def.setAssociatedGlobalObject(this);
        def.setConsumedStorage(-1L);
        def.setAllocatedStorage(allocatedStorage);
        ContentQuotaObjectClientBean quota = (ContentQuotaObjectClientBean)this.getSessionController().createGlobalObject(def);
        this.setContenQuotaObject(quota);
        return quota;
    }

    @Override
    @ObjDocAttribute(value="get xml of the client bean")
    public String getXml() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getXml(false));
        sb.append(this.getXMLEndTag(this.sessionController));
        return sb.toString();
    }

    @Override
    public boolean checkEffectiveAccess(DirectoryObjectClientBean directoryObject, long accessLevel, boolean ignoreSharedLock) throws Exception {
        if (!this.sessionController.isInSychronization()) {
            boolean isModify;
            long effAccessLevel = 0xFFFFFFFAL;
            boolean bl = isModify = (effAccessLevel & accessLevel) > 0L;
            if (isModify && this.sessionController.isWorldGroup(this)) {
                return false;
            }
        }
        return super.checkEffectiveAccess(directoryObject, accessLevel, ignoreSharedLock);
    }

    @Override
    public void delete(SuperObjectClientBeanDefinition def) throws Exception {
        if (def != null && def.getSystemOption("SetExpirationDateInsteadOfDelete") != null) {
            ExceptionUtils.handleException("Group can not be put into the trash, but only deleted directly", "agorum.roi.remote.exception.NotAllowed", 20);
        }
        super.delete(def);
    }
}

