/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.AccessCounterObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.Date;

@ObjDoc(groups={ObjDoc.Group.FILE}, description="Client Bean for the AccessCounterObject Class")
public class AccessCounterObjectClientBean
extends InternalObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "ACCESSCOUNTEROBJECT";
    public static final String REFERENCEOBJECT_ATTRIBUTE = "REFERENCEOBJECT";
    public static final String ACCESSCOUNTER_ATTRIBUTE = "ACCESSCOUNTER";
    public static final String LASTACCESSDATE_ATTRIBUTE = "LASTACCESSDATE";
    public static final String LASTACCESSOR_ATTRIBUTE = "LASTACCESSOR";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new AccessCounterObjectClientBeanDefinition(sessionController);
    }

    public void setReferenceObject(GlobalObjectClientBean value) throws Exception {
        this.setAttribute(REFERENCEOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setAccessCounter(long value) throws Exception {
        this.setAttribute(ACCESSCOUNTER_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setLastAccessDate(Date value) throws Exception {
        this.setAttribute(LASTACCESSDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setLastAccessor(DirectoryObjectClientBean value) throws Exception {
        this.setAttribute(LASTACCESSOR_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="the reference object")
    public GlobalObjectClientBean getReferenceObject() throws Exception {
        return this.getAttribute(REFERENCEOBJECT_ATTRIBUTE).getGlobalObjectClientBean(this.sessionController);
    }

    @ObjDocAttribute(value="the access counter")
    public long getAccessCounter() throws Exception {
        return this.getAttribute(ACCESSCOUNTER_ATTRIBUTE).getLong();
    }

    @ObjDocAttribute(value="the last access date")
    public Date getLastAccessDate() throws Exception {
        return this.getAttribute(LASTACCESSDATE_ATTRIBUTE).getDate();
    }

    @ObjDocAttribute(value="the last accessor")
    public DirectoryObjectClientBean getLastAccessor() throws Exception {
        return this.getAttribute(LASTACCESSOR_ATTRIBUTE).getDirectoryObjectClientBean(this.sessionController);
    }

    @Override
    public int makeAuditEntry() {
        return AuditUtil.ACTION_EXT_NOT_ENTRY;
    }
}

