/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.interfaces.remote.AccessControlListObjectRemote;
import agorum.roi.search.SearchClass;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

@ObjDoc(groups={ObjDoc.Group.ADMINISTRATION}, description="Client Bean for the AccessControlListObject Class")
public class AccessControlListObjectClientBean
extends GlobalObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "ACCESSCONTROLLISTOBJECT";
    public static String OWNERUNIQUENAME_ATTRIBUTE = "OWNERUNIQUENAME";
    public static String SHARED_ATTRIBUTE = "SHARED";
    public static String ADMINSAFFECTED_ATTRIBUTE = "ADMINSAFFECTED";
    public static final String ACL_ALL = "ALL";
    public static final String ACL_READ = "READ";
    public static final String ACL_CHECK_OUT = "CHECK_OUT";
    public static final String ACL_WRITE = "WRITE";
    public static final String ACL_PROTECTED = "PROTECTED";

    @ObjDocAttribute(value="Return the name of the Object")
    public String getOwnerUniqueName() throws Exception {
        return this.getAttribute(OWNERUNIQUENAME_ATTRIBUTE).getString();
    }

    public void setOwnerUniqueName(String value) throws Exception {
        this.setAttribute(OWNERUNIQUENAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="get shared attribute")
    public boolean getShared() throws Exception {
        return this.getAttribute(SHARED_ATTRIBUTE).getBoolean();
    }

    public void setShared(boolean value) throws Exception {
        this.setAttribute(SHARED_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="get admins affected attribute (acl is also affecting admins)")
    public boolean getAdminsAffected() throws Exception {
        return this.getAttribute(ADMINSAFFECTED_ATTRIBUTE).getBoolean();
    }

    public void setAdminsAffected(boolean value) throws Exception {
        this.setAttribute(ADMINSAFFECTED_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new AccessControlListObjectClientBeanDefinition(sessionController);
    }

    public void grantOrRevokeAccess(AccessControlEntryObjectClientBeanDefinition aceDef) throws Exception {
        this.grantOrRevokeAccess(new AccessControlEntryObjectClientBeanDefinition[]{aceDef});
    }

    public void grantOrRevokeAccess(AccessControlEntryObjectClientBeanDefinition[] aceDef) throws Exception {
        if (aceDef != null) {
            AccessControlListObjectClientBeanDefinition aclDef = (AccessControlListObjectClientBeanDefinition)this.getNewDefinition(this.sessionController);
            aclDef.setSystemOption("PerformUpdateCallbacks", "");
            int len = aceDef.length;
            for (int i = 0; i < len; ++i) {
                aceDef[i].setAcl(this);
                aclDef.addGranteeOrRevokeeAceDefinition(aceDef[i]);
            }
            this.update(aclDef);
        }
    }

    public void removeAccessControlEntryObject(AccessControlEntryObjectClientBean ace) throws Exception {
        AccessControlListObjectRemote remAcl = (AccessControlListObjectRemote)this.getRemoteReference();
        remAcl.removeAccessControlEntryObject(this.sessionController, this, ace);
    }

    public void removeAccessControlEntryObject(AccessControlEntryObjectClientBean[] aces) throws Exception {
        if (aces != null) {
            int len = aces.length;
            for (int i = 0; i < len; ++i) {
                if (aces[i] == null) continue;
                this.removeAccessControlEntryObject(aces[i]);
            }
        }
    }

    public void removeAllAccessControlEntryObject() throws Exception {
        AccessControlListObjectRemote remAcl = (AccessControlListObjectRemote)this.getRemoteReference();
        remAcl.removeAllAccessControlEntryObject(this.sessionController, this);
    }

    @ObjDocAttribute(value="All access control entries of this ACL")
    public AccessControlEntryObjectClientBean[] getAccessControlEntries() throws Exception {
        AccessControlListObjectRemote remAcl = (AccessControlListObjectRemote)this.getRemoteReference();
        return remAcl.getAccessControlEntries(this.sessionController, this);
    }

    public AccessControlEntryObjectClientBean[] getAccessControlEntries(DirectoryObjectClientBean grantee) throws Exception {
        AccessControlListObjectRemote remAcl = (AccessControlListObjectRemote)this.getRemoteReference();
        return remAcl.getAccessControlEntries(this.sessionController, this, grantee);
    }

    @Override
    public void leaveAclAfterMove(AccessControlListObjectClientBean acl, SuperObjectClientBeanDefinition def) throws Exception {
    }

    public GlobalObjectClientBean[] getAllDeletedObjects() throws Exception {
        GlobalObjectClientBean[] objects = null;
        SearchClass sc = new SearchClass(this.sessionController);
        sc.setBindOn();
        sc.setClassname(new String[]{GlobalObjectClientBean.CLASS_NAME});
        sc.setAttributeGREATER_THAN(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, (Object)new Date(0L), false);
        sc.setAttributeEQUAL(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.ACL_ATTRIBUTE, (Object)this, false);
        sc.setSearchClauseAND();
        sc.setAttributeNOT_IN(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.ID_ATTRIBUTE, (Object)"select ccc.RIGHTOBJECT from relationobject ccc, folderrelationobject ddd where ccc.id = ddd.id", false);
        sc.setSearchClauseAND();
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME);
        System.err.println("getAllDeletedObjects SQL : " + sc.getSQL());
        objects = sc.getItems();
        return objects;
    }

    @Override
    public void executeBeforeItemAdded(SessionController sessionController, GlobalObjectClientBean lo, GlobalObjectClientBean ro, SuperObjectClientBeanDefinition relDef) throws Exception {
        if (!sessionController.isInSychronization()) {
            String pathPrefix = "/agorum/roi/administration/role";
            String loFolderPath = null;
            try {
                loFolderPath = lo.getAnyFolderPath().toLowerCase();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (loFolderPath != null && !loFolderPath.startsWith(pathPrefix)) {
                ExceptionUtils.handleException("Wrong folder for an ACL", "agorum.roi.remote.exception.WrongFolderForObject", 65);
            }
        }
        super.executeBeforeItemAdded(sessionController, lo, ro, relDef);
    }

    @ObjDocAttribute(value="Return all granted users for this acl")
    public DirectoryUserObjectClientBean[] getAllGrantedUsers() throws Exception {
        return this.getAllGrantedUsers(false);
    }

    @ObjDocAttribute(value="Return all granted users for this acl")
    public DirectoryUserObjectClientBean[] getAllGrantedUsersWithoutLock() throws Exception {
        return this.getAllGrantedUsers(true);
    }

    public DirectoryUserObjectClientBean[] getAllGrantedUsers(boolean hideLockedUsers) throws Exception {
        ArrayList<DirectoryUserObjectClientBean> userRet = new ArrayList<DirectoryUserObjectClientBean>();
        HashSet<Long> done = new HashSet<Long>();
        AccessControlEntryObjectClientBean[] entries = this.getAccessControlEntries();
        if (entries != null) {
            for (AccessControlEntryObjectClientBean entry : entries) {
                if (!entry.getGranted()) continue;
                DirectoryObjectClientBean grantee = null;
                try {
                    grantee = entry.getGrantee();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (grantee == null) continue;
                if (grantee instanceof DirectoryGroupObjectClientBean) {
                    DirectoryGroupObjectClientBean group = (DirectoryGroupObjectClientBean)grantee;
                    DirectoryObjectClientBean[] users = group.getAllUserMembers();
                    if (users == null) continue;
                    for (DirectoryObjectClientBean user : users) {
                        if (done.contains(user.getId()) || hideLockedUsers && user.isLocked()) continue;
                        userRet.add((DirectoryUserObjectClientBean)user);
                        done.add(user.getId());
                    }
                    continue;
                }
                if (done.contains(grantee.getId()) || hideLockedUsers && grantee.isLocked()) continue;
                userRet.add((DirectoryUserObjectClientBean)grantee);
                done.add(grantee.getId());
            }
        }
        if (userRet.size() > 0) {
            return userRet.toArray(new DirectoryUserObjectClientBean[0]);
        }
        return null;
    }

    @Override
    public void delete(SuperObjectClientBeanDefinition def) throws Exception {
        if (def != null && def.getSystemOption("SetExpirationDateInsteadOfDelete") != null) {
            ExceptionUtils.handleException("ACL can not be put into the trash, but only deleted directly", "agorum.roi.remote.exception.NotAllowed", 20);
        }
        super.delete(def);
    }
}

