/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.common.utils.JavaUtil;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.PermissionBundleObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;

@ObjDoc(groups={ObjDoc.Group.ADMINISTRATION}, description="Client Bean for the AccessControlEntryObject Class")
public class AccessControlEntryObjectClientBean
extends InternalObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "ACCESSCONTROLENTRYOBJECT";
    public static String PERMISSIONBUNDLEOBJECTS_ATTRIBUTE = "PERMISSIONBUNDLEOBJECTS";
    public static String GRANTEE_ATTRIBUTE = "GRANTEE";
    public static String GRANTED_ATTRIBUTE = "GRANTED";
    public static String ACL_ATTRIBUTE = "ACL";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new AccessControlEntryObjectClientBeanDefinition(sessionController);
    }

    @ObjDocAttribute(value="get the Grantee of this AccessControl Entry")
    public DirectoryObjectClientBean getGrantee() throws Exception {
        return (DirectoryObjectClientBean)this.getAttribute(GRANTEE_ATTRIBUTE).getGlobalObjectClientBean(this.sessionController);
    }

    @ObjDocAttribute(value="return, if the actual User/Group is granted(true) or revoked(false)")
    public boolean getGranted() throws Exception {
        return this.getAttribute(GRANTED_ATTRIBUTE).getBoolean();
    }

    @ObjDocAttribute(value="return, if the actual User/Group is granted(true) or revoked(false)")
    public AccessControlListObjectClientBean getAcl() throws Exception {
        return (AccessControlListObjectClientBean)this.getAttribute(ACL_ATTRIBUTE).getGlobalObjectClientBean(this.sessionController);
    }

    public PermissionBundleObjectClientBean[] getPermissionBundleObjects() throws Exception {
        JavaUtil ju = new JavaUtil();
        Object[] iArr = this.getAttribute(PERMISSIONBUNDLEOBJECTS_ATTRIBUTE).getInternalObjectClientBeanArray(this.sessionController);
        try {
            return (PermissionBundleObjectClientBean[])ju.convertArray(iArr, PermissionBundleObjectClientBean.class.getName());
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }
}

