/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.roi.common.utils.JavaUtil;
import agorum.roi.ejb.callback.CustomDirectoryObjectCallBack;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.ContentQuotaObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AccessCounterUtils;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueDirectoryObjectClientBean;
import agorum.roi.ejb.common.BaseCredentialManager;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.CredentialConfig;
import agorum.roi.ejb.common.CredentialManager;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.EventAssistanceUtils;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.UserSequenceUtils;
import agorum.roi.interfaces.adminsync.AdminSyncServiceCaller;
import agorum.roi.search.SearchClass;
import java.sql.Connection;

public class DirectoryUserObjectCallBack
extends CustomDirectoryObjectCallBack {
    @Override
    public void executeBeforeCreate(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        this.checkRole(sessionController, def);
        if (def.getAttribute(DirectoryUserObjectClientBean.DEFAULTROLE_ATTRIBUTE) == null) {
            def.setAttribute(DirectoryUserObjectClientBean.DEFAULTROLE_ATTRIBUTE, new AttributeValueDirectoryObjectClientBean(def.getId()));
        }
        super.executeBeforeCreate(sessionController, def);
    }

    @Override
    public void executeBeforeUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        AttributeValue av;
        AttributeValue avAdminEnabled;
        long sysFlags;
        AttributeValue sysFlagsAttr;
        this.checkRole(sessionController, def);
        DirectoryUserObjectClientBean duocb = (DirectoryUserObjectClientBean)clientBean;
        if (duocb.getAdminenabled() && (sysFlagsAttr = def.getAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE)) != null && ((sysFlags = ((Long)sysFlagsAttr.getAttributeValue()).longValue()) & GlobalObjectClientBean.SYSTEMFLAG_SPECIALBEHAVIOUR) > 0L) {
            ExceptionUtils.handleException("admin user cannot be set as read only users", "agorum.roi.remote.exception.NotAllowed", 20);
        }
        if (!sessionController.isInSychronization() && sessionController.isMainAdmin(duocb.getId(), duocb.getId()) && !sessionController.isMainAdmin()) {
            ExceptionUtils.handleException("Only main admin is allowed to change the main admin", "agorum.roi.remote.exception.NoAccess", 21);
        }
        if ((avAdminEnabled = def.getAttribute(DirectoryUserObjectClientBean.ADMINENABLED_ATTRIBUTE)) != null && avAdminEnabled.getBoolean() == duocb.getAdminenabled()) {
            def.removeAttribute(DirectoryUserObjectClientBean.ADMINENABLED_ATTRIBUTE);
        }
        if ((av = def.getAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE)) != null) {
            AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)av.getGlobalObjectClientBean(sessionController);
            long aclid = acl.getId();
            GlobalObjectClientBean[] profiles = duocb.getUserProfileObjects();
            if (profiles != null) {
                int len = profiles.length;
                for (int i = 0; i < len; ++i) {
                    if (profiles[i] == null || profiles[i].getAcl() != null && (profiles[i].getAcl() == null || profiles[i].getAcl().getId() == aclid)) continue;
                    profiles[i].setAcl(acl);
                }
            }
        }
        if ((av = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE)) != null) {
            def.setAttribute(DirectoryUserObjectClientBean.UNIQUENAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(av.getString().toUpperCase()));
        }
        String oldCred = duocb.getCredentialManager();
        String newCred = null;
        try {
            newCred = def.getAttribute(DirectoryUserObjectClientBean.CREDENTIALMANAGER_ATTRIBUTE).getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newCred != null && !oldCred.equalsIgnoreCase(newCred)) {
            sessionController.changeCredential(duocb.getName(), oldCred, newCred);
        }
        super.executeBeforeUpdate(sessionController, def, clientBean);
    }

    private void checkRole(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        if (!(def.getAttribute(DirectoryUserObjectClientBean.DEFAULTROLE_ATTRIBUTE) == null && def.getAttribute(DirectoryUserObjectClientBean.ASSOCIATEDROLES_ATTRIBUTE) == null || sessionController.isAdminEnabled())) {
            ExceptionUtils.handleException("No Access", "agorum.roi.remote.exception.NoAccess", 21);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        DirectoryUserObjectClientBean ducb = (DirectoryUserObjectClientBean)clientBean;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            Connection conn = cu.getConnection();
            UserSequenceUtils usu = new UserSequenceUtils(conn);
            ducb.setUserSequence(usu.getUserSequence(ducb.getId()));
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        if (ducb.getAdminenabled()) {
            sessionController.resolveAdminAffectedAcls();
        }
        super.executeAfterCreate(sessionController, def, clientBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        DirectoryUserObjectClientBean ducb = (DirectoryUserObjectClientBean)clientBean;
        if (sessionController.isAdminEnabled()) {
            AdminSyncServiceCaller assu = new AdminSyncServiceCaller();
            assu.syncObject(sessionController, (GlobalObjectClientBean)clientBean, null, null, null, true, def.getAllSystemOption(), "executeBeforeDelete");
            DirectoryUserObjectClientBean childUser = null;
            Object cuObj = def.getSystemOption("childUser");
            if (cuObj instanceof DirectoryUserObjectClientBean) {
                childUser = (DirectoryUserObjectClientBean)cuObj;
            } else if (cuObj instanceof String) {
                childUser = sessionController.getUserByName((String)cuObj);
            }
            if (childUser == null) {
                childUser = sessionController.getLoginUser();
            } else {
                def.setSystemOption("childUser", childUser);
            }
            FolderObjectClientBean tmp = null;
            try {
                tmp = ducb.getPrimrayUserProfile().getTmpFolder();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmp != null) {
                tmp.delete(def);
            }
            FolderObjectClientBean userHome = null;
            try {
                userHome = ducb.getPrimrayUserProfile().getHomeFolder();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (userHome != null) {
                if (def.getSystemOption("deleteUserHome") != null) {
                    userHome.delete(def);
                } else {
                    FolderObjectClientBean home = (FolderObjectClientBean)sessionController.findGlobalObjectByPath("/Home");
                    home.removeItem(userHome);
                    RoiFileSystem rfs = new RoiFileSystem(sessionController);
                    FolderObjectClientBean moveFolder = rfs.createFullpath("MyFiles/removeedUsers/" + ducb.getName() + "(" + ducb.getId() + ")", sessionController.getLoginUser().getPrimrayUserProfile().getHomeFolder(), childUser.getPrimrayUserProfile().getHomeFolder().getAcl());
                    moveFolder.addItem(userHome);
                }
            }
            if (ducb.getPrimaryUserProfile() != null) {
                ContentQuotaObjectClientBean quota = null;
                try {
                    quota = ducb.getPrimrayUserProfile().getContentQuotaObject();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (quota != null) {
                    quota.delete(def);
                }
            }
            this.changeObjectsAttributeToChildUser(sessionController, ducb, childUser, GlobalObjectClientBean.CREATOR_ATTRIBUTE);
            this.changeInternalObjectsAttributeToChildUser(sessionController, ducb, childUser, InternalObjectClientBean.CREATOR_ATTRIBUTE);
            this.changeObjectsAttributeToChildUser(sessionController, ducb, childUser, GlobalObjectClientBean.OWNER_ATTRIBUTE);
            this.changeObjectsAttributeToChildUser(sessionController, ducb, childUser, GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE);
            CredentialConfig config = BaseCredentialManager.getCredentialConfig(ducb.getCredentialManager());
            CredentialManager cm = BaseCredentialManager.getCredentialManager(config);
            cm.deleteCredential(sessionController, ducb.getDistinguishedName());
            GlobalObjectClientBean[] upos = ducb.getUserProfileObjects();
            if (upos != null) {
                int len = upos.length;
                for (int i = 0; i < len; ++i) {
                    upos[i].delete(def);
                }
            }
            AccessCounterUtils acu = new AccessCounterUtils(sessionController);
            acu.deleteAllAccessCounterUserObjects(ducb);
            this.deleteAllAccessControlEntriesFromUser(sessionController, ducb);
            ConnectionUtils cu = null;
            try {
                cu = new ConnectionUtils(sessionController);
                Connection conn = cu.getConnection();
                EventAssistanceUtils eau = new EventAssistanceUtils(conn);
                eau.deleteUserFromAllIds(ducb.getUserSequence());
                UserSequenceUtils usu = new UserSequenceUtils(conn);
                usu.freeUserSequence(ducb.getUserSequence());
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
            finally {
                try {
                    cu.closeConnection();
                }
                catch (Exception exception) {}
            }
            super.executeBeforeDelete(sessionController, def, clientBean);
        } else {
            ExceptionUtils.handleException("No access to delete this user", "agorum.roi.remote.exception.NoAccess", 21);
        }
    }

    @Override
    public void executeAfterUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        AttributeValue av;
        int lockState;
        AttributeValue avLock;
        String name = ((GlobalObjectClientBean)clientBean).getName();
        DirectoryUserObjectClientBean ducb = (DirectoryUserObjectClientBean)clientBean;
        if (name.equalsIgnoreCase("roi") && (avLock = def.getAttribute(GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE)) != null && (lockState = avLock.getInteger()) > 0) {
            ExceptionUtils.handleException("User '" + name + "' lock is not allowed", "agorum.roi.remote.exception.NotAllowed", 20);
        }
        if ((av = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE)) != null) {
            name = av.getString();
        }
        String userName = name;
        CredentialObject credential = new CredentialObject();
        credential.setUserName(userName);
        CredentialManager credMan = BaseCredentialManager.getCredentialManager(credential);
        credMan.updatePaths(sessionController, userName);
        if (def.getAttribute(DirectoryUserObjectClientBean.ADMINENABLED_ATTRIBUTE) != null) {
            if (!ducb.getAdminenabled()) {
                sessionController.removeAdminAffectedAcls(ducb);
            }
            sessionController.resolveAdminAffectedAcls();
        }
        super.executeAfterUpdate(sessionController, def, clientBean);
    }

    private void deleteAllAccessControlEntriesFromUser(SessionController sessionController, DirectoryUserObjectClientBean ducb) throws Exception {
        Object[] goRet = null;
        SearchClass sc = new SearchClass(sessionController);
        sc.setBindOn();
        sc.setClassname(new String[]{InternalObjectClientBean.CLASS_NAME, AccessControlEntryObjectClientBean.CLASS_NAME});
        sc.setJoin(InternalObjectClientBean.CLASS_NAME, null, AccessControlEntryObjectClientBean.CLASS_NAME, null);
        sc.setAttributeEQUAL(AccessControlEntryObjectClientBean.CLASS_NAME, AccessControlEntryObjectClientBean.GRANTEE_ATTRIBUTE, (Object)ducb, false);
        sc.setSearchClauseAND();
        sc.openSearch(InternalObjectClientBean.CLASS_NAME, "DirectoryUserObjectCallBack.deleteAllAccessControlEntriesFromUser");
        goRet = sc.getItemsInternalObject();
        sc.closeSearch();
        JavaUtil ju = new JavaUtil();
        AccessControlEntryObjectClientBean[] entryRet = null;
        try {
            entryRet = (AccessControlEntryObjectClientBean[])ju.convertArray(goRet, AccessControlEntryObjectClientBean.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entryRet != null) {
            int len = entryRet.length;
            for (int i = 0; i < len; ++i) {
                if (entryRet[i] == null) continue;
                entryRet[i].delete();
            }
        }
    }

    protected void changeObjectsAttributeToChildUser(SessionController sessionController, DirectoryUserObjectClientBean ducb, DirectoryUserObjectClientBean childUser, String attributeName) throws Exception {
        SuperObjectClientBean[] soArr = sessionController.getSuperObjectByAttribute(sessionController, attributeName, ducb, false, sessionController.getClassObject(GlobalObjectClientBean.CLASS_NAME));
        if (soArr != null) {
            int len = soArr.length;
            for (int i = 0; i < len; ++i) {
                GlobalObjectClientBean gocb = (GlobalObjectClientBean)soArr[i];
                gocb.setAttribute(attributeName, AttributeValue.newAttributeValueObject(childUser));
            }
        }
    }

    protected void changeInternalObjectsAttributeToChildUser(SessionController sessionController, DirectoryUserObjectClientBean ducb, DirectoryUserObjectClientBean childUser, String attributeName) throws Exception {
        SuperObjectClientBean[] soArr = sessionController.getSuperObjectByAttribute(sessionController, attributeName, ducb, false, sessionController.getClassObject(InternalObjectClientBean.CLASS_NAME));
        if (soArr != null) {
            int len = soArr.length;
            for (int i = 0; i < len; ++i) {
                InternalObjectClientBean incb = (InternalObjectClientBean)soArr[i];
                incb.setAttribute(attributeName, AttributeValue.newAttributeValueObject(childUser));
            }
        }
    }
}

