/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.beans;

import agorum.commons.logging.TimeSpanLogger;
import agorum.commons.statistic.Statistic;
import agorum.roi.common.ClassHolder;
import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.callback.SuperObjectCallBack;
import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientCachedBean;
import agorum.roi.ejb.common.AttributeAddArrayBean;
import agorum.roi.ejb.common.AttributeInsertArrayAtBean;
import agorum.roi.ejb.common.AttributeRemoveArrayAtBean;
import agorum.roi.ejb.common.AttributeRemoveArrayBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.AttributeValueDBUtils;
import agorum.roi.ejb.common.CallBackUtils;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.DbPrimaryKey;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.ObjectUpdateHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.UpdateCounterCacheHandler;
import agorum.roi.ejb.database.common.BaseDatabaseImpl;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import agorum.roi.ejb.interfaces.home.ClassObjectHome;
import agorum.roi.ejb.interfaces.remote.SuperObjectEntityRemote;
import agorum.roi.ejb.interfaces.remote.SuperObjectRemote;
import agorum.roi.exception.RoiException;
import agorum.roi.statistic.DatabaseAccessStatistic;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.rmi.PortableRemoteObject;

public class SuperObjectEntity
implements EntityBean {
    private static final long TIMESPAN_WARN_MILLIS = 200L;
    private static final String MEASUREMENT_REMOVED_ENTITIES = "Removed Entities";
    private static final String MEASUREMENT_INSERTED_ENTITIES = "Inserted Entities";
    private static final String MEASUREMENT_UPDATED_ENTITIES = "Updated Entities";
    private static final String MEASUREMENT_LOADED_ENTITIES = "Loaded Entities";
    protected transient boolean dirty = false;
    protected EntityContext eCtx = null;
    protected transient Long id = null;
    protected transient Long classId = null;
    private transient String clientBeanClassName = null;
    protected transient Hashtable attributes = new Hashtable();
    protected transient Hashtable classLoaded = new Hashtable();
    private transient SuperObjectClientBeanDefinition definition = null;
    protected transient boolean classIsInitialized = false;
    protected transient boolean initComplete = true;
    private transient long lastUpdateCounter = 0L;
    private static int instanceCounter = 0;
    private transient int myInstanceCount = 0;
    protected transient Hashtable initialAttributes = null;
    private transient long initialTime = 0L;
    private boolean logEnabled = false;
    private static final Statistic stat = DatabaseAccessStatistic.getInstance();

    public DbPrimaryKey ejbCreate(DbPrimaryKey pk) throws CreateException {
        throw new CreateException("not implemented, use: create(PrimaryKey, SessionController)");
    }

    public synchronized DbPrimaryKey ejbCreate(SessionController sessionController, DbPrimaryKey pk) throws CreateException {
        try {
            this.initComplete = false;
            this.attributes = new Hashtable();
            this.classLoaded = new Hashtable();
            this.definition = pk.getDefinition();
            this.id = this.definition.getId();
            this.insertAttributesDB(sessionController);
            this.definition = null;
            pk.id = this.id;
            this.dirty = false;
            this.initComplete = true;
            return pk;
        }
        catch (Exception e) {
            if (e instanceof RoiException) {
                e.printStackTrace();
                RoiException roiE = (RoiException)e;
                throw new CreateException(roiE.getErrorKey() + "|" + roiE.getErrorMessage());
            }
            throw new CreateException(e.getMessage());
        }
    }

    public void ejbPostCreate(DbPrimaryKey pk) {
        this.dirty = false;
    }

    public void ejbPostCreate(SessionController sessionController, DbPrimaryKey pk) {
        this.dirty = false;
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
        DbPrimaryKey pk = (DbPrimaryKey)this.eCtx.getPrimaryKey();
        this.id = pk.id;
        if (this.logEnabled) {
            this.doLog("SuperObjectEntity: " + this.id + ", ejbActivate: " + this.classId);
        }
        this.classId = null;
        this.clientBeanClassName = null;
        this.attributes = new Hashtable();
        this.classLoaded = new Hashtable();
        this.definition = null;
        this.classIsInitialized = false;
        this.initComplete = true;
        this.lastUpdateCounter = 0L;
        if (this.logEnabled) {
            this.doLog("reset updatecounter: id=" + this.id + ", counter=" + this.lastUpdateCounter);
        }
        this.dirty = true;
    }

    public void ejbRemove() throws RemoteException {
        if (this.logEnabled) {
            this.doLog("SuperObjectEntity: " + this.id + ", ejbRemove: " + this.classId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(SessionController sessionController, SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition deleteDefinition) throws RemoveException, RemoteException, Exception {
        try (TimeSpanLogger.Auto tsl = new TimeSpanLogger(stat).name("SuperObjectEntity remove").logAs("DEBUG").alertAs("WARNING").alertAt(200L).measurement().auto();){
            this.checkIsActivated(sessionController);
            if (this.logEnabled) {
                this.doLog("SuperObjectEntity: " + this.id + ", remove: " + this.classId);
            }
            ObjectUpdateHandler.removeUpdateCounterStatic(this.id);
            ConnectionUtils cu = null;
            try {
                cu = new ConnectionUtils();
                this.deleteFromDB(cu.getConnection(), sessionController);
                this.dirty = false;
                stat.count(MEASUREMENT_REMOVED_ENTITIES, 1L);
            }
            catch (Exception e) {
                stat.warning((Throwable)e);
                ExceptionUtils.handleException(e);
            }
            finally {
                try {
                    cu.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void unsetEntityContext() throws RemoteException {
        this.eCtx = null;
    }

    public void setEntityContext(EntityContext eCtx) throws RemoteException {
        this.eCtx = eCtx;
    }

    public void ejbStore() throws RemoteException {
    }

    public synchronized void ejbStore(SessionController sessionController, SuperObjectClientBean clientBean) throws RemoteException, Exception {
        if (this.logEnabled) {
            this.doLog("SuperObjectEntity: " + this.id + ", ejbStore: " + this.classId);
        }
        if (this.dirty) {
            this.dirty = false;
            this.updateAttributesDB(sessionController, clientBean);
            this.definition = null;
        }
    }

    public void ejbLoad() throws RemoteException {
        this.dirty = false;
    }

    public void ejbLoad(SessionController sessionController, DbPrimaryKey pk) throws RemoteException, Exception {
        this.dirty = false;
    }

    public synchronized void ejbLoad(SessionController sessionController, Long myClassId, DbPrimaryKey pkIntern) throws RemoteException, Exception {
        if (this.logEnabled) {
            this.doLog("SuperObjectEntity: " + this.id + ", ejbLoad: " + this.classId + ", " + this.classIsInitialized);
        }
        if (!this.classIsInitialized) {
            this.initComplete = false;
            DbPrimaryKey pk = null;
            try {
                pk = this.eCtx != null ? (DbPrimaryKey)this.eCtx.getPrimaryKey() : pkIntern;
                long timeStamp = System.currentTimeMillis();
                long givenId = -1L;
                try {
                    if (this.initialAttributes != null && this.initialAttributes.containsKey(GlobalObjectClientBean.ID_ATTRIBUTE)) {
                        givenId = ((AttributeValue)this.initialAttributes.get(GlobalObjectClientBean.ID_ATTRIBUTE)).getLong();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pk == null || this.initialAttributes == null || timeStamp - this.initialTime > 1000L || givenId == -1L || givenId != this.id) {
                    this.classId = myClassId;
                    this.loadAllAttributesForClass(myClassId, sessionController);
                } else if (pk != null) {
                    if (!this.classIsInitialized) {
                        this.attributes = this.initialAttributes;
                    }
                    pk.setAttributes(null);
                    this.initialAttributes = null;
                }
                this.classId = new Long(this.getAttribute(sessionController, GlobalObjectClientBean.CLASSID_ATTRIBUTE).getLong());
                this.clientBeanClassName = pk.getClassName();
                if (this.clientBeanClassName == null) {
                    ClassObjectClientBean co = sessionController.getClassObject(this.classId);
                    this.clientBeanClassName = co.getUniqueName();
                }
                if (!this.classIsInitialized && myClassId != 1L) {
                    this.loadAllAttributesForClass(this.classId, sessionController);
                }
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
            this.dirty = false;
            this.classIsInitialized = true;
            this.initComplete = true;
        }
        this.initialAttributes = null;
    }

    public DbPrimaryKey ejbFindByPrimaryKey(DbPrimaryKey pk) throws FinderException, RemoteException {
        throw new FinderException("not Supported, use: findByPrimaryKey(PrimaryKey, sessionController)");
    }

    public DbPrimaryKey ejbFindByPrimaryKey(SessionController sessionController, DbPrimaryKey pk, Hashtable initialAttributes) throws FinderException, RemoteException {
        if (this.logEnabled) {
            this.doLog("SuperObjectEntity: " + this.id + ", ejbFindByPrimaryKey: " + this.classId);
        }
        this.myInstanceCount = instanceCounter++;
        if (pk == null || pk.id == null) {
            throw new FinderException("primary Key is NULL");
        }
        this.initialAttributes = initialAttributes;
        this.initialTime = System.currentTimeMillis();
        this.id = pk.id;
        pk.setAttributes(null);
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAttributesDB(SessionController sessionController, SuperObjectClientBean clientBean) throws RemoteException, Exception {
        try (TimeSpanLogger.Auto tsl = new TimeSpanLogger(stat).name("SuperObjectEntity update").logAs("DEBUG").alertAs("WARNING").alertAt(200L).measurement().auto();){
            if (this.logEnabled) {
                this.doLog("SuperObjectEntity: " + this.id + ", updateAttributesDb: " + this.classId);
            }
            Connection conn = null;
            Statement ps = null;
            CallBackUtils cbu = null;
            try {
                if (this.definition != null) {
                    SuperObjectClientBeanDefinition localDefinition = this.definition;
                    try {
                        cbu = new CallBackUtils();
                        SuperObjectCallBack callBack = cbu.getCallBackFromClassId(sessionController, this.classId);
                        conn = cbu.getConnection();
                        SuperObjectClientCachedBean cachedBean = SuperObjectClientCachedBean.getCachedBean(clientBean.getId());
                        if (cachedBean == null || !cachedBean.isTransacted()) {
                            SuperObjectClientCachedBean.setCachedBeanTransacted(clientBean);
                        }
                        callBack.executeBeforeUpdate(sessionController, localDefinition, clientBean);
                        Long aclId = null;
                        try (AutoCloseable ignored = localDefinition.prepareUpdate(this.id);){
                            AttributeValue aclAv = localDefinition.getAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE);
                            if (aclAv != null) {
                                aclId = (Long)aclAv.getAttributeValue();
                            }
                            Hashtable updAttr = localDefinition.getAttributes();
                            Enumeration attrEnum = updAttr.keys();
                            while (attrEnum.hasMoreElements()) {
                                Vector addArrayElement = null;
                                Vector insertArrayElementAt = null;
                                Vector removeArrayElement = null;
                                Vector removeArrayElementAt = null;
                                Long classIdTmp = (Long)attrEnum.nextElement();
                                ClassObjectClientBean co = sessionController.getClassObject(classIdTmp);
                                String tableName = co.getDataBaseObjectName();
                                Hashtable allAttr = (Hashtable)updAttr.get(classIdTmp);
                                StringBuffer rows = new StringBuffer();
                                rows.append("set ");
                                String colon = "";
                                Hashtable effAttributes = co.getEffectiveAttributes();
                                Hashtable attr = (Hashtable)allAttr.clone();
                                if (attr.containsKey(GlobalObjectClientBean.CLASSID_ATTRIBUTE)) {
                                    attr.remove(GlobalObjectClientBean.CLASSID_ATTRIBUTE);
                                }
                                if (attr.containsKey("@addArrayElement@")) {
                                    addArrayElement = (Vector)attr.get("@addArrayElement@");
                                    attr.remove("@addArrayElement@");
                                }
                                if (attr.containsKey("@insertArrayElementAt@")) {
                                    insertArrayElementAt = (Vector)attr.get("@insertArrayElementAt@");
                                    attr.remove("@insertArrayElementAt@");
                                }
                                if (attr.containsKey("@removeArrayElementAt@")) {
                                    removeArrayElementAt = (Vector)attr.get("@removeArrayElementAt@");
                                    attr.remove("@removeArrayElementAt@");
                                }
                                if (attr.containsKey("@removeArrayElement@")) {
                                    removeArrayElement = (Vector)attr.get("@removeArrayElement@");
                                    attr.remove("@removeArrayElement@");
                                }
                                Enumeration enum1 = attr.keys();
                                int count = 0;
                                boolean hasAdds = false;
                                while (enum1.hasMoreElements()) {
                                    String attrName = enum1.nextElement().toString();
                                    AttributeObjectClientBean attrObj = (AttributeObjectClientBean)effAttributes.get(attrName.toUpperCase());
                                    String colName = attrObj.getDataBaseObjectName();
                                    rows.append(colon);
                                    rows.append(colName);
                                    AttributeValue av = (AttributeValue)attr.get(attrName);
                                    if (av.getAdd()) {
                                        hasAdds = true;
                                        rows.append("=");
                                        rows.append(colName);
                                        rows.append("+?");
                                    } else {
                                        rows.append("=?");
                                    }
                                    if (attrObj.getDataTypeInt() == 23) {
                                        rows.append(",");
                                        rows.append(colName + "CI");
                                        rows.append("=?");
                                    }
                                    colon = ",";
                                    ++count;
                                    localDefinition.setAttributeBeforUpdate(attrName, clientBean.getAttribute(attrName));
                                }
                                AttributeValueDBUtils attributeValueDBUtils = new AttributeValueDBUtils();
                                if (count > 0) {
                                    AttributeValue av;
                                    String attrName;
                                    String stmt = "update " + tableName + " " + rows.toString() + " where ID=?";
                                    ps = conn.prepareStatement(stmt);
                                    enum1 = attr.keys();
                                    int i = 1;
                                    while (enum1.hasMoreElements()) {
                                        attrName = enum1.nextElement().toString();
                                        av = (AttributeValue)attr.get(attrName);
                                        this.setAttributeInternal(attrName, av);
                                        i = this.setAttributeStatement(attributeValueDBUtils, effAttributes, sessionController, (PreparedStatement)ps, i, av, attrName, this.id, conn, co);
                                    }
                                    ps.setLong(i, this.id);
                                    ps.executeUpdate();
                                    ps.close();
                                    ps = null;
                                    if (hasAdds) {
                                        enum1 = attr.keys();
                                        while (enum1.hasMoreElements()) {
                                            attrName = enum1.nextElement().toString();
                                            av = (AttributeValue)attr.get(attrName);
                                            if (!av.getAdd()) continue;
                                            String stmtSel = "select " + attrName + " from " + tableName + " where id=?";
                                            PreparedStatement pstmtSel = conn.prepareStatement(stmtSel);
                                            Throwable throwable = null;
                                            try {
                                                pstmtSel.setLong(1, this.id);
                                                ResultSet rSetSel = pstmtSel.executeQuery();
                                                Throwable throwable2 = null;
                                                try {
                                                    if (!rSetSel.next()) continue;
                                                    int dataType = av.getDataTypeInt();
                                                    if (dataType == 5) {
                                                        int newValue = rSetSel.getInt(1);
                                                        av.setAttributeValueDirect(newValue);
                                                    } else if (dataType == 8) {
                                                        long newValue = rSetSel.getLong(1);
                                                        av.setAttributeValueDirect(newValue);
                                                    } else {
                                                        throw new Exception("AttributeValueType not supported for add-mode");
                                                    }
                                                    this.setAttributeInternal(attrName, av);
                                                }
                                                catch (Throwable throwable3) {
                                                    throwable2 = throwable3;
                                                    throw throwable3;
                                                }
                                                finally {
                                                    if (rSetSel == null) continue;
                                                    if (throwable2 != null) {
                                                        try {
                                                            rSetSel.close();
                                                        }
                                                        catch (Throwable throwable4) {
                                                            throwable2.addSuppressed(throwable4);
                                                        }
                                                        continue;
                                                    }
                                                    rSetSel.close();
                                                }
                                            }
                                            catch (Throwable throwable5) {
                                                throwable = throwable5;
                                                throw throwable5;
                                            }
                                            finally {
                                                if (pstmtSel == null) continue;
                                                if (throwable != null) {
                                                    try {
                                                        pstmtSel.close();
                                                    }
                                                    catch (Throwable throwable6) {
                                                        throwable.addSuppressed(throwable6);
                                                    }
                                                    continue;
                                                }
                                                pstmtSel.close();
                                            }
                                        }
                                    }
                                }
                                boolean performUpdate = false;
                                if (localDefinition.getSystemOption("PerformUpdateCallbacks") != null) {
                                    performUpdate = true;
                                }
                                if (!performUpdate && count <= 0 && addArrayElement == null && insertArrayElementAt == null && removeArrayElementAt == null && removeArrayElement == null) continue;
                                if (addArrayElement != null) {
                                    this.addArrayElementDB(sessionController, conn, addArrayElement, co, attributeValueDBUtils, this.id);
                                }
                                if (insertArrayElementAt != null) {
                                    this.insertArrayElementAtDB(sessionController, conn, insertArrayElementAt, co, attributeValueDBUtils, this.id);
                                }
                                if (removeArrayElementAt != null) {
                                    this.removeArrayElementAtDB(sessionController, conn, removeArrayElementAt, co, attributeValueDBUtils, this.id);
                                }
                                if (removeArrayElement == null) continue;
                                this.removeArrayElementDB(sessionController, conn, removeArrayElement, co, attributeValueDBUtils, this.id);
                            }
                            if (clientBean.sendUpdateEvents()) {
                                UpdateCounterCacheHandler.removeUpdateCounter(this.id);
                            }
                            clientBean.resetUpdateCounter();
                            AuditUtil.createAuditEntry(clientBean, sessionController.getLoginUser(), AuditUtil.ACTION_UPDATE, updAttr);
                        }
                        callBack.executeAfterUpdate(sessionController, localDefinition, clientBean);
                        if (aclId != null) {
                            DatabaseUtils du = new DatabaseUtils();
                            BaseDatabaseImpl dbDriver = (BaseDatabaseImpl)du.getDatabaseInterfaceImpl();
                            if (this.logEnabled) {
                                this.doLog("updateAclObjectTable: id=" + this.id + ", aclId=" + aclId + ", ");
                            }
                            dbDriver.updateAclObjectTable(conn, 0L, this.id, aclId);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        ExceptionUtils.handleException(e);
                    }
                    finally {
                        try {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                        catch (Exception exception) {}
                        cbu.finishCallBack(sessionController);
                    }
                    this.definition = localDefinition;
                }
                stat.count(MEASUREMENT_UPDATED_ENTITIES, 1L);
            }
            catch (Exception e) {
                stat.warning().objectId(this.id).send((Throwable)e);
                ExceptionUtils.handleException(e);
            }
        }
    }

    private void deleteFromDB_OLD(Connection conn, SessionController sessionController) throws RemoteException, Exception {
        try {
            PreparedStatement pstmt;
            ClassObjectClientBean co = sessionController.getClassObject(this.classId);
            DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
            Hashtable<String, String> deleteArrayHash = new Hashtable<String, String>();
            while (true) {
                String tableNameObject = co.getDataBaseObjectName();
                String stmt = "delete from " + tableNameObject + " where ID = ?";
                pstmt = conn.prepareStatement(stmt);
                pstmt.setLong(1, this.id);
                pstmt.execute();
                pstmt.close();
                pstmt = null;
                Hashtable effectiveAttributes = co.getEffectiveAttributes();
                Enumeration attrEnum = effectiveAttributes.keys();
                while (attrEnum.hasMoreElements()) {
                    Object key = attrEnum.nextElement();
                    AttributeObjectClientBean attributeObject = (AttributeObjectClientBean)effectiveAttributes.get(key);
                    String dataType = attributeObject.getDataType().toUpperCase();
                    String tableName = null;
                    if (!(dataType.equalsIgnoreCase("STRING") || dataType.equalsIgnoreCase("LONG") || dataType.equalsIgnoreCase("BLOB") || dataType.equalsIgnoreCase("BOOLEAN") || dataType.equalsIgnoreCase("DATABASEOBJECT") || dataType.equalsIgnoreCase("DATE") || dataType.equalsIgnoreCase("DIRECTORYOBJECT") || dataType.equalsIgnoreCase("DOUBLE") || dataType.equalsIgnoreCase("GLOBALOBJECT") || dataType.equalsIgnoreCase("INTEGER") || dataType.equalsIgnoreCase("INTERNALOBJECT") || dataType.equalsIgnoreCase("OBJECTREFERENCE"))) {
                        if (dataType.equalsIgnoreCase("STRING_ARRAY")) {
                            tableName = dbi.getAvStringArrayTableName();
                        } else if (dataType.equalsIgnoreCase("DATABASEOBJECT_ARRAY")) {
                            tableName = dbi.getAvDatabaseObjectArrayTableName();
                        } else if (dataType.equalsIgnoreCase("DATE_ARRAY")) {
                            tableName = dbi.getAvDateArrayTableName();
                        } else if (dataType.equalsIgnoreCase("DIRECTORYOBJECT_ARRAY")) {
                            tableName = dbi.getAvDirectoryObjectArrayTableName();
                        } else if (dataType.equalsIgnoreCase("DOUBLE_ARRAY")) {
                            tableName = dbi.getAvDoubleArrayTableName();
                        } else if (dataType.equalsIgnoreCase("GLOBALOBJECT_ARRAY")) {
                            tableName = dbi.getAvGlobalobjectArrayTableName();
                        } else if (dataType.equalsIgnoreCase("INTEGER_ARRAY")) {
                            tableName = dbi.getAvIntegerArrayTableName();
                        } else if (dataType.equalsIgnoreCase("INTERNALOBJECT_ARRAY")) {
                            tableName = dbi.getAvInternalObjectArrayTableName();
                        } else if (dataType.equalsIgnoreCase("LONG_ARRAY")) {
                            tableName = dbi.getAvLongArrayTableName();
                        } else if (dataType.equalsIgnoreCase("BOOLEAN_ARRAY")) {
                            tableName = dbi.getAvBooleanArrayTableName();
                        }
                    }
                    if (tableName == null || deleteArrayHash.containsKey(tableName)) continue;
                    deleteArrayHash.put(tableName, "");
                }
                ClassObjectClientBean coSuper = (ClassObjectClientBean)co.getAttribute(ClassObjectClientBean.SUPERCLASS_ATTRIBUTE).getDataBaseObjectClientBean(sessionController);
                if (coSuper.getId().longValue() == co.getId().longValue()) break;
                co = coSuper;
            }
            if (deleteArrayHash.size() > 0) {
                Enumeration arrayEnum = deleteArrayHash.keys();
                while (arrayEnum.hasMoreElements()) {
                    String key = (String)arrayEnum.nextElement();
                    pstmt = conn.prepareStatement("select count(*) from " + key + " where " + dbi.getAVObjectIdDatabaseName() + " =?");
                    pstmt.setLong(1, this.id);
                    ResultSet rs = pstmt.executeQuery();
                    rs.next();
                    int count = rs.getInt(1);
                    if (count > 0) {
                        PreparedStatement pstmtAV = null;
                        String delete = "delete from " + key + " where " + dbi.getAVObjectIdDatabaseName() + " = ?";
                        pstmtAV = conn.prepareStatement(delete);
                        pstmtAV.setLong(1, this.id);
                        pstmtAV.execute();
                        pstmtAV.close();
                        pstmtAV = null;
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    private void deleteFromDB(Connection conn, SessionController sessionController) throws RemoteException, Exception {
        String stmt = null;
        try {
            ClassObjectClientBean co = sessionController.getClassObject(this.classId);
            DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
            Hashtable<String, String> deleteArrayHash = new Hashtable<String, String>();
            Vector vDeleteTableNames = new Vector();
            String delimiter = "";
            String delTables = "";
            String delTablesFrom = "";
            String delWhere = "";
            String lastTableNameObject = null;
            String tableNameObject = null;
            ArrayList<String> delTableAL = new ArrayList<String>();
            while (true) {
                lastTableNameObject = tableNameObject;
                tableNameObject = co.getDataBaseObjectName();
                delTables = delTables + delimiter + tableNameObject;
                delTablesFrom = delTablesFrom + delimiter + tableNameObject;
                delTableAL.add(tableNameObject);
                if (lastTableNameObject == null) {
                    delWhere = " where " + tableNameObject + ".id=?";
                    delimiter = ",";
                } else {
                    delWhere = delWhere + " and " + lastTableNameObject + ".id=" + tableNameObject + ".id";
                }
                Hashtable effectiveAttributes = co.getEffectiveAttributes();
                Enumeration attrEnum = effectiveAttributes.keys();
                while (attrEnum.hasMoreElements()) {
                    Object key = attrEnum.nextElement();
                    AttributeObjectClientBean attributeObject = (AttributeObjectClientBean)effectiveAttributes.get(key);
                    String dataType = attributeObject.getDataType().toUpperCase();
                    String tableName = null;
                    if (!(dataType.equalsIgnoreCase("STRING") || dataType.equalsIgnoreCase("CISTRING") || dataType.equalsIgnoreCase("LONG") || dataType.equalsIgnoreCase("BOOLEAN") || dataType.equalsIgnoreCase("BLOB") || dataType.equalsIgnoreCase("DATABASEOBJECT") || dataType.equalsIgnoreCase("DATE") || dataType.equalsIgnoreCase("DIRECTORYOBJECT") || dataType.equalsIgnoreCase("DOUBLE") || dataType.equalsIgnoreCase("GLOBALOBJECT") || dataType.equalsIgnoreCase("INTEGER") || dataType.equalsIgnoreCase("INTERNALOBJECT") || dataType.equalsIgnoreCase("OBJECTREFERENCE"))) {
                        if (dataType.equalsIgnoreCase("STRING_ARRAY")) {
                            tableName = dbi.getAvStringArrayTableName();
                        } else if (dataType.equalsIgnoreCase("DATABASEOBJECT_ARRAY")) {
                            tableName = dbi.getAvDatabaseObjectArrayTableName();
                        } else if (dataType.equalsIgnoreCase("DATE_ARRAY")) {
                            tableName = dbi.getAvDateArrayTableName();
                        } else if (dataType.equalsIgnoreCase("DIRECTORYOBJECT_ARRAY")) {
                            tableName = dbi.getAvDirectoryObjectArrayTableName();
                        } else if (dataType.equalsIgnoreCase("DOUBLE_ARRAY")) {
                            tableName = dbi.getAvDoubleArrayTableName();
                        } else if (dataType.equalsIgnoreCase("GLOBALOBJECT_ARRAY")) {
                            tableName = dbi.getAvGlobalobjectArrayTableName();
                        } else if (dataType.equalsIgnoreCase("INTEGER_ARRAY")) {
                            tableName = dbi.getAvIntegerArrayTableName();
                        } else if (dataType.equalsIgnoreCase("INTERNALOBJECT_ARRAY")) {
                            tableName = dbi.getAvInternalObjectArrayTableName();
                        } else if (dataType.equalsIgnoreCase("LONG_ARRAY")) {
                            tableName = dbi.getAvLongArrayTableName();
                        } else if (dataType.equalsIgnoreCase("BOOLEAN_ARRAY")) {
                            tableName = dbi.getAvBooleanArrayTableName();
                        }
                    }
                    if (tableName == null || deleteArrayHash.containsKey(tableName)) continue;
                    deleteArrayHash.put(tableName, "");
                }
                ClassObjectClientBean coSuper = (ClassObjectClientBean)co.getAttribute(ClassObjectClientBean.SUPERCLASS_ATTRIBUTE).getDataBaseObjectClientBean(sessionController);
                if (coSuper.getId().longValue() == co.getId().longValue()) break;
                co = coSuper;
            }
            dbi.deleteTables(conn, delTables, delTablesFrom, delWhere, delTableAL, this.id);
            if (deleteArrayHash.size() > 0) {
                Enumeration arrayEnum = deleteArrayHash.keys();
                while (arrayEnum.hasMoreElements()) {
                    String key = (String)arrayEnum.nextElement();
                    PreparedStatement pstmt = conn.prepareStatement("select count(*) from " + key + " where " + dbi.getAVObjectIdDatabaseName() + " =?");
                    pstmt.setLong(1, this.id);
                    ResultSet rs = pstmt.executeQuery();
                    rs.next();
                    int count = rs.getInt(1);
                    if (count > 0) {
                        PreparedStatement pstmtAV = null;
                        String delete = "delete from " + key + " where " + dbi.getAVObjectIdDatabaseName() + " = ?";
                        pstmtAV = conn.prepareStatement(delete);
                        pstmtAV.setLong(1, this.id);
                        pstmtAV.execute();
                        pstmtAV.close();
                        pstmtAV = null;
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error in delete: " + stmt);
            ExceptionUtils.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAttributesDB(SessionController sessionController) throws RemoteException, Exception {
        try (TimeSpanLogger.Auto tsl = new TimeSpanLogger(stat).name("SuperObjectEntity insert").logAs("DEBUG").alertAs("WARNING").alertAt(200L).measurement().auto();){
            Connection conn = null;
            ConnectionUtils cu = null;
            try {
                cu = new ConnectionUtils(sessionController);
                conn = cu.getConnection();
                this.classId = this.definition.getClassId();
                if (this.classId.equals(0L)) {
                    throw new Exception("ClassId not valid: 0");
                }
                ClassObjectClientBean co = sessionController.getClassObject(this.classId);
                while (true) {
                    Hashtable attrHash = this.definition.getAttributes();
                    Hashtable attr = null;
                    if (attrHash != null && attrHash.containsKey(co.getId())) {
                        attr = (Hashtable)attrHash.get(co.getId());
                    }
                    this.insertOneTable(conn, sessionController, co, attr, this.id);
                    ClassObjectClientBean coSuper = (ClassObjectClientBean)co.getAttribute(ClassObjectClientBean.SUPERCLASS_ATTRIBUTE).getDataBaseObjectClientBean(sessionController);
                    if (coSuper.getId().longValue() == co.getId().longValue()) break;
                    co = coSuper;
                }
                stat.count(MEASUREMENT_INSERTED_ENTITIES, 1L);
            }
            catch (Exception e) {
                stat.warning((Throwable)e);
                ExceptionUtils.handleException(e);
            }
            finally {
                try {
                    cu.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAttributesDB(SessionController sessionController) throws RemoteException, Exception {
        Connection conn = null;
        Statement ps = null;
        try (TimeSpanLogger.Auto tsl = new TimeSpanLogger(stat).name("SuperObjectEntity delete").logAs("DEBUG").alertAs("WARNING").alertAt(200L).measurement().auto();){
            ConnectionUtils cu = null;
            try {
                cu = new ConnectionUtils(sessionController);
                conn = cu.getConnection();
                this.id = sessionController.getSequenceId();
                this.classId = this.definition.getClassId();
                ClassObjectClientBean co = sessionController.getClassObject(this.classId);
                while (true) {
                    String tableName = co.getDataBaseObjectName();
                    ps = conn.prepareStatement("delete from " + tableName + " where ID = ?");
                    ps.setLong(1, this.id);
                    ps.executeUpdate();
                    ps.close();
                    ps = null;
                    ClassObjectClientBean coSuper = (ClassObjectClientBean)co.getAttribute(ClassObjectClientBean.SUPERCLASS_ATTRIBUTE).getDataBaseObjectClientBean(sessionController);
                    if (coSuper.getId().longValue() == co.getId().longValue()) break;
                    co = coSuper;
                }
                stat.count(MEASUREMENT_REMOVED_ENTITIES, 1L);
            }
            catch (Exception e) {
                stat.warning((Throwable)e);
                ExceptionUtils.handleException(e);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    ps = null;
                }
                catch (Exception exception) {}
                try {
                    cu.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOneTable(Connection conn, SessionController sessionController, ClassObjectClientBean co, Hashtable attrHash, Long id) throws RemoteException, Exception {
        Statement ps = null;
        String stmt = null;
        Hashtable attr = null;
        try {
            String attrName;
            AttributeObjectClientBean attribute;
            StringBuffer cols = new StringBuffer();
            cols.append("ID");
            StringBuffer vals = new StringBuffer();
            vals.append("?");
            String tableName = co.getDataBaseObjectName();
            Hashtable effectiveAttributes = co.getEffectiveAttributes();
            attr = new Hashtable();
            if (attrHash != null) {
                Enumeration attrEnum = attrHash.keys();
                while (attrEnum.hasMoreElements()) {
                    Object key = attrEnum.nextElement();
                    attribute = (AttributeObjectClientBean)effectiveAttributes.get(key);
                    AttributeValue av = (AttributeValue)attrHash.get(key);
                    if ((attribute.getDataTypeInt() == 3 || attribute.getDataTypeInt() == 23) && av != null) {
                        String value;
                        String orgValue = value = av.getString();
                        if (value != null && value.length() > attribute.getDataLength()) {
                            value = value.substring(0, attribute.getDataLength());
                            System.err.println("String is too long (" + attribute.getDataLength() + "), cut it: id=" + id + ", attribute: " + key + ", value=" + orgValue);
                            av.setString(value);
                        }
                    }
                    attr.put(key, av);
                }
            }
            Enumeration enumEff = effectiveAttributes.keys();
            while (enumEff.hasMoreElements()) {
                attrName = enumEff.nextElement().toString();
                if (attr.containsKey(attrName)) continue;
                attribute = (AttributeObjectClientBean)effectiveAttributes.get(attrName.toUpperCase());
                attr.put(attrName, attribute.getValueDefault());
            }
            enumEff = effectiveAttributes.keys();
            while (enumEff.hasMoreElements()) {
                attrName = enumEff.nextElement().toString();
                String attName = attrName.toUpperCase();
                AttributeObjectClientBean attribute2 = (AttributeObjectClientBean)effectiveAttributes.get(attName);
                String colName = attribute2.getDataBaseObjectName();
                if (!attr.containsKey(attrName) || attName.equalsIgnoreCase(colName)) continue;
                Object val = attr.get(attrName);
                attr.remove(attrName);
                attr.put(colName, (AttributeValue)val);
            }
            AttributeValueDBUtils attributeValueDBUtils = new AttributeValueDBUtils();
            Enumeration key = attr.keys();
            while (key.hasMoreElements()) {
                String attrName2 = key.nextElement().toString();
                cols.append(",");
                cols.append(attrName2);
                vals.append(",?");
                AttributeObjectClientBean attrObj = (AttributeObjectClientBean)effectiveAttributes.get(attrName2);
                if (attrObj == null || attrObj.getDataTypeInt() != 23) continue;
                cols.append(",");
                cols.append(attrName2 + "CI");
                vals.append(",?");
            }
            stmt = "insert into " + tableName + " (" + cols.toString() + ") values (" + vals.toString() + ")";
            ps = conn.prepareStatement(stmt);
            ps.setLong(1, id);
            key = attr.keys();
            int i = 2;
            while (key.hasMoreElements()) {
                String attrName3 = key.nextElement().toString();
                AttributeValue av = (AttributeValue)attr.get(attrName3);
                this.setAttributeInternal(attrName3, av);
                i = this.setAttributeStatement(attributeValueDBUtils, effectiveAttributes, sessionController, (PreparedStatement)ps, i, av, attrName3, id, conn, co);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            System.err.println("Error in insert: " + stmt);
            try {
                Enumeration key = attr.keys();
                int i = 2;
                while (key.hasMoreElements()) {
                    String attrName = key.nextElement().toString();
                    AttributeValue av = (AttributeValue)attr.get(attrName);
                    System.err.println("  Attributes[" + i + "]: " + av.toString(sessionController));
                    ++i;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace(System.err);
            }
            System.err.println("");
            int errorcode = e.getErrorCode();
            String sqlState = e.getSQLState();
            if (errorcode == 1062) {
                ExceptionUtils.handleException(e.getMessage(), "agorum.roi.remote.exception.DuplicteEntry", 70);
            } else {
                e.printStackTrace(System.err);
                ExceptionUtils.handleException(e.getMessage(), "agorum.roi.remote.exception.SQLException", 71);
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                ps.close();
                ps = null;
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadAllAttributesForClass(Long classId, SessionController sessionController) throws RemoteException, Exception {
        block9: {
            try {
                if (this.logEnabled) {
                    this.doLog("SuperObjectEntity: " + this.id + ", loadAllAttributesForClass: " + classId);
                }
                if (this.isLoaded(classId)) break block9;
                Hashtable<Long, Hashtable<String, Object>> tableSelectStatementCache = sessionController.getTableSelectStatementCache();
                Hashtable<Object, Object> mySelectHash = null;
                boolean changeCach = false;
                if (tableSelectStatementCache.containsKey(classId)) {
                    mySelectHash = tableSelectStatementCache.get(classId);
                } else {
                    mySelectHash = new Hashtable();
                    changeCach = true;
                    Hashtable<String, Object> attr = sessionController.getAllAttributesFromClassId(classId);
                    mySelectHash.put("attribute", attr);
                    ClassObjectClientBean clientBean = sessionController.getClassObject(classId);
                    String tableName = clientBean.getDataBaseObjectName();
                    mySelectHash.put("tableName", tableName);
                    Hashtable<Long, Hashtable<String, Object>> hashtable = tableSelectStatementCache;
                    synchronized (hashtable) {
                        if (!tableSelectStatementCache.containsKey(classId)) {
                            tableSelectStatementCache.put(classId, mySelectHash);
                        }
                    }
                }
                this.loadAttributesFromDB(sessionController, mySelectHash);
                this.classLoaded.put(classId, "true");
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
        }
    }

    private boolean isLoaded(Long classId) {
        boolean loaded = this.classLoaded.containsKey(classId);
        return loaded;
    }

    protected synchronized void loadAttributesFromDB(SessionController sessionController, Hashtable mySelectHash) throws RemoteException, Exception {
        try (TimeSpanLogger.Auto tsl = new TimeSpanLogger(stat).name("SuperObjectEntity load").logAs("DEBUG").alertAs("WARNING").alertAt(200L).measurement().auto();){
            if (this.logEnabled) {
                this.doLog("SuperObjectEntity: " + this.id + ", loadAttributesFromDb: " + this.classId);
            }
            boolean isMyConnection = false;
            ConnectionUtils cu = null;
            try {
                block63: {
                    Hashtable attr;
                    this.lastUpdateCounter = ObjectUpdateHandler.incrementUpdateCounterStatic(this.id);
                    if (this.logEnabled) {
                        this.doLog("increment updatecounter (1): id=" + this.id + ", counter=" + this.lastUpdateCounter);
                    }
                    if ((attr = (Hashtable)mySelectHash.get("attribute")) != null && attr.size() > 0) {
                        cu = new ConnectionUtils(sessionController);
                        try (Connection conn = cu.getConnection();){
                            String select = null;
                            Hashtable<String, Integer> attPos = null;
                            String tableName = null;
                            if (mySelectHash.containsKey("select")) {
                                select = mySelectHash.get("select").toString();
                                attPos = (Hashtable<String, Integer>)mySelectHash.get("attPos");
                            } else {
                                tableName = mySelectHash.get("tableName").toString();
                                StringBuffer rows = new StringBuffer();
                                String colon = "";
                                Enumeration key = attr.keys();
                                int count = 0;
                                attPos = new Hashtable<String, Integer>();
                                while (key.hasMoreElements()) {
                                    String attrName = key.nextElement().toString();
                                    AttributeObjectClientBean attribute = (AttributeObjectClientBean)attr.get(attrName.toUpperCase());
                                    String columnName = attribute.getDataBaseObjectName();
                                    attPos.put(columnName, new Integer(++count));
                                    rows.append(colon);
                                    rows.append(columnName);
                                    colon = ",";
                                }
                                select = "select " + rows.toString() + " from " + tableName + " where id=?";
                                mySelectHash.put("attPos", attPos);
                                mySelectHash.put("select", select);
                            }
                            try (PreparedStatement pstmt = conn.prepareStatement(select);){
                                pstmt.setLong(1, this.id);
                                try (ResultSet rs = pstmt.executeQuery();){
                                    if (rs.next()) {
                                        AttributeValueDBUtils attributeValueDBUtils = new AttributeValueDBUtils();
                                        Enumeration key = attr.keys();
                                        while (key.hasMoreElements()) {
                                            String attrName = key.nextElement().toString();
                                            AttributeObjectClientBean ao = (AttributeObjectClientBean)attr.get(attrName.toUpperCase());
                                            String columnName = ao.getDataBaseObjectName();
                                            AttributeValue av = null;
                                            try {
                                                av = attributeValueDBUtils.getAttributeValueFromResultSet(sessionController, rs, (Integer)attPos.get(columnName), ao.getDataTypeInt(), this.id, ao);
                                            }
                                            catch (Exception e) {
                                                System.err.println("Error: " + attPos + ", " + ao + ", " + columnName + ", " + this.id + ", select: " + select + ", cache: " + mySelectHash);
                                                if (attPos != null) {
                                                    System.err.println("Error: " + attPos.get(columnName));
                                                }
                                                throw e;
                                            }
                                            if (av != null) {
                                                if (this.attributes.containsKey(attrName)) {
                                                    this.attributes.remove(attrName);
                                                }
                                                this.attributes.put(attrName, av);
                                                continue;
                                            }
                                            ExceptionUtils.handleException("No AttributeValue set in loadAttributesFromDB: " + attrName + "/" + columnName, "agorum.roi.remote.exception.NoAttributeValue", 72);
                                        }
                                        break block63;
                                    }
                                    ExceptionUtils.handleException("No entry found for ID '" + this.id + "' in select " + select, "agorum.roi.remote.exception.NoEntryFound", 101);
                                }
                            }
                        }
                    }
                }
                stat.count(MEASUREMENT_LOADED_ENTITIES, 1L);
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
        }
    }

    public synchronized Long getId(SessionController sessionController) throws RemoteException, Exception {
        return this.id;
    }

    public synchronized Long getClassId(SessionController sessionController) throws RemoteException, Exception {
        if (this.classId == null || !this.classIsInitialized) {
            DbPrimaryKey pk = (DbPrimaryKey)this.eCtx.getPrimaryKey();
            this.ejbLoad(sessionController, pk);
        }
        if (this.logEnabled) {
            this.doLog("SuperObjectEntity: " + this.id + ", getClassId: " + this.classId);
        }
        return this.classId;
    }

    public synchronized Hashtable getAttributeArray(SessionController sessionController, String attributeName) throws RemoteException, Exception {
        this.getAttribute(sessionController, attributeName);
        return this.attributes;
    }

    public synchronized AttributeValue getAttribute(SessionController sessionController, String attributeName) throws RemoteException, Exception {
        this.checkIsActivated(sessionController);
        try {
            AttributeValue avRet = null;
            Long classIdTmp = null;
            if (!this.attributes.containsKey(attributeName) && (classIdTmp = sessionController.findClassIdByAttribute(attributeName, this.classId)) != null) {
                this.loadAllAttributesForClass(classIdTmp, sessionController);
            }
            if ((avRet = (AttributeValue)this.attributes.get(attributeName)) == null) {
                try {
                    System.err.println("ALARM: hashCode = " + this.hashCode());
                    System.err.println("ALARM: getAttribute avRet is null, attributeName = " + attributeName + ", classId = " + this.classId + ", classIdTmp = " + classIdTmp);
                    if (classIdTmp != null) {
                        System.err.println("ALARM: isLoaded(classIdTmp) = " + this.isLoaded(classIdTmp));
                    }
                    System.err.println("ALARM: classId = " + sessionController.getClassObject(this.classId).getUniqueName());
                    if (classIdTmp != null) {
                        System.err.println("ALARM: classIdTmp = " + sessionController.getClassObject(classIdTmp).getUniqueName());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return avRet;
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionUtils.handleException(e);
            System.err.println("ALARM: getAttribute returning null");
            return null;
        }
    }

    public synchronized void setAttribute(SessionController sessionController, SuperObjectClientBean clientBean, String attributeName, AttributeValue value) throws RemoteException, Exception {
        this.checkIsActivated(sessionController);
        try {
            if (!this.attributes.containsKey(attributeName)) {
                Long classIdTmp = sessionController.findClassIdByAttribute(attributeName, this.classId);
                this.loadAllAttributesForClass(classIdTmp, sessionController);
            }
            if (this.definition == null) {
                this.definition = clientBean.getNewDefinition(sessionController);
            }
            this.definition.setAttribute(attributeName, value);
            this.dirty = true;
            this.ejbStore(sessionController, clientBean);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public synchronized void addArrayElement(SessionController sessionController, SuperObjectClientBean clientBean, String attributeName, AttributeValue value) throws RemoteException, Exception {
        this.checkIsActivated(sessionController);
        try {
            if (!this.attributes.containsKey(attributeName)) {
                Long classIdTmp = sessionController.findClassIdByAttribute(attributeName, this.classId);
                this.loadAllAttributesForClass(classIdTmp, sessionController);
            }
            if (this.definition == null) {
                this.definition = clientBean.getNewDefinition(sessionController);
            }
            this.definition.addArrayElement(attributeName, value);
            this.dirty = true;
            this.ejbStore(sessionController, clientBean);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public synchronized SuperObjectClientBean fillClientBean(SessionController sessionController, SuperObjectClientBean bean) throws RemoteException, Exception {
        this.checkIsActivated(sessionController);
        try {
            bean.setClassName(this.clientBeanClassName);
            bean.setAttributes(this.attributes);
            return bean;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public synchronized void setAttributeInternal(String attrName, AttributeValue av) throws RemoteException, Exception {
        this.lastUpdateCounter = ObjectUpdateHandler.incrementUpdateCounterStatic(this.id);
        if (this.logEnabled) {
            this.doLog("increment updatecounter (2): id=" + this.id + ", counter=" + this.lastUpdateCounter);
        }
        if (this.attributes.containsKey(attrName)) {
            this.attributes.remove(attrName);
        }
        this.attributes.put(attrName, av);
    }

    public synchronized void removeAttributeInternal(String attrName, Long classId) throws RemoteException, Exception {
        this.lastUpdateCounter = ObjectUpdateHandler.incrementUpdateCounterStatic(this.id);
        if (this.logEnabled) {
            this.doLog("increment updatecounter (3): id=" + this.id + ", counter=" + this.lastUpdateCounter);
        }
        if (this.attributes.containsKey(attrName)) {
            this.attributes.remove(attrName);
        }
        if (this.classLoaded.containsKey(classId)) {
            this.classLoaded.remove(classId);
        }
    }

    protected synchronized void checkIsActivated(SessionController sessionController) throws RemoteException, Exception {
        if (!this.classIsInitialized && this.initComplete) {
            DbPrimaryKey pk = (DbPrimaryKey)this.eCtx.getPrimaryKey();
            this.ejbLoad(sessionController, pk);
            this.classIsInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateAttributeArray(SessionController sessionController, AttributeValue av, String attrName, Long id, Connection conn, AttributeValueDBUtils attributeValueDBUtils, ClassObjectClientBean co) throws Exception, Exception {
        this.checkIsActivated(sessionController);
        Hashtable<String, Object> myAttributes = sessionController.getAllAttributesFromClassId(co.getId());
        AttributeObjectClientBean ao = (AttributeObjectClientBean)myAttributes.get(attrName);
        AttributeValueArray ava = (AttributeValueArray)av;
        Statement pstmt = null;
        try {
            DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
            pstmt = conn.prepareStatement("select " + dbi.getAVObjectIdDatabaseName() + "," + dbi.getAVAttributeIdDatabaseName() + "," + dbi.getAVSequenceDatabaseName() + " from " + ava.getTableName() + " where " + dbi.getAVObjectIdDatabaseName() + " = ? and " + dbi.getAVAttributeIdDatabaseName() + " = ?");
            pstmt.setLong(1, id);
            pstmt.setLong(2, ao.getId());
            ResultSet rSet = pstmt.executeQuery();
            while (rSet.next()) {
                PreparedStatement pstmtDel = conn.prepareStatement("delete from " + ava.getTableName() + " where " + dbi.getAVObjectIdDatabaseName() + " = ? and " + dbi.getAVAttributeIdDatabaseName() + " = ? and " + dbi.getAVSequenceDatabaseName() + " = ?");
                pstmtDel.setLong(1, rSet.getLong(1));
                pstmtDel.setLong(2, rSet.getLong(2));
                pstmtDel.setLong(3, rSet.getLong(3));
                pstmtDel.execute();
                pstmtDel.close();
                pstmtDel = null;
            }
            rSet.close();
            rSet = null;
            pstmt.close();
            pstmt = null;
            int len = ava.getInteger();
            int iSequence = -1;
            pstmt = conn.prepareStatement("insert into " + ava.getTableName() + "(" + dbi.getAVObjectIdDatabaseName() + "," + dbi.getAVAttributeIdDatabaseName() + "," + dbi.getAVSequenceDatabaseName() + "," + dbi.getAVValueDatabaseName() + ") values (?,?,?,?)");
            for (int k = 0; k < len; ++k) {
                pstmt.setLong(1, id);
                pstmt.setLong(2, ao.getId());
                pstmt.setInt(3, ++iSequence);
                attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 4, av, k);
                pstmt.execute();
                pstmt.clearParameters();
            }
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addArrayElementDB(SessionController sessionController, Connection conn, Vector v, ClassObjectClientBean co, AttributeValueDBUtils attributeValueDBUtils, Long id) throws Exception {
        Statement pstmt = null;
        try {
            if (v != null) {
                Hashtable<String, Object> myAttributes = sessionController.getAllAttributesFromClassId(co.getId());
                String tableName = co.getDataBaseObjectName();
                DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
                int len = v.size();
                for (int i = 0; i < len; ++i) {
                    AttributeAddArrayBean bean = (AttributeAddArrayBean)v.elementAt(i);
                    AttributeObjectClientBean ao = (AttributeObjectClientBean)myAttributes.get(bean.getAttributeName());
                    AttributeValue av = ao.getValueDefault();
                    if (av instanceof AttributeValueArray) {
                        AttributeValueArray ava = (AttributeValueArray)av;
                        av = bean.getAttributeValue();
                        int lenArr = 1;
                        if (av instanceof AttributeValueArray) {
                            lenArr = ((AttributeValueArray)av).getArrayLength();
                        }
                        long maxSequence = this.getMaxSequenceFromArray(sessionController, dbi, ava.getTableName(), conn, id, ao.getId());
                        pstmt = conn.prepareStatement("insert into " + ava.getTableName() + "(" + dbi.getAVObjectIdDatabaseName() + "," + dbi.getAVAttributeIdDatabaseName() + "," + dbi.getAVSequenceDatabaseName() + "," + dbi.getAVValueDatabaseName() + ") values (?,?,?,?)");
                        int count = 0;
                        for (int k = 0; k < lenArr; ++k) {
                            ++count;
                            pstmt.setLong(1, id);
                            pstmt.setLong(2, ao.getId());
                            pstmt.setLong(3, ++maxSequence);
                            if (attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 4, av)) {
                                attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 4, av, k);
                            }
                            pstmt.execute();
                            pstmt.clearParameters();
                        }
                        pstmt.close();
                        pstmt = null;
                        pstmt = conn.prepareStatement("update " + tableName + " set " + ao.getDataBaseObjectName() + "=" + ao.getDataBaseObjectName() + "+" + count + " where id = ?");
                        pstmt.setLong(1, id);
                        pstmt.executeUpdate();
                        this.removeAttributeInternal(bean.getAttributeName(), co.getId());
                        pstmt.close();
                        pstmt = null;
                        continue;
                    }
                    ExceptionUtils.handleException("addArrayElement, Attribute is not an Array", "agorum.roi.remote.exception.AttributeIsNotAnArray", 75);
                }
            }
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void insertArrayElementAtDB(SessionController sessionController, Connection conn, Vector v, ClassObjectClientBean co, AttributeValueDBUtils attributeValueDBUtils, Long id) throws Exception {
        Statement pstmt = null;
        Statement pstmt1 = null;
        ResultSet rs = null;
        try {
            if (v != null) {
                Hashtable<String, Object> myAttributes = sessionController.getAllAttributesFromClassId(co.getId());
                String tableName = co.getDataBaseObjectName();
                DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
                int len = v.size();
                for (int i = 0; i < len; ++i) {
                    AttributeInsertArrayAtBean bean = (AttributeInsertArrayAtBean)v.elementAt(i);
                    AttributeObjectClientBean ao = (AttributeObjectClientBean)myAttributes.get(bean.getAttributeName());
                    AttributeValue av = ao.getValueDefault();
                    long pos = bean.getAttributePos();
                    if (av instanceof AttributeValueArray) {
                        long maxSequence;
                        AttributeValueArray ava = (AttributeValueArray)av;
                        av = bean.getAttributeValue();
                        int lenArr = 1;
                        if (av instanceof AttributeValueArray) {
                            lenArr = ((AttributeValueArray)av).getArrayLength();
                        }
                        if ((maxSequence = this.getMaxSequenceFromArray(sessionController, dbi, ava.getTableName(), conn, id, ao.getId())) + 1L < pos) {
                            ExceptionUtils.handleException("Array insert out of bound", "agorum.roi.remote.exception.ArrayOutOfBound", 57);
                        }
                        pstmt1 = conn.prepareStatement("select " + dbi.getAVSequenceDatabaseName() + " from " + ava.getTableName() + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVSequenceDatabaseName() + ">=? order by " + dbi.getAVSequenceDatabaseName() + " desc");
                        pstmt1.setLong(1, id);
                        pstmt1.setLong(2, ao.getId());
                        pstmt1.setLong(3, pos);
                        rs = pstmt1.executeQuery();
                        if (rs != null) {
                            while (rs.next()) {
                                pstmt = conn.prepareStatement("update " + ava.getTableName() + " set " + dbi.getAVSequenceDatabaseName() + "=" + dbi.getAVSequenceDatabaseName() + "+" + lenArr + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVSequenceDatabaseName() + "=?");
                                pstmt.setLong(1, id);
                                pstmt.setLong(2, ao.getId());
                                pstmt.setLong(3, rs.getLong(1));
                                pstmt.execute();
                                pstmt.close();
                                pstmt = null;
                            }
                            rs.close();
                        }
                        rs = null;
                        pstmt1.close();
                        pstmt1 = null;
                        pstmt = conn.prepareStatement("insert into " + ava.getTableName() + "(" + dbi.getAVObjectIdDatabaseName() + "," + dbi.getAVAttributeIdDatabaseName() + "," + dbi.getAVSequenceDatabaseName() + "," + dbi.getAVValueDatabaseName() + ") values (?,?,?,?)");
                        int count = 0;
                        for (int k = 0; k < lenArr; ++k) {
                            ++count;
                            pstmt.setLong(1, id);
                            pstmt.setLong(2, ao.getId());
                            pstmt.setLong(3, pos);
                            if (attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 4, av)) {
                                attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 4, av, k);
                            }
                            pstmt.execute();
                            pstmt.clearParameters();
                            ++pos;
                        }
                        pstmt.close();
                        pstmt = null;
                        pstmt = conn.prepareStatement("update " + tableName + " set " + ao.getDataBaseObjectName() + "=" + ao.getDataBaseObjectName() + "+" + count + " where id = ?");
                        pstmt.setLong(1, id);
                        pstmt.executeUpdate();
                        this.removeAttributeInternal(bean.getAttributeName(), co.getId());
                        pstmt.close();
                        pstmt = null;
                        continue;
                    }
                    ExceptionUtils.handleException("insertArrayElementAt, Attribute is not an Array", "agorum.roi.remote.exception.AttributeIsNotAnArray", 75);
                }
            }
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt1.close();
                pstmt1 = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeArrayElementAtDB(SessionController sessionController, Connection conn, Vector v, ClassObjectClientBean co, AttributeValueDBUtils attributeValueDBUtils, Long id) throws Exception {
        Statement pstmt = null;
        Statement pstmt1 = null;
        ResultSet rs = null;
        try {
            if (v != null) {
                Hashtable<String, Object> myAttributes = sessionController.getAllAttributesFromClassId(co.getId());
                String tableName = co.getDataBaseObjectName();
                DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
                int len = v.size();
                for (int i = 0; i < len; ++i) {
                    AttributeRemoveArrayAtBean bean = (AttributeRemoveArrayAtBean)v.elementAt(i);
                    AttributeObjectClientBean ao = (AttributeObjectClientBean)myAttributes.get(bean.getAttributeName());
                    AttributeValue av = ao.getValueDefault();
                    long pos = bean.getAttributePos();
                    if (av instanceof AttributeValueArray) {
                        AttributeValueArray ava = (AttributeValueArray)av;
                        long maxSequence = this.getMaxSequenceFromArray(sessionController, dbi, ava.getTableName(), conn, id, ao.getId());
                        if (maxSequence < pos) {
                            ExceptionUtils.handleException("Array remove at pos " + pos + ": out of bound", "agorum.roi.remote.exception.ArrayOutOfBound", 57);
                        }
                        pstmt = conn.prepareStatement("delete from " + ava.getTableName() + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVSequenceDatabaseName() + "=?");
                        pstmt.setLong(1, id);
                        pstmt.setLong(2, ao.getId());
                        pstmt.setLong(3, pos);
                        pstmt.execute();
                        pstmt1 = conn.prepareStatement("select " + dbi.getAVSequenceDatabaseName() + " from " + ava.getTableName() + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVSequenceDatabaseName() + ">? order by " + dbi.getAVSequenceDatabaseName() + " asc");
                        pstmt1.setLong(1, id);
                        pstmt1.setLong(2, ao.getId());
                        pstmt1.setLong(3, pos);
                        rs = pstmt1.executeQuery();
                        if (rs != null) {
                            while (rs.next()) {
                                pstmt = conn.prepareStatement("update " + ava.getTableName() + " set " + dbi.getAVSequenceDatabaseName() + "=" + dbi.getAVSequenceDatabaseName() + "-1 where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVSequenceDatabaseName() + "=?");
                                pstmt.setLong(1, id);
                                pstmt.setLong(2, ao.getId());
                                pstmt.setLong(3, rs.getLong(1));
                                pstmt.execute();
                                pstmt.close();
                                pstmt = null;
                            }
                            rs.close();
                        }
                        rs = null;
                        pstmt1.close();
                        pstmt1 = null;
                        pstmt = conn.prepareStatement("update " + tableName + " set " + ao.getDataBaseObjectName() + "=" + ao.getDataBaseObjectName() + "-1 where id = ?");
                        pstmt.setLong(1, id);
                        pstmt.executeUpdate();
                        this.removeAttributeInternal(bean.getAttributeName(), co.getId());
                        pstmt.close();
                        pstmt = null;
                        continue;
                    }
                    ExceptionUtils.handleException("removeArrayElementAt, Attribute is not an Array", "agorum.roi.remote.exception.AttributeIsNotAnArray", 75);
                }
            }
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt1.close();
                pstmt1 = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeArrayElementDB(SessionController sessionController, Connection conn, Vector v, ClassObjectClientBean co, AttributeValueDBUtils attributeValueDBUtils, Long id) throws Exception {
        block30: {
            Statement pstmt = null;
            Statement pstmt1 = null;
            ResultSet rs = null;
            try {
                if (v == null) break block30;
                Hashtable<String, Object> myAttributes = sessionController.getAllAttributesFromClassId(co.getId());
                String tableName = co.getDataBaseObjectName();
                DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
                int len = v.size();
                for (int i = 0; i < len; ++i) {
                    AttributeRemoveArrayBean bean = (AttributeRemoveArrayBean)v.elementAt(i);
                    AttributeObjectClientBean ao = (AttributeObjectClientBean)myAttributes.get(bean.getAttributeName());
                    AttributeValue av = ao.getValueDefault();
                    if (av instanceof AttributeValueArray) {
                        AttributeValueArray ava = (AttributeValueArray)av;
                        av = bean.getAttributeValue();
                        int lenArr = 1;
                        if (av instanceof AttributeValueArray) {
                            lenArr = ((AttributeValueArray)av).getArrayLength();
                        }
                        String stmt = "select count(*) from " + ava.getTableName() + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVValueDatabaseName() + dbi.getTextComparator() + "?";
                        pstmt = conn.prepareStatement(stmt);
                        String stmt1 = "delete from " + ava.getTableName() + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVValueDatabaseName() + dbi.getTextComparator() + "?";
                        pstmt1 = conn.prepareStatement(stmt1);
                        int count = 0;
                        for (int k = 0; k < lenArr; ++k) {
                            pstmt.setLong(1, id);
                            pstmt.setLong(2, ao.getId());
                            if (attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 3, av)) {
                                attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 3, av, k);
                            }
                            try {
                                rs = pstmt.executeQuery();
                            }
                            catch (SQLException se) {
                                System.err.println("STMT: " + stmt);
                                throw se;
                            }
                            if (rs != null) {
                                int anz;
                                if (rs.next() && (anz = rs.getInt(1)) > 0) {
                                    pstmt1.setLong(1, id);
                                    pstmt1.setLong(2, ao.getId());
                                    if (attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt1, 3, av)) {
                                        attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt1, 3, av, k);
                                    }
                                    try {
                                        pstmt1.execute();
                                    }
                                    catch (SQLException se) {
                                        System.err.println("STMT: " + stmt1);
                                        throw se;
                                    }
                                    pstmt1.clearParameters();
                                }
                                rs.close();
                                rs = null;
                            }
                            pstmt.clearParameters();
                        }
                        pstmt.close();
                        pstmt = null;
                        pstmt1.close();
                        pstmt = null;
                        pstmt1 = conn.prepareStatement("select " + dbi.getAVSequenceDatabaseName() + " from " + ava.getTableName() + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVSequenceDatabaseName() + ">=0 order by " + dbi.getAVSequenceDatabaseName() + " asc");
                        pstmt1.setLong(1, id);
                        pstmt1.setLong(2, ao.getId());
                        rs = pstmt1.executeQuery();
                        long nextPos = 0L;
                        if (rs != null) {
                            while (rs.next()) {
                                ++count;
                                long actSequenc = rs.getLong(1);
                                if (nextPos != actSequenc) {
                                    pstmt = conn.prepareStatement("update " + ava.getTableName() + " set " + dbi.getAVSequenceDatabaseName() + "=? where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVSequenceDatabaseName() + "=?");
                                    pstmt.setLong(1, nextPos);
                                    pstmt.setLong(2, id);
                                    pstmt.setLong(3, ao.getId());
                                    pstmt.setLong(4, actSequenc);
                                    pstmt.execute();
                                    pstmt.close();
                                    pstmt = null;
                                }
                                ++nextPos;
                            }
                            rs.close();
                        }
                        rs = null;
                        pstmt1.close();
                        pstmt1 = null;
                        pstmt = conn.prepareStatement("update " + tableName + " set " + ao.getDataBaseObjectName() + "=" + count + " where id = ?");
                        pstmt.setLong(1, id);
                        pstmt.executeUpdate();
                        this.removeAttributeInternal(bean.getAttributeName(), co.getId());
                        pstmt.close();
                        pstmt = null;
                        continue;
                    }
                    ExceptionUtils.handleException("removeArrayElement, Attribute is not an Array", "agorum.roi.remote.exception.AttributeIsNotAnArray", 75);
                }
            }
            finally {
                try {
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception exception) {}
                try {
                    rs.close();
                    rs = null;
                }
                catch (Exception exception) {}
                try {
                    pstmt1.close();
                    pstmt1 = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxSequenceFromArray(SessionController sessionController, DatabaseInterface dbi, String tableName, Connection conn, long id, long attributeId) throws Exception {
        Statement pstmt = null;
        ResultSet rs = null;
        long iMaxSequence = -1L;
        try {
            pstmt = conn.prepareStatement("select max(" + dbi.getAVSequenceDatabaseName() + ") from " + tableName + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=?");
            pstmt.setLong(1, id);
            pstmt.setLong(2, attributeId);
            rs = pstmt.executeQuery();
            if (rs != null && rs.next()) {
                iMaxSequence = rs.getLong(1);
            }
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
        return iMaxSequence;
    }

    public synchronized void update(SessionController sessionController, SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition definition) throws RemoteException, Exception {
        this.checkIsActivated(sessionController);
        this.definition = definition;
        this.dirty = true;
        this.ejbStore(sessionController, clientBean);
    }

    public synchronized Hashtable getAttributes(SessionController sessionController) throws RemoteException, Exception {
        this.checkIsActivated(sessionController);
        return this.attributes;
    }

    public synchronized long getLastUpdateCounter() throws RemoteException, Exception {
        return this.lastUpdateCounter;
    }

    public synchronized SuperObjectClientBean getClientBean(SessionController sessionController, SuperObjectEntityRemote remote, DbPrimaryKey pk) throws RemoteException, Exception {
        return this.createClientBean(sessionController, remote, pk);
    }

    private SuperObjectClientBean createClientBean(SessionController sessionController, SuperObjectEntityRemote remote, DbPrimaryKey pk) throws RemoteException, Exception {
        try {
            Long myClassId;
            if (this.logEnabled) {
                this.doLog("SuperObjectEntity: " + this.id + ", createClientBean: " + this.classId);
            }
            if ((myClassId = pk.getClassId()) == null) {
                myClassId = this.getClassId(sessionController);
            } else if (this.classId == null) {
                this.classId = myClassId;
            }
            ClassObjectClientBean co = sessionController.getClassObject(myClassId);
            String myClassName = co.getName();
            pk.setClassName(myClassName);
            String jndiNameEJB = "";
            Class classObjectEJBHome = null;
            Class classObjectClientBean = null;
            if (myClassId == 9L) {
                jndiNameEJB = "ejb/ClassObject";
                classObjectEJBHome = ClassObjectHome.class;
                classObjectClientBean = ClassObjectClientBean.class;
            } else {
                jndiNameEJB = "ejb/" + co.getAttribute(ClassObjectClientBean.JNDINAMEEJB_ATTRIBUTE).getString();
                classObjectEJBHome = ClassHolder.getClassInstance(co.getAttribute(ClassObjectClientBean.EJBHOMECLASS_ATTRIBUTE).getString());
                classObjectClientBean = ClassHolder.getClassInstance(co.getAttribute(ClassObjectClientBean.CLIENTBEANCLASS_ATTRIBUTE).getString());
            }
            Object objref = EJBHomeHolder.getHome(jndiNameEJB);
            EJBHome homeEJB = (EJBHome)PortableRemoteObject.narrow((Object)objref, classObjectEJBHome);
            SuperObjectRemote remoteEJB = this.getRemoteEJBObject(sessionController, homeEJB);
            SuperObjectClientBean clientBean = null;
            clientBean = (SuperObjectClientBean)classObjectClientBean.newInstance();
            clientBean.init(remoteEJB, remote, sessionController, pk.id);
            clientBean.setClassName(myClassName);
            clientBean.setJndiNameEJB(jndiNameEJB);
            clientBean.setClassObjectEJB(classObjectClientBean);
            clientBean.setClassObjectEJBHome(classObjectEJBHome);
            clientBean.setAttributes(this.getAttributes(sessionController));
            SuperObjectClientCachedBean cachedBean = SuperObjectClientCachedBean.getCachedBean(clientBean.getId());
            if (cachedBean == null || !cachedBean.isTransacted()) {
                SuperObjectClientCachedBean.setCachedBeanTransacted(clientBean);
            }
            return clientBean;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    private SuperObjectRemote getRemoteEJBObject(SessionController sessionController, EJBHome home) throws RemoteException, Exception {
        SuperObjectRemote remote = null;
        try {
            Method dynMethodSetS = home.getClass().getMethod("create", new Class[0]);
            Object obj = dynMethodSetS.invoke((Object)home, new Object[0]);
            remote = (SuperObjectRemote)obj;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return remote;
    }

    public void doLog(String msg) {
        stat.debug(msg);
        if (this.logEnabled) {
            System.out.println("Entity, " + Thread.currentThread().getName() + ": " + msg);
        }
    }

    private int setAttributeStatement(AttributeValueDBUtils attributeValueDBUtils, Hashtable effAttributes, SessionController sessionController, PreparedStatement ps, int i, AttributeValue av, String attrName, Long id, Connection conn, ClassObjectClientBean co) throws Exception {
        AttributeObjectClientBean attrObj = (AttributeObjectClientBean)effAttributes.get(attrName.toUpperCase());
        if (attributeValueDBUtils.setAttributeValueToStatment(sessionController, ps, i, av)) {
            this.updateAttributeArray(sessionController, av, attrName, id, conn, attributeValueDBUtils, co);
        }
        ++i;
        if (attrObj != null && attrObj.getDataTypeInt() == 23) {
            String value = av.getString();
            if (value != null) {
                value = value.replace('\u0000', ' ').toLowerCase(Locale.ROOT);
            }
            ps.setString(i, value);
            ++i;
        }
        return i;
    }
}

