/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.beans;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.RoiFileSystemInfoBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.FolderObjectSessionFacade;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class RoiFileSystemEJB
implements SessionBean {
    protected SessionContext context = null;

    public void ejbCreate() {
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext sc) {
        this.context = sc;
    }

    public FolderObjectClientBean createFullpath(SessionController sessionController, String fullPath, FolderObjectClientBean rootFolder, AccessControlListObjectClientBean acl, boolean leaveOwner) throws RemoteException, Exception {
        if (fullPath.equals("/")) {
            return sessionController.getRootFolder();
        }
        if (fullPath.toLowerCase().startsWith("${user_home}")) {
            rootFolder = SessionController.getHomeFolder(sessionController.getLoginUser());
            fullPath = fullPath.substring("${user_home}".length());
        }
        StringTokenizer st = new StringTokenizer(fullPath, "/");
        if (rootFolder == null) {
            rootFolder = sessionController.getRootFolder();
        }
        FolderObjectClientBean cbRet = this.findOrCreateGlobalObjectByPathRecursive(sessionController, st, rootFolder, acl, false, leaveOwner);
        return cbRet;
    }

    private FolderObjectClientBean findOrCreateGlobalObjectByPathRecursive(SessionController sessionController, StringTokenizer st, FolderObjectClientBean folder, AccessControlListObjectClientBean acl, boolean create, boolean leaveOwner) throws RemoteException, Exception {
        String name = st.nextElement().toString();
        FolderObjectClientBean item = null;
        if (!create) {
            item = (FolderObjectClientBean)folder.getItem(name);
        }
        if (item == null) {
            create = true;
            FolderObjectSessionFacade folderSessionFacade = new FolderObjectSessionFacade(sessionController);
            folderSessionFacade.setClassnameFromDestinationFolder(true);
            folderSessionFacade.setDestinationFolder(folder);
            folderSessionFacade.setWithTransaction(true);
            folderSessionFacade.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, name);
            if (name.indexOf("$$ID$$") >= 0) {
                folderSessionFacade.setNameWithId(true);
            }
            if (leaveOwner) {
                folderSessionFacade.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, folder.getOwner());
            }
            if (acl != null) {
                folderSessionFacade.setAccessControlList(acl);
            }
            item = (FolderObjectClientBean)folderSessionFacade.create();
        }
        FolderObjectClientBean itemRet = item;
        if (st.hasMoreElements()) {
            FolderObjectClientBean nextFolder = item;
            itemRet = this.findOrCreateGlobalObjectByPathRecursive(sessionController, st, nextFolder, acl, create, leaveOwner);
        }
        return itemRet;
    }

    public boolean isFolderInTheSamePath(SessionController sessionController, FolderObjectClientBean sourceFolder, FolderObjectClientBean destinationFolder) throws RemoteException, Exception {
        if (sourceFolder != null && destinationFolder != null) {
            if (sourceFolder.getId().longValue() != destinationFolder.getId().longValue()) {
                return this.isFolderInTheSamePathRecursiv(sessionController, sessionController.getRootFolder().getId(), sourceFolder.getId(), destinationFolder, false);
            }
            return true;
        }
        return false;
    }

    private boolean isFolderInTheSamePathRecursiv(SessionController sessionController, long rootId, long sourceId, FolderObjectClientBean destinationFolder, boolean isInTheSamePath) throws RemoteException, Exception {
        FolderObjectClientBean[] parents = destinationFolder.getParents();
        if (parents != null && !isInTheSamePath) {
            int len = parents.length;
            for (int i = 0; i < len && !isInTheSamePath; ++i) {
                long parentId;
                if (parents[i] == null || (parentId = parents[i].getId().longValue()) == rootId) continue;
                if (sourceId != parentId) {
                    isInTheSamePath = this.isFolderInTheSamePathRecursiv(sessionController, rootId, sourceId, parents[i], isInTheSamePath);
                    continue;
                }
                isInTheSamePath = true;
                break;
            }
        }
        return isInTheSamePath;
    }

    public RoiFileSystemInfoBean getFileSystemInfoOLD(SessionController sessionController, GlobalObjectClientBean startObject, int depth) throws RemoteException, Exception {
        long t1 = System.currentTimeMillis();
        RoiFileSystemInfoBean roiFileSystemInfoBean = new RoiFileSystemInfoBean();
        if (startObject != null) {
            roiFileSystemInfoBean.setFullpath(startObject.getAnyFolderPath());
            this.getFileSystemInfoRecursivOLD(sessionController, startObject, depth, roiFileSystemInfoBean, 0, "");
        }
        long t2 = System.currentTimeMillis();
        roiFileSystemInfoBean.setInfoTime(t2 - t1);
        return roiFileSystemInfoBean;
    }

    private void getFileSystemInfoRecursivOLD(SessionController sessionController, GlobalObjectClientBean object, int depth, RoiFileSystemInfoBean roiFileSystemInfoBean, int actDepth, String relPath) throws RemoteException, Exception {
        if (depth == 0 || depth > actDepth) {
            if (roiFileSystemInfoBean.getMaxDepth() < actDepth) {
                roiFileSystemInfoBean.setMaxDepth(actDepth);
                roiFileSystemInfoBean.setMaxDepthPath(relPath);
            }
            if (object instanceof FolderObjectClientBean) {
                roiFileSystemInfoBean.setFolderCount(roiFileSystemInfoBean.getFolderCount() + 1L);
                GlobalObjectClientBean[] items = ((FolderObjectClientBean)object).getItems();
                if (items != null) {
                    int len = items.length;
                    for (int i = 0; i < len; ++i) {
                        this.getFileSystemInfoRecursivOLD(sessionController, items[i], depth, roiFileSystemInfoBean, actDepth + 1, relPath + (relPath.length() == 0 ? "" : "/") + object.getName());
                    }
                }
            } else if (object instanceof ContentInterface) {
                roiFileSystemInfoBean.setFileCount(roiFileSystemInfoBean.getFileCount() + 1L);
                ContentInterface ci = (ContentInterface)((Object)object);
                roiFileSystemInfoBean.setFileSize(roiFileSystemInfoBean.getFileSize() + ci.getContentSize());
            } else {
                roiFileSystemInfoBean.setOtherObjectCount(roiFileSystemInfoBean.getOtherObjectCount() + 1L);
            }
        }
    }

    public RoiFileSystemInfoBean getFileSystemInfo(SessionController sessionController, GlobalObjectClientBean startObject, int depth) throws RemoteException, Exception {
        long t1 = System.currentTimeMillis();
        RoiFileSystemInfoBean roiFileSystemInfoBean = new RoiFileSystemInfoBean();
        if (startObject != null) {
            try {
                roiFileSystemInfoBean.setFullpath(startObject.getAnyFolderPath());
            }
            catch (Exception e) {
                roiFileSystemInfoBean.setFullpath("");
            }
            this.getFileSystemInfoRecursiv(sessionController, startObject.getId(), depth, roiFileSystemInfoBean, 0, "");
        }
        long t2 = System.currentTimeMillis();
        roiFileSystemInfoBean.setInfoTime(t2 - t1);
        return roiFileSystemInfoBean;
    }

    private void getFileSystemInfoRecursiv(SessionController sessionController, Long objectId, int depth, RoiFileSystemInfoBean roiFileSystemInfoBean, int actDepth, String relPath) throws RemoteException, Exception {
        if (depth == 0 || depth > actDepth) {
            if (roiFileSystemInfoBean.getMaxDepth() < actDepth) {
                roiFileSystemInfoBean.setMaxDepth(actDepth);
                roiFileSystemInfoBean.setMaxDepthPath(relPath);
            }
            GlobalObjectClientBean object = null;
            try {
                object = sessionController.getGlobalObjectById(objectId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null) {
                if (object instanceof ContentInterface) {
                    roiFileSystemInfoBean.setFileCount(roiFileSystemInfoBean.getFileCount() + 1L);
                    ContentInterface ci = (ContentInterface)((Object)object);
                    roiFileSystemInfoBean.setFileSize(roiFileSystemInfoBean.getFileSize() + ci.getContentSize());
                } else if (object instanceof FolderObjectClientBean) {
                    roiFileSystemInfoBean.setFolderCount(roiFileSystemInfoBean.getFolderCount() + 1L);
                    GlobalObjectClientBean[] items = ((FolderObjectClientBean)object).getItems();
                    object = null;
                    if (items != null) {
                        String name;
                        Long id;
                        int i;
                        System.err.println("\nFileSystemInfo (Depth: " + actDepth + ") : Memory Free/total =" + Runtime.getRuntime().freeMemory() / 1024L + "/" + Runtime.getRuntime().totalMemory() / 1024L + "\nFolders : " + roiFileSystemInfoBean.getFolderCount() + "\nFiles   : " + roiFileSystemInfoBean.getFileCount() + "\nOthers  : " + roiFileSystemInfoBean.getOtherObjectCount());
                        int len = items.length;
                        Vector<Long> vIds = new Vector<Long>();
                        Vector<String> vName = new Vector<String>();
                        for (i = 0; i < len; ++i) {
                            id = null;
                            name = null;
                            try {
                                id = items[i].getId();
                                name = items[i].getName();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (id == null || name == null) continue;
                            if (items[i] instanceof FolderObjectClientBean) {
                                vIds.addElement(id);
                                vName.addElement(name);
                                continue;
                            }
                            this.getFileSystemInfoNoFolder(sessionController, items[i], depth, roiFileSystemInfoBean, actDepth + 1, relPath + (relPath.length() == 0 ? "" : "/") + name);
                        }
                        items = null;
                        len = vIds.size();
                        for (i = 0; i < len; ++i) {
                            id = (Long)vIds.get(0);
                            name = (String)vName.get(0);
                            vIds.remove(0);
                            vName.remove(0);
                            this.getFileSystemInfoRecursiv(sessionController, id, depth, roiFileSystemInfoBean, actDepth + 1, relPath + (relPath.length() == 0 ? "" : "/") + name);
                        }
                    }
                } else {
                    roiFileSystemInfoBean.setOtherObjectCount(roiFileSystemInfoBean.getOtherObjectCount() + 1L);
                }
            }
        }
    }

    private void getFileSystemInfoNoFolder(SessionController sessionController, GlobalObjectClientBean object, int depth, RoiFileSystemInfoBean roiFileSystemInfoBean, int actDepth, String relPath) throws RemoteException, Exception {
        if (depth == 0 || depth > actDepth) {
            if (roiFileSystemInfoBean.getMaxDepth() < actDepth) {
                roiFileSystemInfoBean.setMaxDepth(actDepth);
                roiFileSystemInfoBean.setMaxDepthPath(relPath);
            }
            if (object != null) {
                if (object instanceof ContentInterface) {
                    roiFileSystemInfoBean.setFileCount(roiFileSystemInfoBean.getFileCount() + 1L);
                    ContentInterface ci = (ContentInterface)((Object)object);
                    roiFileSystemInfoBean.setFileSize(roiFileSystemInfoBean.getFileSize() + ci.getContentSize());
                } else {
                    roiFileSystemInfoBean.setOtherObjectCount(roiFileSystemInfoBean.getOtherObjectCount() + 1L);
                }
            }
        }
    }
}

