/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.beans;

import agorum.commons.rsakeys.RSAKeysUtils;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.CryptKeyAuthInterface;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CryptKeyEJB
implements SessionBean {
    protected SessionContext context = null;

    public void ejbCreate() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.context = sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPublicKey(String ident, SessionController sessionController) throws Exception {
        byte[] publicKey;
        block41: {
            publicKey = null;
            ConnectionUtils cu = null;
            try {
                cu = new ConnectionUtils(sessionController);
                try (Connection conn = cu.getConnection();){
                    DatabaseUtils dbu = new DatabaseUtils();
                    DatabaseInterface dbi = dbu.getDatabaseInterfaceImpl();
                    String selectStmt = dbi.getCryptKeyStatementSelectPublicKey();
                    try (PreparedStatement pstmt = conn.prepareStatement(selectStmt);){
                        pstmt.setString(1, ident);
                        try (ResultSet rs = pstmt.executeQuery();){
                            if (!rs.next()) break block41;
                            byte[] buffer = dbi.getBlob(rs);
                            try (ByteArrayInputStream bais = new ByteArrayInputStream(buffer);){
                                publicKey = new BASE64Decoder().decodeBuffer((InputStream)bais);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return publicKey;
    }

    private byte[] getPrivateKey(String ident, SessionController sessionController) throws Exception {
        byte[] privateKey = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            try (Connection conn = cu.getConnection();){
                DatabaseUtils dbu = new DatabaseUtils();
                DatabaseInterface dbi = dbu.getDatabaseInterfaceImpl();
                String selectStmt = dbi.getCryptKeyStatementSelectPrivatKey();
                try (PreparedStatement pstmt = conn.prepareStatement(selectStmt);){
                    pstmt.setString(1, ident);
                    try (ResultSet rs = pstmt.executeQuery();){
                        rs.next();
                        byte[] buffer = dbi.getBlob(rs);
                        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                        privateKey = new BASE64Decoder().decodeBuffer((InputStream)bais);
                        bais.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return privateKey;
    }

    public void createCryptKeyPair(String ident, CryptKeyAuthInterface caller, boolean overwriteKeys, SessionController sessionController) throws Exception {
        if (this.checkAccess(ident, caller, sessionController)) {
            boolean generateKeys = true;
            if (this.getPublicKey(ident, sessionController) != null) {
                if (overwriteKeys) {
                    this.deleteCryptKeyPair(ident, caller, sessionController);
                } else {
                    generateKeys = false;
                }
            }
            if (generateKeys) {
                RSAKeysUtils keyUtils = new RSAKeysUtils();
                keyUtils.generateKeys();
                ConnectionUtils cu = null;
                try {
                    byte[] privKeyBytes = new BASE64Encoder().encode(keyUtils.getPrivateKey()).getBytes();
                    ByteArrayInputStream privKeyIS = new ByteArrayInputStream(privKeyBytes, 0, privKeyBytes.length);
                    byte[] pubKeyBytes = new BASE64Encoder().encode(keyUtils.getPublicKey()).getBytes();
                    ByteArrayInputStream pubKeyIS = new ByteArrayInputStream(pubKeyBytes, 0, pubKeyBytes.length);
                    cu = new ConnectionUtils(sessionController);
                    try (Connection conn = cu.getConnection();){
                        DatabaseUtils dbu = new DatabaseUtils();
                        DatabaseInterface dbi = dbu.getDatabaseInterfaceImpl();
                        String insertStmt = dbi.getCryptKeyStatementInsertKeys();
                        try (PreparedStatement pstmt = conn.prepareStatement(insertStmt);){
                            pstmt.setString(1, ident);
                            pstmt.setBinaryStream(2, (InputStream)pubKeyIS, pubKeyBytes.length);
                            pstmt.setBinaryStream(3, (InputStream)privKeyIS, privKeyBytes.length);
                            pstmt.execute();
                        }
                    }
                    pubKeyIS.close();
                    privKeyIS.close();
                }
                catch (Exception e) {
                    ExceptionUtils.handleException(e);
                }
            }
        } else {
            ExceptionUtils.handleException("No access to create a pair of keys", "agorum.roi.remote.exception.NoAccess", 21);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCryptKeyPair(String ident, CryptKeyAuthInterface caller, SessionController sessionController) throws Exception {
        if (this.checkAccess(ident, caller, sessionController)) {
            Connection conn = null;
            ConnectionUtils cu = null;
            Statement pstmt = null;
            try {
                cu = new ConnectionUtils(sessionController);
                conn = cu.getConnection();
                DatabaseUtils dbu = new DatabaseUtils();
                DatabaseInterface dbi = dbu.getDatabaseInterfaceImpl();
                String insertStmt = dbi.getCryptKeyStatementDeleteKeys();
                pstmt = conn.prepareStatement(insertStmt);
                pstmt.setString(1, ident);
                pstmt.execute();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
            finally {
                try {
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception exception) {}
                try {
                    cu.closeConnection();
                }
                catch (Exception exception) {}
            }
        } else {
            ExceptionUtils.handleException("No access to delete a pair of keys", "agorum.roi.remote.exception.NoAccess", 21);
        }
    }

    public void registerClass(String registerIdent, String registerClassName, String ident, CryptKeyAuthInterface caller, SessionController sessionController) throws Exception {
        if (this.checkAccess(ident, caller, sessionController)) {
            ConnectionUtils cu = null;
            try {
                cu = new ConnectionUtils(sessionController);
                try (Connection conn = cu.getConnection();){
                    DatabaseUtils dbu = new DatabaseUtils();
                    DatabaseInterface dbi = dbu.getDatabaseInterfaceImpl();
                    String selectStmt = dbi.getCryptKeyClassesStatementEntryExists();
                    try (PreparedStatement pstmt = conn.prepareStatement(selectStmt);){
                        pstmt.setString(1, registerIdent);
                        pstmt.setString(2, registerClassName);
                        try (ResultSet rs = pstmt.executeQuery();){
                            if (rs.next()) {
                                throw new Exception("Entry already exists in table!");
                            }
                            String insertStmt = dbi.getCryptKeyClassesStatementRegisterClass();
                            try (PreparedStatement pstmt2 = conn.prepareStatement(insertStmt);){
                                pstmt2.setString(1, registerIdent);
                                pstmt2.setString(2, registerClassName);
                                pstmt2.execute();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                ExceptionUtils.handleException(e);
            }
        } else {
            ExceptionUtils.handleException("No access to register a class for the crypt functions!", "agorum.roi.remote.exception.NoAccess", 21);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClass(String unregisterIdent, String unregisterClassName, String ident, CryptKeyAuthInterface caller, SessionController sessionController) throws Exception {
        if (this.checkAccess(ident, caller, sessionController)) {
            Connection conn = null;
            ConnectionUtils cu = null;
            Statement pstmt = null;
            try {
                cu = new ConnectionUtils(sessionController);
                conn = cu.getConnection();
                DatabaseUtils dbu = new DatabaseUtils();
                DatabaseInterface dbi = dbu.getDatabaseInterfaceImpl();
                String insertStmt = dbi.getCryptKeyClassesStatementUnregisterClass();
                pstmt = conn.prepareStatement(insertStmt);
                pstmt.setString(1, unregisterIdent);
                pstmt.setString(2, unregisterClassName);
                pstmt.execute();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
            finally {
                try {
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception exception) {}
                try {
                    cu.closeConnection();
                }
                catch (Exception exception) {}
            }
        } else {
            ExceptionUtils.handleException("No access to unregister a class for the crypt functions!", "agorum.roi.remote.exception.NoAccess", 21);
        }
    }

    public String decrypt(String encryptedStr, String ident, SessionController sessionController) throws Exception {
        if (encryptedStr != null && encryptedStr.length() > 0) {
            byte[] privateKey = this.getPrivateKey(ident, sessionController);
            RSAKeysUtils keyUtils = new RSAKeysUtils();
            keyUtils.setPrivateKey(privateKey);
            return keyUtils.decodeString(encryptedStr);
        }
        return "";
    }

    @Deprecated
    public String unencrypt(String encryptedStr, String ident, CryptKeyAuthInterface caller, SessionController sessionController) throws Exception {
        if (this.checkAccess(ident, caller, sessionController)) {
            return this.decrypt(encryptedStr, ident, sessionController);
        }
        ExceptionUtils.handleException("No access to unencrypt a string!", "agorum.roi.remote.exception.NoAccess", 21);
        return null;
    }

    public String encrypt(String unencryptedStr, String ident, SessionController sessionController) throws Exception {
        if (unencryptedStr != null && unencryptedStr.length() > 0) {
            byte[] publicKey = this.getPublicKey(ident, sessionController);
            RSAKeysUtils keyUtils = new RSAKeysUtils();
            keyUtils.setPublicKey(publicKey);
            return keyUtils.encodeString(unencryptedStr);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkAccess(String ident, CryptKeyAuthInterface caller, SessionController sessionController) throws Exception {
        if (!caller.isPrivilegedForCrypting()) return false;
        String className = caller.getClass().getName();
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            try (Connection conn = cu.getConnection();){
                DatabaseUtils dbu = new DatabaseUtils();
                DatabaseInterface dbi = dbu.getDatabaseInterfaceImpl();
                String insertStmt = dbi.getCryptKeyClassesStatementSelectClass();
                try (PreparedStatement pstmt = conn.prepareStatement(insertStmt);){
                    pstmt.setString(1, ident);
                    try (ResultSet rs = pstmt.executeQuery();){
                        while (rs.next()) {
                            String classNameFromDB = rs.getString(1);
                            if (!className.equals(classNameFromDB)) continue;
                            boolean bl = true;
                            return bl;
                        }
                        if (!sessionController.isAdminEnabled()) return false;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return false;
    }
}

