/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.cron;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cron.CronBaseTask;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.cron.RoiCronTaskInterface;
import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.common.MetaDbUtils;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.statistic.timephasedactions.TimePhasedActionStatistic;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class RoiCronTask
extends CronBaseTask {
    private static final SystemStatistic stat = CoreStatistic.getInstance();
    public static final Set<String> runningJobs = new HashSet<String>();
    private static SessionController sessionController;
    private final String settingName;
    private final String factory;

    public RoiCronTask(String settingName, String factory) {
        this.factory = factory;
        this.settingName = settingName;
    }

    private static synchronized void connect() throws Exception {
        if (sessionController == null) {
            System.err.println("Not connected, so reconnect...");
            try {
                CredentialObject credential = new CredentialObject();
                credential.setUserName(new RoiProperties().getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo("RoiCronTask");
                sessionController = SessionController.connect(credential).noExpiration();
            }
            catch (Exception e) {
                sessionController = null;
            }
        } else {
            sessionController.reconnectIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask() {
        boolean iAmRunning = false;
        try {
            Set<String> set = runningJobs;
            synchronized (set) {
                block32: {
                    if (!runningJobs.contains(this.settingName)) break block32;
                    TimePhasedActionStatistic.getInstance().info().send("CronJob: " + this.settingName + " is already running...");
                    return;
                }
                TimePhasedActionStatistic.getInstance().info().send("CronJob: " + this.settingName + " is starting...");
                iAmRunning = true;
                runningJobs.add(this.settingName);
            }
            Class<?> c = Class.forName(this.factory);
            RoiCronTaskInterface fact = (RoiCronTaskInterface)c.newInstance();
            RoiCronTask.connect();
            MetaDb metaDb = sessionController.getMetaDbInstance();
            Hashtable parameters = metaDb.getParameterHash("MAIN_MODULE_MANAGEMENT/cronjob/control/" + this.settingName, true);
            Map clonedParameters = null;
            if (parameters != null) {
                clonedParameters = (Map)parameters.clone();
            }
            try {
                fact.runCronJob(sessionController, this.settingName, parameters);
            }
            finally {
                if (!IndexHelper.autoCommitEnabled) {
                    IndexHelper.commit();
                }
            }
            if (parameters != null && clonedParameters != null) {
                boolean changed = false;
                if (parameters.size() != clonedParameters.size()) {
                    changed = true;
                }
                for (String key : parameters.keySet()) {
                    String value = (String)parameters.get(key);
                    String value2 = (String)clonedParameters.get(key);
                    if (!(value2 == null && value != null || value == null && value2 != null) && value.equals(value2)) continue;
                    changed = true;
                    break;
                }
                if (changed) {
                    SessionController sessionController2 = SessionControllerAdmin.getSessionControllerAdmin("RoiCronTask_AuditStatus");
                    sessionController2.setAuditState(AuditUtil.ACTION_EXT_NOT_ENTRY);
                    MetaDbUtils metaDbUtils = new MetaDbUtils(sessionController2);
                    metaDbUtils.setParameterHash(parameters, "MAIN_MODULE_MANAGEMENT/cronjob/control/" + this.settingName);
                }
            }
        }
        catch (Throwable e) {
            TimePhasedActionStatistic.getInstance().error().exception(e).send("Error running CronJob: " + this.settingName);
        }
        finally {
            Set<String> set = runningJobs;
            synchronized (set) {
                if (iAmRunning) {
                    TimePhasedActionStatistic.getInstance().info().send("CronJob: " + this.settingName + " is finished");
                    runningJobs.remove(this.settingName);
                }
            }
        }
    }
}

