/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.cron;

import agorum.commons.string.SerializableMap;
import agorum.commons.zip.ZipUtils;
import agorum.roi.cron.RoiCronTaskInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.common.MetaDbAccessor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class LogFileCleanupService
implements RoiCronTaskInterface {
    public static final String BASE_KEY = "MAIN_MODULE_MANAGEMENT/cronjob/control/LogFileCleanupService";
    public static final int DAYS_BEFORE_ARCHIVE = 7;
    public static final int DAYS_BEFORE_DELETE = 14;

    public void runCronJob(SessionController sessionController, String settingName, Hashtable parameters) throws Exception {
        try {
            MetaDbAccessor mdba = new MetaDbAccessor("agorum.roi.cron.LogFileCleanupService");
            SerializableMap map = mdba.getValues(BASE_KEY);
            boolean enabled = map.getBoolean("Enabled");
            int daysBeforeArchive = map.getInteger("DaysBeforeArchive", Integer.valueOf(7));
            int daysBeforeDelete = map.getInteger("DaysBeforeDelete", Integer.valueOf(14));
            if (enabled) {
                LocalDate today = LocalDate.now();
                long archTime = today.minusDays(daysBeforeArchive).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
                long delTime = today.minusDays(daysBeforeDelete).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
                long maxArchTime = Long.MIN_VALUE;
                long minArchTime = Long.MAX_VALUE;
                File logDir = new File(System.getProperty("jboss.server.home.dir") + "/log");
                ArrayList<Object> logFilesToDelete = new ArrayList<Object>();
                ArrayList<Object> logFilesToArchive = new ArrayList<Object>();
                File[] logFiles = logDir.listFiles();
                if (logFiles != null) {
                    for (File logFile : logFiles) {
                        BasicFileAttributes attr = Files.readAttributes(logFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                        if (attr.isDirectory()) continue;
                        LocalDate ldt = attr.lastModifiedTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        long l = ldt.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
                        if (l <= delTime) {
                            logFilesToDelete.add(logFile);
                            continue;
                        }
                        if (l > archTime || logFile.getName().contains(".zip")) continue;
                        logFilesToArchive.add(logFile);
                        if (maxArchTime < l) {
                            maxArchTime = l;
                        }
                        if (minArchTime <= l) continue;
                        minArchTime = l;
                    }
                }
                if (logFilesToArchive.size() > 0) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String string = logDir.getPath() + "/server-" + sdf.format(new Date(maxArchTime)) + "-" + sdf.format(new Date(minArchTime));
                    File zipFile = new File(string + ".zip");
                    int c = 2;
                    while (zipFile.exists()) {
                        zipFile = new File(string + " (" + c + ").zip");
                        ++c;
                    }
                    ZipUtils.zipFiles(logFilesToArchive, (File)zipFile);
                    BasicFileAttributeView bfav = Files.getFileAttributeView(zipFile.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
                    FileTime time = FileTime.fromMillis(maxArchTime);
                    bfav.setTimes(time, time, time);
                    for (File file : logFilesToArchive) {
                        file.delete();
                    }
                }
                if (logFilesToDelete.size() > 0) {
                    for (File file : logFilesToDelete) {
                        if (!file.exists()) continue;
                        file.delete();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

