/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import agorum.roi.test.RoiTest;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class RoiZipUtils {
    public FileObjectClientBean compressFiles(SessionController sessionController, FolderObjectClientBean folder, FolderObjectClientBean toFolder, String zipName) throws Exception {
        FileObjectSessionFacade fosf = new FileObjectSessionFacade(sessionController);
        fosf.setDestinationFolder(toFolder);
        fosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, zipName);
        FileObjectClientBean focb = (FileObjectClientBean)fosf.create();
        return this.compressFiles(sessionController, folder, focb);
    }

    public FileObjectClientBean compressFiles(SessionController sessionController, FolderObjectClientBean folder, FileObjectClientBean toFile) throws Exception {
        ZipOutputStream out = new ZipOutputStream(toFile.getContentOutputStream());
        this.compressFiles(out, folder, "");
        out.close();
        return toFile;
    }

    private void compressFiles(ZipOutputStream out, FolderObjectClientBean dir, String dirName) throws Exception {
        GlobalObjectClientBean[] subDir = dir.getItems();
        byte[] buf = new byte[1024];
        if (subDir != null) {
            int len = subDir.length;
            for (int i = 0; i < len; ++i) {
                int len1;
                String trenn = "";
                if (dirName.length() > 0) {
                    trenn = "/";
                }
                String newDirName = dirName + trenn + subDir[i].getName();
                if (subDir[i].getIsFolder()) {
                    this.compressFiles(out, (FolderObjectClientBean)subDir[i], newDirName);
                    continue;
                }
                System.err.println("compressing: " + newDirName);
                byte flag = 0;
                InputStream in = ((FileObjectClientBean)subDir[i]).getContentStream();
                ZipEntry z = new ZipEntry(newDirName);
                z.setExtra(new byte[]{flag});
                out.putNextEntry(z);
                while ((len1 = in.read(buf)) > 0) {
                    out.write(buf, 0, len1);
                }
                out.closeEntry();
                in.close();
            }
        }
    }

    public void uncompressFiles(SessionController sessionController, FileObjectClientBean file, FolderObjectClientBean toDir) throws Exception {
        byte[] buf = new byte[1024];
        ZipInputStream in = new ZipInputStream(file.getContentStream());
        this.uncompressFiles(sessionController, in, toDir);
        in.close();
    }

    private void uncompressFiles(SessionController sessionController, ZipInputStream in, FolderObjectClientBean toDir) throws Exception {
        ZipEntry zipEntry = null;
        while ((zipEntry = in.getNextEntry()) != null) {
            int read;
            String path = zipEntry.getName();
            System.err.println("processing: " + path);
            RoiFileSystem rfs = new RoiFileSystem(sessionController);
            String destDir = "";
            String name = null;
            if (path.lastIndexOf("/") != -1) {
                String destParent;
                destDir = destParent = path.substring(0, path.lastIndexOf("/"));
                name = path.substring(path.lastIndexOf("/") + 1);
            } else {
                destDir = "";
                name = path;
            }
            FolderObjectClientBean destFolder = rfs.createFullpath(destDir, toDir, toDir.getAcl());
            byte[] bArr = zipEntry.getExtra();
            int flag = 0;
            if (bArr != null && (flag = bArr[0]) == 1) {
                flag = 2;
            }
            GlobalObjectClientBean gocb = destFolder.getItem(name);
            FileObjectSessionFacade fosf = new FileObjectSessionFacade(sessionController);
            if (gocb != null) {
                fosf.setGlobalObject(gocb);
            }
            fosf.setDestinationFolder(destFolder);
            fosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, name);
            fosf.setAttribute(GlobalObjectClientBean.FLAGS_ATTRIBUTE, new Integer(flag));
            FileObjectClientBean focb = null;
            focb = gocb == null ? (FileObjectClientBean)fosf.create() : (FileObjectClientBean)fosf.update();
            OutputStream os = focb.getContentOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = in.read(buffer)) >= 0) {
                os.write(buffer, 0, read);
            }
            os.close();
        }
    }

    public static void mainOrg(String[] args) {
        RoiTransactionHandler rth = null;
        try {
            RoiProperties rp = new RoiProperties();
            SessionController sessionController = RoiTest.login(rp.getRoiSystemUser(), rp.getRoiSystemPassword());
            rth = new RoiTransactionHandler();
            rth.begin();
            FolderObjectClientBean folder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath("/agorum/roi/Files/d4wdemo");
            FolderObjectClientBean destFolder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath("/agorum/roi/Files/d4wdemo.copy");
            RoiZipUtils zu = new RoiZipUtils();
            FileObjectClientBean toFile = zu.compressFiles(sessionController, folder, destFolder, "dummy1.zip");
            System.err.println("");
            System.err.println("");
            System.err.println("");
            zu.uncompressFiles(sessionController, toFile, destFolder);
            rth.end();
        }
        catch (Exception e) {
            try {
                rth.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace(System.err);
        }
        System.err.println("Finished");
    }

    public static void main(String[] args) {
        RoiTransactionHandler rth = null;
        try {
            RoiProperties rp = new RoiProperties();
            SessionController sessionController = RoiTest.login(rp.getRoiSystemUser(), rp.getRoiSystemPassword());
            rth = new RoiTransactionHandler();
            rth.begin();
            FolderObjectClientBean destFolder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath("/agorum/roi/Files/unpack");
            FileObjectClientBean toFile = (FileObjectClientBean)sessionController.findGlobalObjectByPath("/agorum/roi/Files/d4wdemo/packtest.zip");
            RoiZipUtils zu = new RoiZipUtils();
            zu.uncompressFiles(sessionController, toFile, destFolder);
            rth.end();
        }
        catch (Exception e) {
            try {
                rth.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace(System.err);
        }
        System.err.println("Finished");
    }
}

