/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import java.util.ArrayList;
import java.util.List;

public class PermissionUtil {
    private static final String NO_ACL_INHERITANCE = "NoAclInheritance";

    public static PermissionSettings deactivateAclInheritance() {
        return new PermissionSettings(NO_ACL_INHERITANCE);
    }

    public static boolean isAclInheritanceDeactivated() {
        return PermissionSettings.active(NO_ACL_INHERITANCE);
    }

    public static class PermissionSettings
    implements AutoCloseable {
        private final String key;
        private static final ThreadLocal<List<String>> settings = new ThreadLocal();

        public PermissionSettings(String key) {
            this.key = key;
            List<String> current = settings.get();
            if (current == null) {
                current = new ArrayList<String>();
                settings.set(current);
            }
            current.add(key);
        }

        @Override
        public void close() throws Exception {
            List<String> current = settings.get();
            current.remove(this.key);
            if (current.isEmpty()) {
                settings.remove();
            }
        }

        private static boolean active(String key) {
            List<String> current = settings.get();
            return current != null && current.contains(key);
        }
    }
}

