/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.commons.RewindableInputStream;
import agorum.commons.string.StringConverterUtils;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.parser.common.CreateRoiObjectsFromParseObject;
import agorum.roi.parser.common.RoiXMLParser;
import agorum.roi.scripting.EngineContext;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class Packager {
    public static void unpack(SessionController sessionController, InputStream is, String charset) throws Exception {
        Packager.unpack(null, sessionController, is, charset);
    }

    public static void unpack(Logger out, SessionController sessionController, InputStream is, String charset) throws Exception {
        Packager.unpack(out, sessionController, null, is, charset);
    }

    public static void unpack(Logger out, SessionController sessionController, String parameters, InputStream is, String charset) throws Exception {
        Packager.unpack(out, sessionController, parameters, is, charset, null);
    }

    private static String getProjectPrefix(Map<String, Object> parameters) throws Exception {
        if (parameters == null) {
            throw new Exception("project.yml not present in the zip package");
        }
        String prjPrefix = (String)parameters.get("prefix");
        if (prjPrefix == null) {
            throw new Exception("Project has no project prefix in project.yml, but it is needed to perform the given operation");
        }
        if (!prjPrefix.endsWith("_")) {
            prjPrefix = prjPrefix + "_";
        }
        return prjPrefix;
    }

    public static Map<String, Object> loadMeta(ZipInputStream zis) throws Exception {
        String json = StringConverterUtils.toString((InputStream)zis);
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(Logger out, SessionController sessionController, String extParameters, InputStream is, String charset, List<String> typeFilter) throws Exception {
        FolderObjectClientBean root = sessionController.getRootFolder();
        File fsRoot = new File(new File(System.getProperty("jboss.home.dir")), "..");
        String moduleBase = "jboss/server/default/deploy/roi.ear/roiwebui.war/";
        String messagesBase = "jboss/server/default/deploy/roi.ear/roiwebui.war/WEB-INF/config/messages/";
        try (RewindableInputStream rs = new RewindableInputStream(is);){
            try (PackageInputStream pis = new PackageInputStream((InputStream)rs, Charset.forName("Cp850"));){
                ZipEntry entry;
                while ((entry = pis.getNextEntry()) != null) {
                    if (!entry.getName().contains("meta.json")) continue;
                    Map<String, Object> parameters = Packager.loadMeta(pis);
                    String encodingFromMeta = (String)parameters.get("encoding");
                    if (encodingFromMeta != null && encodingFromMeta.trim().length() > 0) {
                        charset = encodingFromMeta;
                    }
                    break;
                }
            }
            rs.rewind();
            if (charset == null) {
                charset = "Cp850";
            }
            Packager.log(out, "Using encoding: " + charset);
            pis = new PackageInputStream((InputStream)rs, Charset.forName(charset));
            String currentTransaction = "default";
            Map<String, Object> parameters = null;
            try (Transaction t = new Transaction(0);){
                ZipEntry entry;
                while ((entry = pis.getNextEntry()) != null) {
                    if (entry.getName().contains("meta.json")) {
                        parameters = Packager.loadMeta(pis);
                        continue;
                    }
                    String[] parts = entry.getName().split("\\/");
                    String transaction = "default";
                    Type type = null;
                    StringBuilder pathBuilder = new StringBuilder();
                    for (String part : parts) {
                        if (type == null) {
                            if (part.startsWith("trans")) {
                                transaction = part;
                                continue;
                            }
                            type = Type.fromString(part);
                            continue;
                        }
                        pathBuilder.append("/");
                        pathBuilder.append(part);
                    }
                    if (!transaction.equals(currentTransaction)) {
                        Packager.log(out, "# COMMIT: " + currentTransaction + " -> " + transaction);
                        currentTransaction = transaction;
                        t.restart();
                    }
                    if (type == null) {
                        if (!entry.isDirectory() && entry.getName().toLowerCase().endsWith(".zip")) {
                            Packager.log(out, ">> SUB: " + entry.getName());
                            Packager.unpack(out, sessionController, extParameters, pis, null);
                            Packager.log(out, "<< SUB: " + entry.getName());
                            continue;
                        }
                        Packager.log(out, "  SKIP: " + entry.getName());
                        continue;
                    }
                    String path = pathBuilder.toString();
                    if (path.length() <= 0) {
                        Packager.log(out, "  SKIP: " + entry.getName());
                        continue;
                    }
                    String name = null;
                    if (!entry.isDirectory()) {
                        int i = path.lastIndexOf("/");
                        if (i < 0) {
                            Packager.log(out, "  SKIP: " + entry.getName());
                            continue;
                        }
                        name = path.substring(i + 1);
                        path = path.substring(0, i);
                    }
                    Packager.log(out, "+ PROC: " + entry.getName());
                    sessionController.reconnectIfNeeded();
                    if (typeFilter != null && !typeFilter.contains(type.toString().toLowerCase())) {
                        Packager.log(out, "  SKIP: type " + (Object)((Object)type) + " due to filter");
                        continue;
                    }
                    switch (type) {
                        case FS: {
                            if (entry.isDirectory()) {
                                new File(fsRoot, path).mkdirs();
                                break;
                            }
                            File folder = new File(fsRoot, path);
                            folder.mkdirs();
                            Packager.download(folder, name, pis);
                            break;
                        }
                        case CSS: {
                            File folder = new File(fsRoot, moduleBase + Packager.getProjectPrefix(parameters) + "module/css/" + path);
                            folder.mkdirs();
                            if (entry.isDirectory()) break;
                            Packager.download(folder, name, pis);
                            break;
                        }
                        case ICONS: {
                            File folder = new File(fsRoot, moduleBase + Packager.getProjectPrefix(parameters) + "module/icons/" + path);
                            folder.mkdirs();
                            if (entry.isDirectory()) break;
                            Packager.download(folder, name, pis);
                            break;
                        }
                        case IMG: {
                            File folder = new File(fsRoot, moduleBase + Packager.getProjectPrefix(parameters) + "module/img/" + path);
                            folder.mkdirs();
                            if (entry.isDirectory()) break;
                            Packager.download(folder, name, pis);
                            break;
                        }
                        case MESSAGES: {
                            File folder = new File(fsRoot, messagesBase + Packager.getProjectPrefix(parameters) + "module");
                            folder.mkdirs();
                            Packager.download(folder, name, pis);
                            break;
                        }
                        case AC: {
                            if (entry.isDirectory()) {
                                root.createPath(path);
                                break;
                            }
                            Packager.upload(sessionController, root.createPath(path), name, pis);
                            break;
                        }
                        case XML: {
                            Packager.xml(sessionController, root, pis);
                            break;
                        }
                        case JS: {
                            Packager.js(sessionController, extParameters, parameters, root, pis, name);
                        }
                    }
                }
                t.commit();
            }
            finally {
                pis.closePackage();
            }
        }
    }

    private static void log(Logger out, String str) throws IOException {
        if (out == null) {
            System.out.println("Packager: " + str);
            return;
        }
        out.println(str);
    }

    private static FileObjectClientBean upload(SessionController sessionController, FolderObjectClientBean folder, String name, InputStream is) throws Exception {
        FileObjectClientBean existing = (FileObjectClientBean)folder.getItem(name);
        if (existing == null) {
            FileObjectSessionFacade fosf = new FileObjectSessionFacade(sessionController);
            fosf.setWithTransaction(true);
            fosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, name);
            fosf.setDestinationFolder(folder);
            fosf.setContentStream(is);
            return (FileObjectClientBean)fosf.create();
        }
        try (RewindableInputStream a = new RewindableInputStream(is);
             InputStream b = existing.getContentStream();){
            int read;
            int blockSize = (int)existing.getBlockSize();
            byte[] aBuf = new byte[blockSize];
            byte[] bBuf = new byte[blockSize];
            while ((read = a.read(aBuf)) == b.read(bBuf)) {
                if (read <= 0) {
                    FileObjectClientBean fileObjectClientBean = existing;
                    return fileObjectClientBean;
                }
                if (ByteBuffer.wrap(aBuf, 0, read).equals(ByteBuffer.wrap(bBuf, 0, read))) continue;
            }
            a.rewind();
            existing.setContent((InputStream)a);
        }
        return existing;
    }

    private static void download(File folder, String name, InputStream is) throws FileNotFoundException, IOException {
        try (FileOutputStream os = new FileOutputStream(new File(folder, name));){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
        }
    }

    private static Vector xml(SessionController sessionController, FolderObjectClientBean folder, InputStream is) throws Exception {
        RoiXMLParser roiXMLParser = new RoiXMLParser(sessionController);
        roiXMLParser.setDocument(is);
        return new CreateRoiObjectsFromParseObject(sessionController, folder).create(roiXMLParser.parse());
    }

    private static Object js(SessionController sessionController, String extParameters, Map<String, Object> parameters, FolderObjectClientBean folder, InputStream is, String name) throws Exception {
        String js = StringConverterUtils.toString((InputStream)is, (String)"UTF-8");
        EngineContext context = new EngineContext(false, sessionController);
        context.put("extParameters", extParameters);
        context.put("parameters", parameters);
        context.put("folder", folder);
        context.put("sessionController", sessionController);
        context.put("sc", sessionController);
        context.put("sessionControllerAdmin", sessionController);
        context.put("sca", sessionController);
        return context.eval(js, name);
    }

    public static interface Logger {
        public void println(String var1) throws IOException;
    }

    private static enum Type {
        FS("fs"),
        ICONS("icons"),
        IMG("img"),
        CSS("css"),
        MESSAGES("messages"),
        AC("ac"),
        XML("xml"),
        JS("js");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String value) {
            value = value.toLowerCase();
            for (Type type : Type.values()) {
                if (!value.equals(type.value)) continue;
                return type;
            }
            return null;
        }
    }

    private static class PackageInputStream
    extends ZipInputStream {
        public PackageInputStream(InputStream in, Charset charset) {
            super(in, charset);
        }

        @Override
        public void close() throws IOException {
        }

        public void closePackage() throws IOException {
            super.close();
        }
    }
}

