/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.commons.string.StringUtils;
import agorum.roi.common.beans.SenderAddressBean;
import agorum.roi.ejb.client.beans.AppUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.EmailUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MailUtils {
    private final SessionController sessionController;

    public MailUtils(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public ArrayList<SenderAddressBean> getAllSenderAddresses() throws Exception {
        AppUserProfileObjectClientBean aupocb;
        EmailUserProfileObjectClientBean[] emailUser;
        int i;
        int len;
        boolean onlySenderAddresses;
        Hashtable<String, String> senderAddressHash;
        ArrayList<SenderAddressBean> senderAddressList;
        DirectoryUserObjectClientBean user;
        block14: {
            user = this.sessionController.getLoginUser();
            senderAddressList = new ArrayList<SenderAddressBean>();
            senderAddressHash = new Hashtable<String, String>();
            onlySenderAddresses = false;
            try {
                MetaDb metaDb = this.sessionController.getMetaDbInstance();
                Vector groups = metaDb.getAllGroupsOfUser();
                if (groups == null) break block14;
                len = groups.size();
                for (i = 0; i < len; ++i) {
                    String[] senderAddresses = null;
                    String metaDbPath = "MAIN_GROUP_MANAGEMENT/" + groups.get(i) + "/roiwebui/control/mail/";
                    try {
                        String[] osa = metaDb.getSimplePropertyValue(metaDbPath + "OnlySenderAddresses");
                        if (osa != null && osa.length > 0 && osa[0].trim().equalsIgnoreCase("true")) {
                            onlySenderAddresses = true;
                        }
                    }
                    catch (MetaDbException osa) {
                        // empty catch block
                    }
                    try {
                        senderAddresses = metaDb.getSimplePropertyValue(metaDbPath + "SenderAddresses");
                    }
                    catch (MetaDbException osa) {
                        // empty catch block
                    }
                    if (senderAddresses == null) continue;
                    int senderAddrLen = senderAddresses.length;
                    for (int j = 0; j < senderAddrLen; ++j) {
                        if (senderAddressHash.containsKey(senderAddresses[j])) continue;
                        SenderAddressBean sab = new SenderAddressBean();
                        sab.setFromAddress(senderAddresses[j]);
                        senderAddressList.add(sab);
                        senderAddressHash.put(senderAddresses[j], "");
                    }
                }
            }
            catch (MetaDbException e) {
                e.printStackTrace();
            }
        }
        if (!onlySenderAddresses && (emailUser = user.getEmailUserProfiles()) != null) {
            Arrays.sort(emailUser, new Comparator<EmailUserProfileObjectClientBean>(){

                @Override
                public int compare(EmailUserProfileObjectClientBean o1, EmailUserProfileObjectClientBean o2) {
                    int eq = 0;
                    try {
                        eq = o1.getId().compareTo(o2.getId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return eq;
                }
            });
            int len2 = emailUser.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                String mailAddr = emailUser[i2].getEmailAddress();
                if (senderAddressHash.containsKey(mailAddr)) continue;
                SenderAddressBean sab = new SenderAddressBean();
                sab.setFromAddress(mailAddr);
                if (i2 == 0) {
                    sab.setDefaultFromAddress(true);
                }
                senderAddressList.add(sab);
                senderAddressHash.put(mailAddr, "");
            }
        }
        if ((aupocb = user.getApplicationUserProfile("roi", "agorum.roi.SendingEmailAddress")) != null && aupocb.getAppValue() != null) {
            StringTokenizer st = new StringTokenizer(aupocb.getAppValue(), ";");
            len = st.countTokens();
            for (i = 0; i < len; ++i) {
                String mailAddr = st.nextToken().trim();
                if (senderAddressHash.containsKey(mailAddr)) continue;
                SenderAddressBean sab = new SenderAddressBean();
                sab.setFromAddress(mailAddr);
                senderAddressList.add(sab);
                senderAddressHash.put(mailAddr, "");
            }
        }
        return senderAddressList;
    }

    public String getFooterText(DirectoryUserObjectClientBean user, String fromAddress, boolean withReplace) throws Exception {
        String footerName = "MailFooter_" + fromAddress + ".txt";
        String footerText = "";
        FileObjectClientBean footerObject = null;
        try {
            footerObject = (FileObjectClientBean)this.sessionController.findGlobalObjectByPath(user.getPrimaryUserProfile().getHomeFolder(), "MyAdmin/Mail/" + footerName);
            if (footerObject != null) {
                StringUtils su = new StringUtils();
                footerText = "\n" + su.streamToString(footerObject.getContentStream()) + "\n";
                if (withReplace) {
                    footerText = footerText.replaceAll("\n", "\\\\n");
                    footerText = footerText.replaceAll("\r", "\\\\r");
                    footerText = footerText.replaceAll("\"", "\\\\\"");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return footerText;
    }
}

