/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.system.ModuleManagement;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.CustomAclObjectClientBean;
import agorum.roi.ejb.client.beans.CustomAclObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.PermissionBundleObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.VersionObjectClientBean;
import agorum.roi.ejb.common.ClassBasedAuthInterface;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.parser.common.CreateRoiObjectsFromParseObject;
import agorum.roi.parser.common.ParserObject;
import agorum.roi.parser.common.RoiXMLParser;
import agorum.roi.scripting.EngineContext;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class InstallUtil {
    public static final String BASE_KEY_MODULES = "MAIN_MODULE_MANAGEMENT/roi/control/modules";
    public static final String BASE_KEY_PREVIEW = "MAIN_MODULE_MANAGEMENT/preview/control";
    private static final Object versionCheckSync = new Object();

    public void createDBObject(SessionController sessionController, String uniqueName, String pathOffset, String path) throws Exception {
        ClassObjectClientBean cocb = null;
        cocb = sessionController.getClassObject(uniqueName);
        if (cocb == null) {
            this.parseDocument(sessionController, null, pathOffset, path);
        }
    }

    public static boolean isFirstRun() {
        return InstallUtil.firstRunMarker().exists();
    }

    public static void firstRunDone() {
        File marker = InstallUtil.firstRunMarker();
        if (marker.exists()) {
            marker.delete();
        }
    }

    private static File firstRunMarker() {
        return new File(System.getProperty("jboss.server.home.dir") + "/firstRun");
    }

    public static boolean isModuleActive(String metaDbKey) {
        return InstallUtil.isModuleActive(metaDbKey, true);
    }

    public static boolean isModuleActive(String metaDbKey, boolean cached) {
        if (metaDbKey == null || metaDbKey.isEmpty()) {
            return true;
        }
        SessionController sessionController = SessionControllerAdmin.getSessionControllerAdmin(InstallUtil.class.getName());
        String key = "MAIN_MODULE_MANAGEMENT/roi/control/modules/" + metaDbKey + "/Active";
        if (cached) {
            return Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(sessionController, key));
        }
        return sessionController.getMetaDbInstance().getBoolean(key, false);
    }

    public static synchronized void ifModuleActive(String module, Runnable callback) {
        ServiceUtils.whenAutoUpdateFinished(() -> {
            if (InstallUtil.isModuleActive(module)) {
                callback.run();
            }
        });
    }

    public static synchronized void ifModuleNotActive(String module, Runnable callback) {
        ServiceUtils.whenAutoUpdateFinished(() -> {
            if (!InstallUtil.isModuleActive(module)) {
                callback.run();
            }
        });
    }

    public static void setModuleActive(SessionController sessionController, String keyName, boolean enabled) throws Exception {
        block17: {
            block16: {
                MetaDbUtil mdbUtils = new MetaDbUtil(sessionController, BASE_KEY_MODULES);
                Iterator iterator = null;
                try {
                    mdbUtils.setBoolean(keyName + "/Active", enabled);
                    mdbUtils.commit();
                }
                catch (Throwable throwable) {
                    iterator = throwable;
                    throw throwable;
                }
                finally {
                    if (mdbUtils != null) {
                        if (iterator != null) {
                            try {
                                mdbUtils.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)iterator)).addSuppressed(throwable);
                            }
                        } else {
                            mdbUtils.close();
                        }
                    }
                }
                if (!enabled) break block16;
                Set dependencies = ModuleManagement.getDependencies((String)keyName);
                if (dependencies == null) break block17;
                for (String dependency : dependencies) {
                    InstallUtil.setModuleActive(sessionController, dependency, true);
                }
                break block17;
            }
            Set reverseDependencies = ModuleManagement.getReverseDependencies((String)keyName);
            if (reverseDependencies != null) {
                for (String dependency : reverseDependencies) {
                    InstallUtil.setModuleActive(sessionController, dependency, false);
                }
            }
        }
    }

    public void makePAIPublic(SessionController sessionController, String paiName) throws Exception {
    }

    public void parseDocument(SessionController sessionController, String checkObject, String offsetPath, String docPath) throws Exception {
        GlobalObjectClientBean gocb = null;
        if (checkObject != null) {
            gocb = sessionController.findGlobalObjectByPath(checkObject);
        }
        if (gocb == null) {
            String path = offsetPath + docPath;
            System.err.println("Document : " + path);
            RoiXMLParser roiXMLParser = new RoiXMLParser(sessionController);
            roiXMLParser.setDocument(path);
            ParserObject po = roiXMLParser.parse();
            CreateRoiObjectsFromParseObject createRoiObjectsFromParseObject = new CreateRoiObjectsFromParseObject(sessionController);
            createRoiObjectsFromParseObject.create(po);
        }
    }

    public static Object runJS(SessionController sessionController, String script) throws FileNotFoundException, IOException {
        try (FileInputStream stream = new FileInputStream(script);){
            EngineContext context = new EngineContext(false, sessionController);
            context.put("sc", sessionController);
            context.put("sca", sessionController);
            String scriptContent = StringConverterUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            Object object = context.eval(scriptContent);
            return object;
        }
    }

    public SessionController newConnect(String name, String pass) throws Exception {
        return this.newConnect(name, pass, null);
    }

    public SessionController newConnect(String name, String pass, ClassBasedAuthInterface authInt) throws Exception {
        try {
            CredentialObject credential = new CredentialObject();
            credential.setUserName(name);
            credential.setPassWord(pass);
            credential.setModulInfo("InstallUtil");
            credential.setNotSetNtPassword(true);
            credential.setAuthInterface(authInt);
            SessionController sessionController = SessionController.connect(credential);
            return sessionController;
        }
        catch (Exception credential) {
            CredentialObject credential2 = new CredentialObject();
            credential2.setUserName(name);
            credential2.setPassWord(pass);
            credential2.setUseDesEncryption(false);
            credential2.setModulInfo("InstallUtil");
            credential2.setNotSetNtPassword(true);
            credential2.setAuthInterface(authInt);
            return SessionController.connect(credential2);
        }
    }

    public String mapPathToOS(String path) {
        return path.replace('/', File.separatorChar);
    }

    public DirectoryGroupObjectClientBean createGroup(SessionController sessionController, String name, String description) throws Exception {
        DirectoryGroupObjectClientBeanDefinition dgboDef = new DirectoryGroupObjectClientBeanDefinition(sessionController);
        dgboDef.setName(name);
        dgboDef.setDescription(description);
        DirectoryGroupObjectClientBean group = (DirectoryGroupObjectClientBean)sessionController.createGlobalObject(dgboDef);
        return group;
    }

    public CustomAclObjectClientBean createAcl(SessionController sessionController, String name) throws Exception {
        CustomAclObjectClientBeanDefinition aclDef = new CustomAclObjectClientBeanDefinition(sessionController);
        aclDef.setName(name);
        CustomAclObjectClientBean acl = (CustomAclObjectClientBean)sessionController.createGlobalObject(aclDef);
        return acl;
    }

    public AccessControlEntryObjectClientBeanDefinition createAceDefinition(SessionController sessionController, String permissionBundle, DirectoryObjectClientBean grantee, boolean granted) throws Exception {
        AccessControlEntryObjectClientBeanDefinition aceDef = new AccessControlEntryObjectClientBeanDefinition(sessionController);
        PermissionBundleObjectClientBean pb = sessionController.getPermissionBundleByName(permissionBundle);
        aceDef.addPermissionBundle(pb);
        aceDef.setGrantee(grantee);
        aceDef.setGranted(granted);
        return aceDef;
    }

    public void uploadFile(SessionController sessionController, String fromFile, String toFolder) throws Exception {
        File file = new File(fromFile);
        String myFile = toFolder + "/" + file.getName();
        GlobalObjectClientBean bean = sessionController.findGlobalObjectByPath(myFile);
        if (bean == null) {
            FolderObjectClientBean folder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath(toFolder);
            FileObjectSessionFacade fileSF = new FileObjectSessionFacade(sessionController);
            fileSF.setWithTransaction(true);
            fileSF.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, file.getName());
            fileSF.setDestinationFolder(folder);
            FileInputStream fis = new FileInputStream(file);
            fileSF.setContentStream(fis);
            fileSF.create();
        }
    }

    public static void uploadDir(String sourcePath, FolderObjectClientBean target) throws Exception {
        InstallUtil.uploadDir(sourcePath, target, true);
    }

    public static void uploadDir(String sourcePath, FolderObjectClientBean target, boolean replaceAll) throws Exception {
        for (String name : new File(sourcePath).list()) {
            File file = new File(sourcePath, name);
            String path = file.getPath();
            if (file.isDirectory()) {
                InstallUtil.uploadDir(path, target.createPath(name), replaceAll);
                continue;
            }
            InstallUtil.uploadFile(file, target, replaceAll);
        }
    }

    public static void uploadFile(File file, FolderObjectClientBean target) throws Exception {
        InstallUtil.uploadFile(file, target, true);
    }

    public static void uploadFile(File file, FolderObjectClientBean target, boolean replaceAll) throws Exception {
        ContentInterface existing = (ContentInterface)((Object)target.getItem(file.getName()));
        Date lastModified = new Date(file.lastModified());
        if (existing == null) {
            FileObjectSessionFacade fosf = new FileObjectSessionFacade(target.getSessionController());
            fosf.setWithTransaction(true);
            fosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, file.getName());
            fosf.setDestinationFolder(target);
            fosf.setContentStream(new FileInputStream(file));
            existing = (ContentInterface)((Object)fosf.create());
            existing.setLastContentModifyDate(lastModified);
        } else if (replaceAll || lastModified.getTime() != existing.getLastContentModifyDate().getTime()) {
            existing.setContent(new FileInputStream(file));
            existing.setLastContentModifyDate(lastModified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionObjectClientBean getInstalledModuleVersion(SessionController sessionController, String moduleName) {
        Object object = versionCheckSync;
        synchronized (object) {
            VersionObjectClientBean version = null;
            try {
                SuperObjectClientBean[] soArr = sessionController.getSuperObjectByAttribute(sessionController, "MODUL", moduleName, false, sessionController.getClassObject(VersionObjectClientBean.CLASS_NAME));
                if (soArr != null && soArr.length > 0) {
                    version = (VersionObjectClientBean)soArr[0];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return version;
        }
    }

    public static void forEachUser(SessionController sessionController, String msg, UserHandler handler) throws Exception {
        long newId;
        long minId = 0L;
        long maxId = newId = sessionController.getSequenceId().longValue();
        long startId = minId;
        long endId = InstallUtil.calcEndId(startId, maxId);
        AgorumCoreStartDescLogger startLog = new AgorumCoreStartDescLogger();
        DecimalFormat df = new DecimalFormat(",##0.00");
        try (Connection conn = new ConnectionUtils().getConnection();){
            while (endId != -1L) {
                long amount = 0L;
                try (PreparedStatement pStmt = conn.prepareStatement("select a.id from globalobject a, directoryuserobject b where a.id=b.id and a.id >= ? and a.id < ?");){
                    pStmt.setLong(1, startId);
                    pStmt.setLong(2, endId);
                    try (ResultSet resultSet = pStmt.executeQuery();){
                        while (resultSet.next()) {
                            long id = resultSet.getLong(1);
                            handler.run((DirectoryUserObjectClientBean)sessionController.getGlobalObjectById(id));
                            ++amount;
                        }
                    }
                }
                double percent = (double)endId / (double)maxId * 100.0;
                System.out.println(msg + ": (" + startId + " - " + endId + ", max=" + maxId + "), amount updated=" + amount);
                startLog.writeDescToFile(msg, df.format(percent) + "% (" + startId + " - " + endId + " / " + maxId + "), amount updated=" + amount);
                startId = endId;
                endId = InstallUtil.calcEndId(startId, maxId);
            }
        }
    }

    private static long calcEndId(long startId, long maxId) {
        long newEndId = maxId + 1L;
        newEndId = startId >= maxId ? -1L : (startId + 50000L > maxId ? maxId + 1L : startId + 50000L);
        return newEndId;
    }

    public static void applyPreviewStandardSettings(SessionController sc) {
        block24: {
            try (MetaDbUtil mdu = new MetaDbUtil(sc, "MAIN_MODULE_MANAGEMENT/roi/control/modules/Preview", true);){
                if (!mdu.getBoolean("Active", false) || !mdu.getBoolean("PreviewDefaultsApplied", false)) break block24;
                try (MetaDbUtil mdv = new MetaDbUtil(sc, BASE_KEY_PREVIEW);){
                    mdv.setBoolean("CreatePreviewInBackground", false);
                    mdv.setInt("MasterPreviewExpirationPeriod", 1);
                    mdv.setInt("ThumbPreviewExpirationPeriod", 1);
                    mdv.setBoolean("PreviewDefaultsApplied", true);
                    mdv.commit();
                }
            }
        }
    }

    public static interface UserHandler {
        public void run(DirectoryUserObjectClientBean var1) throws Exception;
    }
}

