/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.commons.utils.TempFile;
import agorum.roi.ejb.common.ContentInterface;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class ImageUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void correctOrientation(ContentInterface ci) throws Exception {
        block59: {
            try (BufferedInputStream bis = new BufferedInputStream(ci.getContentStream());){
                JpegDirectory jpegDirectory;
                Metadata metadata = null;
                try {
                    metadata = ImageMetadataReader.readMetadata((InputStream)bis);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (metadata == null) break block59;
                int width = -1;
                int height = -1;
                int orientation = 1;
                Directory dir = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
                if (dir != null && (jpegDirectory = (JpegDirectory)metadata.getFirstDirectoryOfType(JpegDirectory.class)) != null) {
                    try {
                        if (dir.containsTag(274)) {
                            orientation = dir.getInt(274);
                        }
                    }
                    catch (MetadataException me) {
                        me.printStackTrace();
                    }
                    width = jpegDirectory.getImageWidth();
                    height = jpegDirectory.getImageHeight();
                }
                if (orientation == true || width <= 0 || height <= 0) break block59;
                AffineTransform transform = ImageUtils.getExifTransformation(orientation, width, height);
                System.setProperty("com.sun.media.jai.disableMediaLib", "true");
                BufferedImage image = null;
                try (InputStream fis = ci.getContentStream();){
                    image = ImageIO.read(fis);
                }
                if (image == null) break block59;
                ParameterBlock paramBlock = new ParameterBlock();
                paramBlock.addSource(image);
                paramBlock.add(transform);
                RenderedOp rotated = JAI.create((String)"affine", (ParameterBlock)paramBlock);
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
                ImageWriter writer = iter.next();
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(0.95f);
                File tmpFile = TempFile.createTempFile((long)36000000L);
                try {
                    try (FileImageOutputStream out = new FileImageOutputStream(tmpFile);){
                        writer.setOutput(out);
                        writer.write(null, new IIOImage((RenderedImage)rotated, null, null), iwp);
                        writer.dispose();
                    }
                    var17_26 = null;
                    try (FileInputStream is = new FileInputStream(tmpFile);){
                        ci.setContent(is);
                    }
                    catch (Throwable throwable) {
                        var17_26 = throwable;
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    tmpFile.delete();
                }
            }
        }
    }

    private static AffineTransform getExifTransformation(int orientation, int width, int height) {
        AffineTransform t = new AffineTransform();
        switch (orientation) {
            case 1: {
                break;
            }
            case 2: {
                t.scale(-1.0, 1.0);
                t.translate(-width, 0.0);
                break;
            }
            case 3: {
                t.translate(width, height);
                t.rotate(Math.PI);
                break;
            }
            case 4: {
                t.scale(1.0, -1.0);
                t.translate(0.0, -height);
                break;
            }
            case 5: {
                t.rotate(-1.5707963267948966);
                t.scale(-1.0, 1.0);
                break;
            }
            case 6: {
                t.translate(height, 0.0);
                t.rotate(1.5707963267948966);
                break;
            }
            case 7: {
                t.scale(-1.0, 1.0);
                t.translate(-height, 0.0);
                t.translate(0.0, width);
                t.rotate(4.71238898038469);
                break;
            }
            case 8: {
                t.translate(0.0, width);
                t.rotate(4.71238898038469);
            }
        }
        return t;
    }
}

