/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.common.SessionController;

public class GenericCacheUtils {
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT";
    private static final String METADB_GENERICCACHE = "genericcache";
    private String modulName;
    private String cacheMetaDbName;
    private MetaDb metaDb;

    public GenericCacheUtils(SessionController sessionController) {
        try {
            this.metaDb = sessionController.getMetaDbInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public GenericCache getGenericCache(String modulName, String cacheMetaDbName, String cacheInstanceName, int maxItemsDefault, int purgeCacheIntervalDefault, int cacheEntryLifeTimeDefault) throws Exception {
        this.modulName = modulName;
        this.cacheMetaDbName = cacheMetaDbName;
        GenericCache gc = null;
        try {
            int iMaxItems = this.getMaxItems();
            int iPurgeCacheInterval = this.getPurgeCacheInterval();
            int iCacheEntryLifeTime = this.getCacheEntryLifeTime();
            gc = GenericCache.getInstance((Object)cacheInstanceName, (int)iMaxItems, (int)iPurgeCacheInterval, (int)iCacheEntryLifeTime);
        }
        catch (Throwable e) {
            gc = GenericCache.getInstance((Object)cacheInstanceName, (int)maxItemsDefault, (int)purgeCacheIntervalDefault, (int)cacheEntryLifeTimeDefault);
        }
        return gc;
    }

    private String getMetaDbBasePath() {
        return "MAIN_MODULE_MANAGEMENT/" + this.modulName + "/" + METADB_GENERICCACHE + "/" + this.cacheMetaDbName;
    }

    private int getMaxItems() throws Throwable {
        return this.getIntEntry("MaxItems");
    }

    private int getPurgeCacheInterval() throws Throwable {
        return this.getIntEntry("PurgeCacheInterval");
    }

    private int getCacheEntryLifeTime() throws Throwable {
        return this.getIntEntry("CacheEntryLifeTime");
    }

    private int getIntEntry(String entryName) throws Throwable {
        return Integer.parseInt(this.metaDb.getSimplePropertyValue(this.getMetaDbBasePath() + "/" + entryName)[0]);
    }
}

