/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.CryptKeyController;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.util.MetaDbUtil;
import dev.samstevens.totp.code.CodeGenerator;
import dev.samstevens.totp.code.DefaultCodeGenerator;
import dev.samstevens.totp.code.DefaultCodeVerifier;
import dev.samstevens.totp.code.HashingAlgorithm;
import dev.samstevens.totp.qr.QrData;
import dev.samstevens.totp.secret.DefaultSecretGenerator;
import dev.samstevens.totp.time.SystemTimeProvider;
import dev.samstevens.totp.time.TimeProvider;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MultiFactorAuthentication {
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/mfa/";
    private static final String METADB_REQUIRED = "MAIN_MODULE_MANAGEMENT/mfa/Required";
    private static final String METADB_EXCEPTIONS = "MAIN_MODULE_MANAGEMENT/mfa/Exceptions";
    private static final String METADB_SECRETS = "MAIN_MODULE_MANAGEMENT/mfa/secrets/";
    private static final int TIME_PERIOD = 30;
    private static final int ALLOWED_DISCREPANCY = 2;
    private static final HashingAlgorithm HASHING_ALGORITHM = HashingAlgorithm.SHA1;
    private static final int DIGITS = 6;
    private static final Map<String, String> temporarySecrets = new ConcurrentHashMap<String, String>();

    private static boolean check(CredentialObject cred, String secret) {
        String password = cred.getPassWord();
        if (password == null) {
            return false;
        }
        int otpStart = password.length() - 6;
        if (otpStart < 0) {
            return false;
        }
        String code = password.substring(otpStart);
        DefaultCodeVerifier verifier = new DefaultCodeVerifier((CodeGenerator)new DefaultCodeGenerator(HASHING_ALGORITHM, 6), (TimeProvider)new SystemTimeProvider());
        verifier.setTimePeriod(30);
        verifier.setAllowedTimePeriodDiscrepancy(2);
        if (verifier.isValidCode(secret, code)) {
            cred.setPassWord(password.substring(0, otpStart));
            return true;
        }
        return false;
    }

    private static String url(CredentialObject cred) {
        String secret = new DefaultSecretGenerator().generate();
        temporarySecrets.put(cred.getUserName().toLowerCase(Locale.ROOT), secret);
        return new QrData.Builder().label(cred.getUserName()).secret(secret).issuer("agorum core").algorithm(HASHING_ALGORITHM).digits(6).period(30).build().getUri();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isRequiredFor(String module) {
        String[] required = SessionControllerAdmin.getService(MultiFactorAuthentication.class).getMetaDbInstance().getSimplePropertyValue(METADB_REQUIRED);
        if (required == null) return false;
        if (!Arrays.stream(required).anyMatch(module::equalsIgnoreCase)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String check(CredentialObject cred) throws Exception {
        String secret;
        String username = cred.getUserName();
        String password = cred.getPassWord();
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            return null;
        }
        if (!MultiFactorAuthentication.isRequiredFor(cred.getModulInfo())) {
            return null;
        }
        username = username.toLowerCase(Locale.ROOT);
        SessionController sc = SessionControllerAdmin.getService(MultiFactorAuthentication.class);
        MetaDb mdb = sc.getMetaDbInstance();
        String[] exceptions = mdb.getSimplePropertyValue(METADB_EXCEPTIONS);
        if (exceptions != null) {
            if (Arrays.stream(exceptions).anyMatch(username::equalsIgnoreCase)) {
                return null;
            }
        }
        if ((secret = mdb.getString(METADB_SECRETS + username)) == null) {
            secret = temporarySecrets.get(username);
            if (secret == null || !MultiFactorAuthentication.check(cred, secret)) return MultiFactorAuthentication.url(cred);
            try (MetaDbUtil mdu = new MetaDbUtil(sc, METADB_SECRETS);){
                mdu.setString(username, secret);
                mdu.encrypt(username);
                mdu.commit();
            }
            temporarySecrets.remove(username);
            return null;
        }
        if (MultiFactorAuthentication.check(cred, new CryptKeyController().decrypt(secret, "metadb", sc))) return null;
        throw ExceptionUtils.get("Multi-factor authentication failed", "agorum.roi.remote.exception.InvalidPassword", 31);
    }

    public static class Setup
    extends Exception {
        private final String url;

        public Setup(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

