/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.behavior;

import agorum.roi.behavior.BaseBehavior;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.scripting.EngineContext;

public class ScriptBehavior
extends BaseBehavior {
    private static final String BASE_KEY = ScriptBehavior.class.getName();
    private SessionController sca;
    private GlobalObjectClientBean object;
    private String basePath;
    private String updateKey;

    @Override
    public void init(SessionController sca, GlobalObjectClientBean object, String basePath) throws Exception {
        this.sca = sca;
        this.object = object;
        this.basePath = basePath;
        this.updateKey = BASE_KEY + "_" + object.getID();
    }

    @Override
    public void afterCreate(GlobalObjectClientBeanDefinition def) throws Exception {
        this.run("AfterCreate", def, null, null, false);
    }

    @Override
    public void beforeUpdate(GlobalObjectClientBeanDefinition def) throws Exception {
        if (Transaction.get(this.updateKey) == null) {
            Transaction.put(this.updateKey, "");
            try {
                this.run("BeforeUpdate", def, null, null, false);
            }
            finally {
                Transaction.remove(this.updateKey);
            }
        }
    }

    @Override
    public void afterUpdate(GlobalObjectClientBeanDefinition def) throws Exception {
        if (Transaction.get(this.updateKey) == null) {
            Transaction.put(this.updateKey, "");
            try {
                this.run("AfterUpdate", def, null, null, false);
            }
            finally {
                Transaction.remove(this.updateKey);
            }
        }
    }

    @Override
    public void beforeDelete(GlobalObjectClientBeanDefinition def, boolean trash) throws Exception {
        this.run("BeforeDelete", def, null, null, trash);
    }

    @Override
    public void beforeAssociateLeft(RelationObjectClientBeanDefinition relationDef, GlobalObjectClientBean other) throws Exception {
        this.run("BeforeAssociateLeft", relationDef, other, null, false);
    }

    @Override
    public void beforeAssociateRight(RelationObjectClientBeanDefinition relationDef, GlobalObjectClientBean other) throws Exception {
        this.run("BeforeAssociateRight", relationDef, other, null, false);
    }

    @Override
    public void afterAssociateLeft(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        this.run("AfterAssociateLeft", null, other, relation, false);
    }

    @Override
    public void afterAssociateRight(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        this.run("AfterAssociateRight", null, other, relation, false);
    }

    @Override
    public void beforeDissociateLeft(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        this.run("BeforeDissociateLeft", null, other, relation, false);
    }

    @Override
    public void beforeDissociateRight(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        this.run("BeforeDissociateRight", null, other, relation, false);
    }

    private void run(String name, SuperObjectClientBeanDefinition def, GlobalObjectClientBean other, RelationObjectClientBean relation, boolean trash) throws Exception {
        String scriptId = MetaDbSuperCache.getSimplePropertyValue(this.sca, this.basePath + name);
        if (scriptId == null) {
            return;
        }
        ContentInterface script = (ContentInterface)((Object)this.sca.findGlobalObjectByPathOrId(scriptId));
        if (script == null) {
            return;
        }
        EngineContext context = new EngineContext(false, this.sca);
        context.put("sessionController", this.object.getSessionController());
        context.put("sc", this.object.getSessionController());
        context.put("sessionControllerAdmin", this.sca);
        context.put("sca", this.sca);
        context.put("object", this.object);
        context.put("def", def);
        context.put("other", other);
        context.put("relation", relation);
        context.put("trash", trash);
        context.exec(script);
    }
}

