/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.behavior;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.logging.Log;
import agorum.roi.behavior.Behavior;
import agorum.roi.behavior.NullBehavior;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import java.util.HashMap;
import java.util.Map;

public final class BehaviorManager {
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/roi/control/behavior/";
    private static final Behavior nullBehavior = new NullBehavior();
    private static final Map<String, Class<Behavior>> behaviorClassCache = new HashMap<String, Class<Behavior>>();

    private BehaviorManager() {
    }

    public static Behavior getBehavior(GlobalObjectClientBean object) throws Exception {
        return BehaviorManager.getBehavior(object, object.getBehaviorName());
    }

    public static Behavior getBehavior(GlobalObjectClientBean object, String behaviorName) throws Exception {
        if (behaviorName == null || behaviorName.isEmpty()) {
            return nullBehavior;
        }
        SessionController sessionController = SessionControllerAdmin.getSessionControllerAdmin("BehaviorManager");
        Class<Behavior> behaviorClass = behaviorClassCache.get(behaviorName);
        if (behaviorClass == null) {
            String behaviorClassName;
            MetaDb metaDb = sessionController.getMetaDbInstance();
            try {
                behaviorClassName = metaDb.getSimplePropertyValue(METADB_BASE + behaviorName + "/Class")[0];
            }
            catch (Exception e) {
                Log.error((String)("Could not load behavior " + behaviorName), (Throwable)e);
                return nullBehavior;
            }
            try {
                behaviorClass = Class.forName(behaviorClassName);
            }
            catch (Exception e) {
                Log.error((String)("Could not create behavior " + behaviorName), (Throwable)e);
                return nullBehavior;
            }
            behaviorClassCache.put(behaviorName, behaviorClass);
        }
        Behavior behavior = behaviorClass.newInstance();
        behavior.init(sessionController, object, METADB_BASE + behaviorName + "/");
        return behavior;
    }

    private static boolean isInSync(SessionController sessionController) {
        return sessionController.isInSychronization();
    }

    public static void afterCreate(GlobalObjectClientBean object, GlobalObjectClientBeanDefinition def) throws Exception {
        Behavior b = object.getBehavior();
        if (!BehaviorManager.isInSync(object.getSessionController()) || b.runInSync()) {
            b.afterCreate(def);
        }
    }

    public static void beforeUpdate(GlobalObjectClientBean object, GlobalObjectClientBeanDefinition def) throws Exception {
        Behavior b = object.getBehavior();
        if (!BehaviorManager.isInSync(object.getSessionController()) || b.runInSync()) {
            b.beforeUpdate(def);
        }
    }

    public static void afterUpdate(GlobalObjectClientBean object, GlobalObjectClientBeanDefinition def) throws Exception {
        Behavior b = object.getBehavior();
        if (!BehaviorManager.isInSync(object.getSessionController()) || b.runInSync()) {
            b.afterUpdate(def);
        }
    }

    public static void beforeDelete(GlobalObjectClientBean object, GlobalObjectClientBeanDefinition def, boolean trash) throws Exception {
        Behavior b = object.getBehavior();
        if (!BehaviorManager.isInSync(object.getSessionController()) || b.runInSync()) {
            b.beforeDelete(def, trash);
        }
    }

    public static void beforeCreateRelation(RelationObjectClientBeanDefinition relationDef, GlobalObjectClientBean leftObject, GlobalObjectClientBean rightObject) throws Exception {
        Behavior b = leftObject.getBehavior();
        if (!BehaviorManager.isInSync(leftObject.getSessionController()) || b.runInSync()) {
            b.beforeAssociateRight(relationDef, rightObject);
        }
        b = rightObject.getBehavior();
        if (!BehaviorManager.isInSync(rightObject.getSessionController()) || b.runInSync()) {
            b.beforeAssociateLeft(relationDef, leftObject);
        }
    }

    public static void afterCreateRelation(RelationObjectClientBean relation, GlobalObjectClientBean leftObject, GlobalObjectClientBean rightObject) throws Exception {
        Behavior b = leftObject.getBehavior();
        if (!BehaviorManager.isInSync(leftObject.getSessionController()) || b.runInSync()) {
            b.afterAssociateRight(relation, rightObject);
        }
        b = rightObject.getBehavior();
        if (!BehaviorManager.isInSync(rightObject.getSessionController()) || b.runInSync()) {
            b.afterAssociateLeft(relation, leftObject);
        }
    }

    public static void beforeDeleteRelation(RelationObjectClientBean relation, GlobalObjectClientBean leftObject, GlobalObjectClientBean rightObject) throws Exception {
        Behavior b = leftObject.getBehavior();
        if (!BehaviorManager.isInSync(leftObject.getSessionController()) || b.runInSync()) {
            b.beforeDissociateRight(relation, rightObject);
        }
        b = rightObject.getBehavior();
        if (!BehaviorManager.isInSync(rightObject.getSessionController()) || b.runInSync()) {
            b.beforeDissociateLeft(relation, leftObject);
        }
    }
}

