/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.auth.netlogon;

import agorum.roi.auth.netlogon.message.NetrLogonSamLogon;
import agorum.roi.auth.netlogon.message.NetrServerAuthenticate3;
import agorum.roi.auth.netlogon.message.NetrServerReqChallenge;
import agorum.roi.auth.netlogon.object.NetlogonAuthenticator;
import agorum.roi.auth.netlogon.object.NetlogonIdentityInfo;
import agorum.roi.auth.netlogon.object.NetlogonNetworkInfo;
import agorum.roi.auth.netlogon.object.NetlogonValidationSamInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import jcifs.dcerpc.DcerpcBinding;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.DcerpcMessage;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.util.DES;
import jcifs.util.Encdec;
import jcifs.util.HMACT64;
import jcifs.util.MD4;

public class NetlogonConnection
implements AutoCloseable {
    private static final SecureRandom rand = new SecureRandom();
    private static int negotiateFlags = 0x600FFFFF;
    private byte[] sessionKey;
    private byte[] clientCredential;
    private DcerpcHandle dcerpcHandle;
    private String domainControllerName;
    private String serviceMachineName;

    public NetlogonConnection(String domainController, String domainControllerName, String domain, String serviceMachineName, String servicePass) throws IOException, NoSuchAlgorithmException {
        this.domainControllerName = domainControllerName;
        this.serviceMachineName = serviceMachineName;
        String serviceAccountName = serviceMachineName + "$";
        String serviceAccount = domain + "\\" + serviceAccountName;
        NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(null, serviceAccount, servicePass);
        this.dcerpcHandle = DcerpcHandle.getHandle((String)("ncacn_np:" + domainController + "[\\PIPE\\NETLOGON]"), (NtlmPasswordAuthentication)auth);
        this.dcerpcHandle.bind();
        byte[] clientChallenge = new byte[8];
        rand.nextBytes(clientChallenge);
        NetrServerReqChallenge nsrc = new NetrServerReqChallenge(domainControllerName, serviceMachineName, clientChallenge, new byte[8]);
        this.dcerpcHandle.sendrecv((DcerpcMessage)nsrc);
        MD4 md4 = new MD4();
        md4.update(servicePass.getBytes(StandardCharsets.UTF_16LE));
        this.sessionKey = this.computeSessionKey(md4.digest(), clientChallenge, nsrc.getServerChallenge());
        this.clientCredential = this.computeNetlogonCredential(clientChallenge);
        NetrServerAuthenticate3 nsa3 = new NetrServerAuthenticate3(domainControllerName, serviceAccountName, 2, serviceMachineName, this.clientCredential, new byte[8], negotiateFlags);
        this.dcerpcHandle.sendrecv((DcerpcMessage)nsa3);
        byte[] serverCredential = this.computeNetlogonCredential(nsrc.getServerChallenge());
        if (!Arrays.equals(serverCredential, nsa3.getServerCredential())) {
            throw new IOException("Server authentication failed");
        }
    }

    @Override
    public void close() throws IOException {
        this.dcerpcHandle.close();
    }

    public NetrLogonSamLogon logon(String domain, String user, String workstation, byte[] serverChallenge, byte[] ntResponse, byte[] lmResponse) throws DcerpcException, IOException {
        NetlogonAuthenticator na = this.computeNetlogonAuthenticator();
        NetlogonIdentityInfo nii = new NetlogonIdentityInfo(domain, 2080, 0, 0, user, workstation);
        NetlogonNetworkInfo nni = new NetlogonNetworkInfo(nii, serverChallenge, ntResponse, lmResponse);
        NetrLogonSamLogon nlsl = new NetrLogonSamLogon(this.domainControllerName, this.serviceMachineName, na, new NetlogonAuthenticator(), 2, nni, 2, new NetlogonValidationSamInfo(), 0);
        this.dcerpcHandle.sendrecv((DcerpcMessage)nlsl);
        return nlsl;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    private NetlogonAuthenticator computeNetlogonAuthenticator() {
        int timestamp = (int)System.currentTimeMillis();
        int input = Encdec.dec_uint32le((byte[])this.clientCredential, (int)0) + timestamp;
        Encdec.enc_uint32le((int)input, (byte[])this.clientCredential, (int)0);
        byte[] credential = this.computeNetlogonCredential(this.clientCredential);
        return new NetlogonAuthenticator(credential, timestamp);
    }

    private byte[] computeNetlogonCredential(byte[] input) {
        byte[] k1 = new byte[7];
        byte[] k2 = new byte[7];
        System.arraycopy(this.sessionKey, 0, k1, 0, 7);
        System.arraycopy(this.sessionKey, 7, k2, 0, 7);
        DES k3 = new DES(k1);
        DES k4 = new DES(k2);
        byte[] output1 = new byte[8];
        byte[] output2 = new byte[8];
        k3.encrypt(input, output1);
        k4.encrypt(output1, output2);
        return output2;
    }

    private byte[] computeSessionKey(byte[] sharedSecret, byte[] clientChallenge, byte[] serverChallenge) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] zeroes = new byte[]{0, 0, 0, 0};
        messageDigest.update(zeroes, 0, 4);
        messageDigest.update(clientChallenge, 0, 8);
        messageDigest.update(serverChallenge, 0, 8);
        HMACT64 hmact64 = new HMACT64(sharedSecret);
        hmact64.update(messageDigest.digest());
        return hmact64.digest();
    }

    static {
        DcerpcBinding.addInterface((String)"netlogon", (String)"12345678-1234-abcd-ef00-01234567cffb:1.0");
    }
}

