/*
 * Decompiled with CFR 0.152.
 */
package agorum.api.common.exceptions;

import agorum.api.common.exceptions.authentication.ApiAccessDeniedException;
import agorum.api.common.exceptions.authentication.ApiAuthenticationNeededException;
import agorum.api.common.exceptions.server.ApiBadGatewayException;
import agorum.api.common.exceptions.server.ApiGatewayTimeoutException;
import agorum.api.common.exceptions.server.ApiInternalServerErrorException;
import agorum.api.common.exceptions.server.ApiNotImplementedException;
import agorum.api.common.exceptions.server.ApiUnknownErrorException;
import agorum.api.common.exceptions.usage.ApiConflictException;
import agorum.api.common.exceptions.usage.ApiInvalidParameterException;
import agorum.api.common.exceptions.usage.ApiMissingParameterException;
import agorum.api.common.exceptions.usage.ApiNotFoundException;
import agorum.api.common.exceptions.usage.ApiTimeoutException;
import agorum.api.common.exceptions.usage.ApiTypeMismatchException;
import agorum.api.common.statistic.ApiStatistic;
import agorum.roi.exception.RoiException;
import org.mozilla.javascript.WrappedException;

public abstract class ApiException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int errorClass;
    private int errorCode;
    private int errorKey;

    public ApiException(int errorClass, int errorCode, String message) {
        this(errorClass, errorCode, 0, message);
    }

    public ApiException(int errorClass, int errorCode, int errorKey, String message) {
        super(message);
        this.errorClass = errorClass;
        this.errorCode = errorCode;
        this.errorKey = errorKey;
    }

    public ApiException(int errorClass, int errorCode, Throwable cause) {
        this(errorClass, errorCode, 0, cause);
    }

    public ApiException(int errorClass, int errorCode, int errorKey, Throwable cause) {
        super(cause.getMessage(), cause);
        this.errorClass = errorClass;
        this.errorCode = errorCode;
        this.errorKey = errorKey;
    }

    public ApiException(int errorClass, int errorCode, String message, Throwable cause) {
        this(errorClass, errorCode, 0, message, cause);
    }

    public ApiException(int errorClass, int errorCode, int errorKey, String message, Throwable cause) {
        super(ApiException.chain(message, cause), cause);
        this.errorClass = errorClass;
        this.errorCode = errorCode;
        this.errorKey = errorKey;
    }

    public void setErrorClass(int errorClass) {
        this.errorClass = errorClass;
    }

    public int getErrorClass() {
        return this.errorClass;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getErrorKey() {
        return this.errorKey;
    }

    public void setErrorKey(int errorKey) {
        this.errorKey = errorKey;
    }

    public String toJson() {
        return "{\"success\":false,\"errorClass\":" + this.errorClass + ",\"errorCode\":" + this.errorCode + ",\"errorKey\":" + this.errorKey + ",\"message\":\"" + this.getMessage() + "\"}";
    }

    public static ApiException getInstance(int errorClass, int errorCode, int errorKey, String message) {
        switch (errorClass) {
            case 1: {
                switch (errorCode) {
                    case 1: {
                        return new ApiAuthenticationNeededException(errorKey, message);
                    }
                    case 2: {
                        return new ApiAccessDeniedException(errorKey, message);
                    }
                }
            }
            case 2: {
                switch (errorCode) {
                    case 1: {
                        return new ApiNotFoundException(errorKey, message);
                    }
                    case 2: {
                        return new ApiTypeMismatchException(errorKey, message);
                    }
                    case 3: {
                        return new ApiMissingParameterException(errorKey, message);
                    }
                    case 4: {
                        return new ApiInvalidParameterException(errorKey, message);
                    }
                    case 5: {
                        return new ApiConflictException(errorKey, message);
                    }
                    case 6: {
                        return new ApiTimeoutException(errorKey, message);
                    }
                }
            }
            case 3: {
                switch (errorCode) {
                    case 1: {
                        return new ApiInternalServerErrorException(errorKey, message);
                    }
                    case 2: {
                        return new ApiNotImplementedException(errorKey, message);
                    }
                    case 3: {
                        return new ApiUnknownErrorException(errorKey, message);
                    }
                    case 4: {
                        return new ApiBadGatewayException(errorKey, message);
                    }
                    case 5: {
                        return new ApiGatewayTimeoutException(errorKey, message);
                    }
                }
            }
        }
        return new ApiUnknownErrorException(errorKey, message);
    }

    private static final String chain(String message, Throwable cause) {
        String causeMessage;
        if (cause != null && (causeMessage = cause.getMessage()) != null && !causeMessage.equals(message)) {
            return message + " (" + causeMessage + ")";
        }
        return message;
    }

    public static ApiException get(Throwable t) {
        if (t instanceof ApiException) {
            return (ApiException)t;
        }
        if (t instanceof IllegalArgumentException) {
            return new ApiInvalidParameterException(t);
        }
        if (t instanceof RoiException) {
            RoiException re = (RoiException)t;
            switch (re.getErrorCode()) {
                case 3: {
                    return new ApiNotImplementedException(re.getErrorMessage(), t);
                }
                case 20: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 21: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 22: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 23: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 24: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 30: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 31: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 32: {
                    return new ApiAuthenticationNeededException(re.getErrorMessage(), t);
                }
                case 33: {
                    return new ApiAuthenticationNeededException(re.getErrorMessage(), t);
                }
                case 34: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 70: {
                    return new ApiConflictException(re.getErrorMessage(), t);
                }
                case 71: {
                    return new ApiInternalServerErrorException(re.getErrorMessage(), t);
                }
                case 100: {
                    return new ApiNotFoundException(re.getErrorMessage(), t);
                }
                case 101: {
                    return new ApiNotFoundException(re.getErrorMessage(), t);
                }
                case 102: {
                    return new ApiNotFoundException(re.getErrorMessage(), t);
                }
                case 103: {
                    return new ApiNotFoundException(re.getErrorMessage(), t);
                }
                case 104: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 106: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 108: {
                    return new ApiInvalidParameterException(re.getErrorMessage(), t);
                }
                case 109: {
                    return new ApiInvalidParameterException(re.getErrorMessage(), t);
                }
                case 112: {
                    return new ApiNotFoundException(re.getErrorMessage(), t);
                }
                case 113: {
                    return new ApiInvalidParameterException(re.getErrorMessage(), t);
                }
                case 200: {
                    return new ApiConflictException(re.getErrorMessage(), t);
                }
                case 201: {
                    return new ApiNotFoundException(re.getErrorMessage(), t);
                }
                case 202: {
                    return new ApiConflictException(re.getErrorMessage(), t);
                }
                case 203: {
                    return new ApiConflictException(re.getErrorMessage(), t);
                }
                case 204: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 300: {
                    return new ApiConflictException(re.getErrorMessage(), t);
                }
                case 301: {
                    return new ApiNotFoundException(re.getErrorMessage(), t);
                }
                case 302: {
                    return new ApiInvalidParameterException(re.getErrorMessage(), t);
                }
                case 400: {
                    return new ApiConflictException(re.getErrorMessage(), t);
                }
                case 402: {
                    return new ApiConflictException(re.getErrorMessage(), t);
                }
                case 500: {
                    return new ApiGatewayTimeoutException(re.getErrorMessage(), t);
                }
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: 
                case 2009: 
                case 2010: 
                case 2011: 
                case 2012: {
                    return new ApiAccessDeniedException(re.getErrorMessage(), t);
                }
                case 2007: 
                case 2008: {
                    return new ApiInvalidParameterException(re.getErrorMessage(), t);
                }
                case 305: {
                    return new ApiAccessDeniedException(1, re.getErrorMessage(), t);
                }
            }
            return new ApiUnknownErrorException(re.getErrorMessage(), t);
        }
        if (t instanceof WrappedException && t.getCause() != null) {
            return ApiException.get(t.getCause());
        }
        return new ApiUnknownErrorException(t.getMessage() == null ? "Unknown exception" : t.getMessage(), t);
    }

    public static void handle(Exception e) throws ApiException {
        throw ApiException.get(e);
    }

    public static void log(Throwable cause) {
        ApiException apiException;
        ApiException apiException2 = apiException = cause instanceof ApiException ? (ApiException)cause : ApiException.get(cause);
        if (apiException instanceof ApiAuthenticationNeededException) {
            ApiStatistic.getInstance().debug(cause);
        } else if (apiException.getErrorClass() == 3) {
            ApiStatistic.getInstance().error(cause);
        } else {
            ApiStatistic.getInstance().warning(cause);
        }
    }

    @Deprecated
    public static ApiException getException(Exception e) {
        return ApiException.get(e);
    }

    @Deprecated
    public static void handleException(Exception e) throws ApiException {
        ApiException.handle(e);
    }
}

