/*
 * Decompiled with CFR 0.152.
 */
package agorum.api.common.beans.common;

import agorum.api.common.beans.adapters.PropertyDeserializer;
import agorum.api.common.beans.common.Property;
import agorum.api.common.beans.common.PropertyBoolean;
import agorum.api.common.beans.common.PropertyDouble;
import agorum.api.common.beans.common.PropertyLong;
import agorum.api.common.beans.common.PropertyMap;
import agorum.api.common.beans.common.PropertyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="PropertyArray")
@XmlType(name="PropertyArray")
public class PropertyArray
extends Property
implements Iterable<Property> {
    private static final long serialVersionUID = 1L;
    @XmlElementRefs(value={@XmlElementRef(name="PropertyLong", type=PropertyLong.class), @XmlElementRef(name="PropertyDouble", type=PropertyDouble.class), @XmlElementRef(name="PropertyBoolean", type=PropertyBoolean.class), @XmlElementRef(name="PropertyString", type=PropertyString.class), @XmlElementRef(name="PropertyArray", type=PropertyArray.class), @XmlElementRef(name="PropertyMap", type=PropertyMap.class)})
    @XmlElementWrapper(name="properties")
    private final List<Property> properties;

    public PropertyArray() {
        this.properties = new ArrayList<Property>();
    }

    public static PropertyArray fromString(String toParse) {
        try {
            return PropertyDeserializer.deserializeProperty(toParse).getArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PropertyArray(int initialCapacity) {
        this.properties = new ArrayList<Property>(initialCapacity);
    }

    public PropertyArray(List<Property> properties) {
        this.properties = properties;
    }

    public PropertyArray(Property ... properties) {
        this();
        this.properties.addAll(Arrays.asList(properties));
    }

    @Deprecated
    public PropertyArray(Object[] value) {
        this(value.length);
        for (Object obj : value) {
            this.properties.add(Property.valueOf(obj));
        }
    }

    public PropertyArray(String[] value) {
        this(value.length);
        for (String str : value) {
            this.properties.add(new PropertyString(str));
        }
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public PropertyMap getMap(int index) {
        return this.properties.get(index).getMap();
    }

    public PropertyArray getArray(int index) {
        return this.properties.get(index).getArray();
    }

    public void addObject(Object value) {
        this.add(Property.valueOf(value));
    }

    public void add(Object value) {
        this.add(Property.valueOf(value));
    }

    public void add(long value) {
        this.properties.add(new PropertyLong(value));
    }

    public void add(Long value) {
        this.properties.add(new PropertyLong(value));
    }

    public void add(Double value) {
        this.properties.add(new PropertyDouble(value));
    }

    public void add(Boolean value) {
        this.properties.add(new PropertyBoolean(value));
    }

    public void add(String value) {
        this.properties.add(new PropertyString(value));
    }

    @Override
    public PropertyArray getArray() {
        return this;
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean contains(Object o) {
        return this.properties.contains(o);
    }

    @Override
    public Iterator<Property> iterator() {
        return this.properties.iterator();
    }

    public Object[] toArray() {
        return this.properties.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.properties.toArray(a);
    }

    public boolean remove(Object o) {
        return this.properties.remove(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.properties.containsAll(c);
    }

    public boolean addAll(Collection<? extends Property> c) {
        return this.properties.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends Property> c) {
        return this.properties.addAll(index, c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.properties.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.properties.retainAll(c);
    }

    public void clear() {
        this.properties.clear();
    }

    public Property get(int index) {
        return this.properties.get(index);
    }

    public boolean add(Property value) {
        return this.properties.add(value);
    }

    public Property set(int index, Property element) {
        return this.properties.set(index, element);
    }

    public void add(int index, Property element) {
        this.properties.add(index, element);
    }

    public Property remove(int index) {
        return this.properties.remove(index);
    }

    public int indexOf(Object o) {
        return this.properties.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.properties.lastIndexOf(o);
    }

    public ListIterator<Property> listIterator() {
        return this.properties.listIterator();
    }

    public ListIterator<Property> listIterator(int index) {
        return this.properties.listIterator(index);
    }

    public List<Property> subList(int fromIndex, int toIndex) {
        return this.properties.subList(fromIndex, toIndex);
    }
}

