/*
 * Decompiled with CFR 0.152.
 */
package agorum.api.common.beans.adapters;

import agorum.api.common.beans.common.Property;
import agorum.api.common.beans.common.PropertyArray;
import agorum.api.common.beans.common.PropertyBoolean;
import agorum.api.common.beans.common.PropertyDouble;
import agorum.api.common.beans.common.PropertyLong;
import agorum.api.common.beans.common.PropertyMap;
import agorum.api.common.beans.common.PropertyString;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

public class PropertySerializer
extends JsonSerializer<Property> {
    public void serialize(Property property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        if (property instanceof PropertyLong) {
            PropertyLong propertyLong = (PropertyLong)property;
            jsonGenerator.writeNumber(propertyLong.getLong().longValue());
        } else if (property instanceof PropertyDouble) {
            PropertyDouble propertyDouble = (PropertyDouble)property;
            jsonGenerator.writeNumber(propertyDouble.getDouble().doubleValue());
        } else if (property instanceof PropertyBoolean) {
            PropertyBoolean propertyBoolean = (PropertyBoolean)property;
            jsonGenerator.writeBoolean(propertyBoolean.getBoolean().booleanValue());
        } else if (property instanceof PropertyString) {
            PropertyString propertyString = (PropertyString)property;
            jsonGenerator.writeString(propertyString.getString());
        } else if (property instanceof PropertyArray) {
            PropertyArray propertyArray = (PropertyArray)property;
            jsonGenerator.writeStartArray();
            for (Property element : propertyArray) {
                this.serialize(element, jsonGenerator, serializerProvider);
            }
            jsonGenerator.writeEndArray();
        } else if (property instanceof PropertyMap) {
            PropertyMap propertyMap = (PropertyMap)property;
            Map<String, Property> properties = propertyMap.getProperties();
            jsonGenerator.writeStartObject();
            for (Map.Entry<String, Property> entry : properties.entrySet()) {
                String key = entry.getKey();
                Property value = entry.getValue();
                jsonGenerator.writeFieldName(key);
                this.serialize(value, jsonGenerator, serializerProvider);
            }
            jsonGenerator.writeEndObject();
        } else if (property == null) {
            jsonGenerator.writeNull();
        }
    }
}

