/*
 * Decompiled with CFR 0.152.
 */
package agorum.api.common.beans.adapters;

import agorum.api.common.beans.common.Property;
import agorum.api.common.beans.common.PropertyArray;
import agorum.api.common.beans.common.PropertyBoolean;
import agorum.api.common.beans.common.PropertyDouble;
import agorum.api.common.beans.common.PropertyLong;
import agorum.api.common.beans.common.PropertyMap;
import agorum.api.common.beans.common.PropertyString;
import java.io.IOException;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

public class PropertyDeserializer
extends JsonDeserializer<Property> {
    private static final JsonFactory jsonFactory = new JsonFactory();

    public Property deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        return PropertyDeserializer.deserializeProperty(jsonParser, jsonParser.getCurrentToken());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Property deserializeProperty(String toParse) {
        try (JsonParser jsonParser = jsonFactory.createJsonParser(toParse);){
            Property property = PropertyDeserializer.deserializeProperty(jsonParser, jsonParser.nextToken());
            return property;
        }
        catch (Exception e) {
            return new PropertyString(toParse);
        }
    }

    public static Property deserializeProperty(JsonParser jsonParser, JsonToken nextToken) throws JsonParseException, IOException {
        if (nextToken == JsonToken.START_ARRAY) {
            PropertyArray propertyArray = new PropertyArray();
            nextToken = jsonParser.nextToken();
            while (nextToken != JsonToken.NOT_AVAILABLE && nextToken != JsonToken.END_ARRAY) {
                propertyArray.add(PropertyDeserializer.deserializeProperty(jsonParser, nextToken));
                nextToken = jsonParser.nextToken();
            }
            return propertyArray;
        }
        if (nextToken == JsonToken.START_OBJECT) {
            PropertyMap propertyMap = new PropertyMap();
            nextToken = jsonParser.nextToken();
            while (nextToken != JsonToken.NOT_AVAILABLE && nextToken != JsonToken.END_OBJECT) {
                String key = jsonParser.getText();
                Property value = PropertyDeserializer.deserializeProperty(jsonParser, jsonParser.nextToken());
                nextToken = jsonParser.nextToken();
                propertyMap.put(key, value);
            }
            return propertyMap;
        }
        if (nextToken == JsonToken.VALUE_STRING) {
            return new PropertyString(jsonParser.getText());
        }
        if (nextToken == JsonToken.VALUE_NUMBER_INT) {
            return new PropertyLong(jsonParser.getLongValue());
        }
        if (nextToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return new PropertyDouble(jsonParser.getDoubleValue());
        }
        if (nextToken == JsonToken.VALUE_FALSE || nextToken == JsonToken.VALUE_TRUE) {
            return new PropertyBoolean(jsonParser.getBooleanValue());
        }
        return null;
    }
}

